/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl;

import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.ogema.drivers.homematic.xmlrpc.hl.HomeMaticDriver;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HomeMatic;
import org.ogema.drivers.homematic.xmlrpc.ll.api.XmlRpcStruct;
import org.ogema.drivers.homematic.xmlrpc.ll.xmlrpc.MapXmlRpcStruct;
import org.slf4j.LoggerFactory;

public abstract class WriteAction {
    private final long firstTry = System.currentTimeMillis();
    private int tries = 0;
    private boolean success = false;
    long nextRun = this.firstTry;

    final long creationTimestamp() {
        return this.firstTry;
    }

    final int tries() {
        return this.tries;
    }

    final boolean writeSucceeded() {
        return this.success;
    }

    final boolean write() {
        if (!this.success) {
            ++this.tries;
            this.success = this.performWrite();
        }
        return this.success;
    }

    abstract String target();

    abstract boolean performWrite();

    static WriteAction createSetValue(final HomeMatic hm, final String address, final String valueKey, final Object value) {
        return new WriteAction(){

            @Override
            String target() {
                return valueKey + "@" + address;
            }

            @Override
            boolean performWrite() {
                try {
                    hm.setValue(address, valueKey, value);
                    return true;
                }
                catch (XmlRpcException ex) {
                    LoggerFactory.getLogger(HomeMaticDriver.class).warn("write failed (try {}) for {}@{} := {}", new Object[]{this.tries(), valueKey, address, value, ex});
                    return false;
                }
            }
        };
    }

    static WriteAction createAddLink(final HomeMatic hm, final String sender, final String receiver, final String name, final String description) {
        return new WriteAction(){

            @Override
            String target() {
                return sender + ">>" + receiver;
            }

            @Override
            boolean performWrite() {
                try {
                    hm.addLink(sender, receiver, name, description);
                    return true;
                }
                catch (XmlRpcException ex) {
                    LoggerFactory.getLogger(HomeMaticDriver.class).warn("addLink failed (try {}) for {} >> {}", new Object[]{this.tries(), sender, receiver, ex});
                    return false;
                }
            }
        };
    }

    static WriteAction createRemoveLink(final HomeMatic hm, final String sender, final String receiver) {
        return new WriteAction(){

            @Override
            String target() {
                return sender + ">|>" + receiver;
            }

            @Override
            boolean performWrite() {
                try {
                    hm.removeLink(sender, receiver);
                    return true;
                }
                catch (XmlRpcException ex) {
                    LoggerFactory.getLogger(HomeMaticDriver.class).warn("removeLink failed (try {}) for {} >|> {}", new Object[]{this.tries(), sender, receiver, ex});
                    return false;
                }
            }
        };
    }

    static WriteAction createPutParamset(final HomeMatic hm, final String address, final String set, final Map<String, Object> values) {
        return new WriteAction(){

            @Override
            String target() {
                return "[" + set + "]@" + address;
            }

            @Override
            boolean performWrite() {
                try {
                    MapXmlRpcStruct valueStruct = new MapXmlRpcStruct(values);
                    hm.putParamset(address, set, (XmlRpcStruct)valueStruct);
                    return true;
                }
                catch (XmlRpcException ex) {
                    LoggerFactory.getLogger(HomeMaticDriver.class).warn("putParamset failed (try {}) for [{}]@{}", new Object[]{this.tries(), set, address, ex});
                    return false;
                }
            }
        };
    }
}

