/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl.channels;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ogema.core.model.Resource;
import org.ogema.core.model.ResourceList;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.simple.SingleValueResource;
import org.ogema.core.model.units.TemperatureResource;
import org.ogema.core.resourcemanager.ResourceStructureEvent;
import org.ogema.core.resourcemanager.ResourceStructureListener;
import org.ogema.core.resourcemanager.ResourceValueListener;
import org.ogema.drivers.homematic.xmlrpc.hl.api.AbstractDeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.HomeMaticConnection;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmDevice;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEvent;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEventListener;
import org.ogema.drivers.homematic.xmlrpc.ll.api.ParameterDescription;
import org.ogema.model.devices.buildingtechnology.Thermostat;
import org.ogema.model.sensors.TemperatureSensor;
import org.ogema.tools.resource.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpThermostatChannel
extends AbstractDeviceHandler {
    public static final String PARAM_TEMPERATUREFALL_MODUS = "TEMPERATUREFALL_MODUS";
    public static final String LINKED_TEMP_SENS_DECORATOR = "linkedTempSens";
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public IpThermostatChannel(HomeMaticConnection conn) {
        super(conn);
    }

    @Override
    public boolean accept(DeviceDescription desc) {
        return "HMIP-eTRV".equalsIgnoreCase(desc.getParentType()) && "HEATING_CLIMATECONTROL_TRANSCEIVER".equalsIgnoreCase(desc.getType());
    }

    @Override
    public void setup(HmDevice parent, DeviceDescription desc, Map<String, Map<String, ParameterDescription<?>>> paramSets) {
        final String deviceAddress = desc.getAddress();
        this.logger.debug("setup THERMOSTAT handler for address {} type {}", (Object)desc.getAddress(), (Object)desc.getType());
        String swName = ResourceUtils.getValidResourceName((String)("THERMOSTAT" + desc.getAddress()));
        Map<String, ParameterDescription<?>> values = paramSets.get(ParameterDescription.SET_TYPES.VALUES.name());
        if (values == null) {
            this.logger.warn("received no VALUES parameters for device {}", (Object)desc.getAddress());
            return;
        }
        Thermostat thermos = (Thermostat)parent.addDecorator(swName, Thermostat.class);
        this.conn.registerControlledResource(this.conn.getChannel(parent, deviceAddress), (Resource)thermos);
        HashMap<String, SingleValueResource> resources = new HashMap<String, SingleValueResource>();
        for (Map.Entry<String, ParameterDescription<?>> e : values.entrySet()) {
            switch (e.getKey()) {
                case "SET_POINT_TEMPERATURE": {
                    TemperatureResource reading = thermos.temperatureSensor().deviceFeedback().setpoint();
                    if (!reading.exists()) {
                        reading.create();
                        thermos.activate(true);
                    }
                    this.logger.debug("found supported thermostat parameter {} on {}", (Object)e.getKey(), (Object)desc.getAddress());
                    resources.put(e.getKey(), (SingleValueResource)reading);
                    break;
                }
                case "ACTUAL_TEMPERATURE": {
                    TemperatureResource reading = thermos.temperatureSensor().reading();
                    if (!reading.exists()) {
                        reading.create();
                        thermos.activate(true);
                    }
                    this.logger.debug("found supported thermostat parameter {} on {}", (Object)e.getKey(), (Object)desc.getAddress());
                    resources.put(e.getKey(), (SingleValueResource)reading);
                    break;
                }
                case "VALVE_STATE": {
                    TemperatureResource reading = thermos.valve().setting().stateFeedback();
                    if (!reading.exists()) {
                        reading.create();
                        thermos.activate(true);
                    }
                    this.logger.debug("found supported thermostat parameter {} on {}", (Object)e.getKey(), (Object)desc.getAddress());
                    resources.put(e.getKey(), (SingleValueResource)reading);
                    break;
                }
                case "BATTERY_STATE": {
                    TemperatureResource reading = thermos.battery().internalVoltage().reading();
                    if (!reading.exists()) {
                        reading.create();
                        thermos.activate(true);
                    }
                    this.logger.debug("found supported thermostat parameter {} on {}", (Object)e.getKey(), (Object)desc.getAddress());
                    resources.put(e.getKey(), (SingleValueResource)reading);
                    break;
                }
            }
        }
        TemperatureResource setpoint = thermos.temperatureSensor().settings().setpoint();
        setpoint.create();
        thermos.activate(true);
        setpoint.addValueListener((ResourceValueListener)new ResourceValueListener<TemperatureResource>(){

            public void resourceChanged(TemperatureResource t) {
                IpThermostatChannel.this.conn.performSetValue(deviceAddress, "SET_POINT_TEMPERATURE", t.getCelsius());
            }
        }, true);
        this.conn.addEventListener(new WeatherEventListener(resources, desc.getAddress()));
        this.setupHmParameterValues(thermos, parent.address().getValue());
        this.setupTempSensLinking(thermos);
    }

    private void setupHmParameterValues(Thermostat thermos, String address) {
        ResourceList masterParameters;
        if (address.lastIndexOf(":") != -1) {
            address = address.substring(0, address.lastIndexOf(":"));
        }
        if (!(masterParameters = (ResourceList)thermos.addDecorator("HmParametersMaster", ResourceList.class)).exists()) {
            masterParameters.setElementType(SingleValueResource.class);
            masterParameters.create();
        }
        IntegerResource tf_modus = (IntegerResource)masterParameters.getSubResource(PARAM_TEMPERATUREFALL_MODUS, IntegerResource.class);
        ParameterListener l = new ParameterListener(address);
        if (tf_modus.isActive()) {
            l.resourceChanged((SingleValueResource)tf_modus);
        }
        tf_modus.addValueListener((ResourceValueListener)l, true);
    }

    private void linkTempSens(Thermostat thermos, TemperatureSensor tempSens, boolean removeLink) {
        HmDevice thermostatChannel = this.conn.findControllingDevice((Resource)thermos);
        if (thermostatChannel == null) {
            this.logger.error("cannot find HomeMatic channel for Thermostat {}", (Object)thermos);
            return;
        }
        HmDevice thermostatDevice = this.conn.getToplevelDevice(thermostatChannel);
        HmDevice tempSensChannel = this.conn.findControllingDevice((Resource)tempSens);
        if (tempSensChannel == null) {
            this.logger.warn("cannot find HomeMatic channel for TemperatureSensor {}", (Object)tempSens);
            return;
        }
        if (!tempSensChannel.type().getValue().equalsIgnoreCase("WEATHER")) {
            this.logger.warn("HomeMatic channel controlling TemperatureSensor {} is not a WEATHER channel (type is {}). Cannot link", (Object)tempSens, (Object)tempSensChannel.type().getValue());
            return;
        }
        String thermosAddress = thermostatDevice.address().getValue() + ":6";
        String weatherAddress = tempSensChannel.address().getValue();
        if (removeLink) {
            this.conn.performRemoveLink(weatherAddress, thermosAddress);
        }
        this.logger.info("HomeMatic weather channel for TempSens {}: {}", (Object)tempSens, (Object)weatherAddress);
        this.conn.performAddLink(weatherAddress, thermosAddress, "TempSens", "external temperature sensor");
    }

    private void setupTempSensLinking(final Thermostat thermos) {
        TemperatureSensor tempSens = (TemperatureSensor)thermos.getSubResource(LINKED_TEMP_SENS_DECORATOR, TemperatureSensor.class);
        ResourceStructureListener l = new ResourceStructureListener(){

            public void resourceStructureChanged(ResourceStructureEvent event) {
                Resource added;
                if (event.getType() == ResourceStructureEvent.EventType.SUBRESOURCE_ADDED) {
                    Resource added2 = event.getChangedResource();
                    if (added2.getName().equals(IpThermostatChannel.LINKED_TEMP_SENS_DECORATOR) && added2 instanceof TemperatureSensor) {
                        IpThermostatChannel.this.linkTempSens(thermos, (TemperatureSensor)added2, false);
                    }
                } else if (event.getType() == ResourceStructureEvent.EventType.SUBRESOURCE_REMOVED && (added = event.getChangedResource()).getName().equals(IpThermostatChannel.LINKED_TEMP_SENS_DECORATOR) && added instanceof TemperatureSensor) {
                    IpThermostatChannel.this.linkTempSens(thermos, (TemperatureSensor)added, true);
                }
            }
        };
        thermos.addStructureListener(l);
        if (tempSens.isActive()) {
            this.linkTempSens(thermos, tempSens, false);
        }
    }

    class ParameterListener
    implements ResourceValueListener<SingleValueResource> {
        final String address;

        public ParameterListener(String address) {
            this.address = address;
        }

        public void resourceChanged(SingleValueResource resource) {
            String paramName = resource.getName();
            Integer resourceValue = null;
            if (resource instanceof IntegerResource) {
                resourceValue = ((IntegerResource)resource).getValue();
            } else {
                IpThermostatChannel.this.logger.warn("unsupported parameter type: " + resource);
            }
            HashMap<String, Object> parameterSet = new HashMap<String, Object>();
            parameterSet.put(paramName, resourceValue);
            IpThermostatChannel.this.conn.performPutParamset(this.address, "MASTER", parameterSet);
            IpThermostatChannel.this.logger.info("Parameter set 'MASTER' updated for {}: {}", (Object)this.address, parameterSet);
        }
    }

    class WeatherEventListener
    implements HmEventListener {
        final Map<String, SingleValueResource> resources;
        final String address;

        public WeatherEventListener(Map<String, SingleValueResource> resources, String address) {
            this.resources = resources;
            this.address = address;
        }

        public void event(List<HmEvent> events) {
            for (HmEvent e : events) {
                SingleValueResource res;
                if (!this.address.equals(e.getAddress()) || (res = this.resources.get(e.getValueKey())) == null) continue;
                try {
                    PARAMS p = PARAMS.valueOf(e.getValueKey());
                    ((FloatResource)res).setValue(p.convertInput(e.getValueFloat()));
                    IpThermostatChannel.this.logger.debug("resource updated: {} = {}", (Object)res.getPath(), e.getValue());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    static enum PARAMS {
        SET_POINT_TEMPERATURE{

            @Override
            public float convertInput(float v) {
                return v + 273.15f;
            }

            @Override
            public float convertOutput(float v) {
                return v - 273.15f;
            }
        }
        ,
        ACTUAL_TEMPERATURE{

            @Override
            public float convertInput(float v) {
                return v + 273.15f;
            }
        }
        ,
        VALVE_STATE{

            @Override
            public float convertInput(float v) {
                return v / 100.0f;
            }
        }
        ,
        BATTERY_STATE;


        public float convertInput(float v) {
            return v;
        }

        public float convertOutput(float v) {
            return v;
        }
    }
}

