/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl.channels;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.ogema.drivers.homematic.xmlrpc.hl.api.AbstractDeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.HomeMaticConnection;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmDevice;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmMaintenance;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEvent;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEventListener;
import org.ogema.drivers.homematic.xmlrpc.ll.api.ParameterDescription;
import org.ogema.tools.resource.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaintenanceChannel
extends AbstractDeviceHandler {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public MaintenanceChannel(HomeMaticConnection conn) {
        super(conn);
    }

    @Override
    public boolean accept(DeviceDescription desc) {
        return "MAINTENANCE".equalsIgnoreCase(desc.getType());
    }

    @Override
    public void setup(HmDevice parent, DeviceDescription desc, Map<String, Map<String, ParameterDescription<?>>> paramSets) {
        this.logger.debug("setup MAINTENANCE handler for address {}", (Object)desc.getAddress());
        String swName = ResourceUtils.getValidResourceName((String)("MAINTENANCE" + desc.getAddress()));
        Map<String, ParameterDescription<?>> values = paramSets.get(ParameterDescription.SET_TYPES.VALUES.name());
        if (values == null) {
            this.logger.warn("received no VALUES parameters for device {}", (Object)desc.getAddress());
            return;
        }
        HmMaintenance mnt = (HmMaintenance)parent.addDecorator(swName, HmMaintenance.class);
        mnt.batteryLow().create();
        mnt.activate(true);
        mnt.communicationStatus().communicationDisturbed().create();
        try {
            mnt.communicationStatus().communicationDisturbed().setValue(((Boolean)this.conn.getValue(desc.getAddress(), PARAMS.UNREACH.name())).booleanValue());
        }
        catch (IOException ioex) {
            this.logger.warn("could not read UNREACH state of device {}: {}", (Object)desc.getAddress(), (Object)ioex.getMessage());
        }
        mnt.communicationStatus().activate(true);
        this.conn.addEventListener(new MaintenanceEventListener(parent, mnt, desc.getAddress()));
    }

    class MaintenanceEventListener
    implements HmEventListener {
        final HmMaintenance mnt;
        final String address;
        final HmDevice parent;

        public MaintenanceEventListener(HmDevice parent, HmMaintenance mnt, String address) {
            this.mnt = mnt;
            this.address = address;
            this.parent = parent;
        }

        public void event(List<HmEvent> events) {
            for (HmEvent e : events) {
                if (!this.address.equals(e.getAddress())) continue;
                if (PARAMS.ERROR_CODE.name().equals(e.getValueKey())) {
                    if (!this.mnt.errorCode().isActive()) {
                        this.mnt.errorCode().create().activate(false);
                    }
                    this.mnt.errorCode().setValue(e.getValueInt());
                    continue;
                }
                if (PARAMS.LOWBAT.name().equals(e.getValueKey())) {
                    if (!this.mnt.batteryLow().isActive()) {
                        this.mnt.batteryLow().create().activate(false);
                    }
                    this.mnt.batteryLow().setValue(e.getValueBoolean());
                    continue;
                }
                if (PARAMS.RSSI_DEVICE.name().equals(e.getValueKey())) {
                    if (!this.mnt.rssiDevice().isActive()) {
                        this.mnt.rssiDevice().create().activate(false);
                    }
                    this.mnt.rssiDevice().setValue(e.getValueInt());
                    continue;
                }
                if (PARAMS.RSSI_PEER.name().equals(e.getValueKey())) {
                    if (!this.mnt.rssiPeer().isActive()) {
                        this.mnt.rssiPeer().create().activate(false);
                    }
                    this.mnt.rssiPeer().setValue(e.getValueInt());
                    continue;
                }
                if (PARAMS.OPERATING_VOLTAGE.name().equals(e.getValueKey())) {
                    if (!this.mnt.battery().internalVoltage().reading().isActive()) {
                        this.mnt.battery().internalVoltage().reading().create().activate(false);
                        this.mnt.battery().internalVoltage().activate(false);
                        this.mnt.battery().activate(false);
                    }
                    this.mnt.battery().internalVoltage().reading().setValue(e.getValueFloat());
                    continue;
                }
                if (!PARAMS.UNREACH.name().equals(e.getValueKey())) continue;
                this.mnt.communicationStatus().communicationDisturbed().setValue(e.getValueBoolean());
            }
        }
    }

    public static enum PARAMS {
        ERROR_CODE,
        LOWBAT,
        OPERATING_VOLTAGE,
        RSSI_DEVICE,
        RSSI_PEER,
        UNREACH;

    }
}

