/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl.channels;

import java.util.List;
import java.util.Map;
import org.ogema.core.model.units.ElectricCurrentResource;
import org.ogema.core.model.units.PowerResource;
import org.ogema.drivers.homematic.xmlrpc.hl.api.AbstractDeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.HomeMaticConnection;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmDevice;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEvent;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEventListener;
import org.ogema.drivers.homematic.xmlrpc.ll.api.ParameterDescription;
import org.ogema.model.connections.ElectricityConnection;
import org.ogema.tools.resource.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerMeterChannel
extends AbstractDeviceHandler {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public PowerMeterChannel(HomeMaticConnection conn) {
        super(conn);
    }

    @Override
    public boolean accept(DeviceDescription desc) {
        return "POWERMETER".equalsIgnoreCase(desc.getType());
    }

    @Override
    public void setup(HmDevice parent, DeviceDescription desc, Map<String, Map<String, ParameterDescription<?>>> paramSets) {
        LoggerFactory.getLogger(this.getClass()).debug("setup POWERMETER handler for address {}", (Object)desc.getAddress());
        String swName = ResourceUtils.getValidResourceName((String)("POWERMETER_" + desc.getAddress()));
        ElectricityConnection elconn = (ElectricityConnection)parent.addDecorator(swName, ElectricityConnection.class);
        this.conn.addEventListener(new PowerMeterEventListener(elconn, desc.getAddress()));
        elconn.activate(true);
    }

    class PowerMeterEventListener
    implements HmEventListener {
        final ElectricityConnection elconn;
        final String address;

        public PowerMeterEventListener(ElectricityConnection elconn, String address) {
            this.elconn = elconn;
            this.address = address;
        }

        public void event(List<HmEvent> events) {
            for (HmEvent e : events) {
                if (!this.address.equals(e.getAddress())) continue;
                switch (e.getValueKey()) {
                    case "POWER": {
                        PowerResource pwr = this.elconn.powerSensor().reading();
                        if (!pwr.exists()) {
                            pwr.create();
                            this.elconn.powerSensor().activate(true);
                        }
                        pwr.setValue(e.getValueFloat());
                        PowerMeterChannel.this.logger.debug("power reading updated: {} = {}", (Object)pwr.getPath(), (Object)Float.valueOf(e.getValueFloat()));
                        break;
                    }
                    case "CURRENT": {
                        ElectricCurrentResource reading = this.elconn.currentSensor().reading();
                        if (!reading.exists()) {
                            reading.create();
                            this.elconn.currentSensor().activate(true);
                        }
                        reading.setValue(e.getValueFloat() / 1000.0f);
                        PowerMeterChannel.this.logger.debug("current reading updated: {} = {}", (Object)reading.getPath(), (Object)Float.valueOf(e.getValueFloat()));
                        break;
                    }
                    case "VOLTAGE": {
                        ElectricCurrentResource reading = this.elconn.voltageSensor().reading();
                        if (!reading.exists()) {
                            reading.create();
                            this.elconn.voltageSensor().activate(true);
                        }
                        reading.setValue(e.getValueFloat());
                        PowerMeterChannel.this.logger.debug("voltage reading updated: {} = {}", (Object)reading.getPath(), (Object)Float.valueOf(e.getValueFloat()));
                        break;
                    }
                    case "FREQUENCY": {
                        ElectricCurrentResource reading = this.elconn.frequencySensor().reading();
                        if (!reading.exists()) {
                            reading.create();
                            this.elconn.frequencySensor().activate(true);
                        }
                        reading.setValue(e.getValueFloat());
                        PowerMeterChannel.this.logger.debug("frequency reading updated: {} = {}", (Object)reading.getPath(), (Object)Float.valueOf(e.getValueFloat()));
                        break;
                    }
                    case "ENERGY_COUNTER": {
                        ElectricCurrentResource reading = this.elconn.energySensor().reading();
                        if (!reading.exists()) {
                            reading.create();
                            this.elconn.energySensor().activate(true);
                        }
                        reading.setValue(e.getValueFloat());
                        PowerMeterChannel.this.logger.debug("energy reading updated: {} = {}", (Object)reading.getPath(), (Object)Float.valueOf(e.getValueFloat()));
                        break;
                    }
                }
            }
        }
    }
}

