/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl.channels;

import java.util.List;
import java.util.Map;
import org.ogema.core.model.Resource;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.simple.StringResource;
import org.ogema.core.resourcemanager.ResourceValueListener;
import org.ogema.drivers.homematic.xmlrpc.hl.api.AbstractDeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.HomeMaticConnection;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmDevice;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEvent;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEventListener;
import org.ogema.drivers.homematic.xmlrpc.ll.api.ParameterDescription;
import org.ogema.model.actors.OnOffSwitch;
import org.ogema.tools.resource.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchChannel
extends AbstractDeviceHandler {
    protected final Logger logger = LoggerFactory.getLogger(SwitchChannel.class);

    public SwitchChannel(HomeMaticConnection conn) {
        super(conn);
    }

    @Override
    public boolean accept(DeviceDescription desc) {
        return "SWITCH".equalsIgnoreCase(desc.getType());
    }

    @Override
    public void setup(HmDevice parent, DeviceDescription desc, Map<String, Map<String, ParameterDescription<?>>> paramSets) {
        LoggerFactory.getLogger(this.getClass()).debug("setup SWITCH handler for address {}", (Object)desc.getAddress());
        String swName = ResourceUtils.getValidResourceName((String)("SWITCH_" + desc.getAddress()));
        OnOffSwitch sw = (OnOffSwitch)parent.addDecorator(swName, OnOffSwitch.class);
        sw.stateControl().create();
        sw.stateFeedback().create();
        sw.stateControl().addValueListener((ResourceValueListener)new SingleChangeUpdater(desc.getAddress(), "STATE"));
        this.conn.addEventListener(new SwitchEventListener(sw, desc.getAddress()));
        sw.activate(true);
    }

    class SwitchEventListener
    implements HmEventListener {
        final OnOffSwitch sw;
        final String address;

        public SwitchEventListener(OnOffSwitch sw, String address) {
            this.sw = sw;
            this.address = address;
        }

        public void event(List<HmEvent> events) {
            for (HmEvent e : events) {
                if (!this.address.equals(e.getAddress())) continue;
                switch (e.getValueKey()) {
                    case "STATE": {
                        this.sw.stateFeedback().setValue(e.getValueBoolean());
                    }
                }
            }
        }

        private boolean isDeviceUnreach(HmEvent event, String channel) {
            if ("UNREACH".equals(event.getValueKey())) {
                int baseAddressEnd = channel.indexOf(58);
                String baseAddress = baseAddressEnd == -1 ? channel : channel.substring(0, baseAddressEnd);
                return event.getAddress().startsWith(baseAddress);
            }
            return false;
        }

        private void handleUnreach(HmEvent e) {
            if (!e.getValueBoolean()) {
                SwitchChannel.this.logger.debug("device {} is reachable again, resending state control {}={}", new Object[]{this.address, this.sw.stateControl().getPath(), this.sw.stateControl().getValue()});
                SwitchChannel.this.conn.performSetValue(this.address, "STATE", this.sw.stateControl().getValue());
            } else {
                SwitchChannel.this.logger.debug("device {} unreachable", (Object)this.address);
            }
        }
    }

    class SingleChangeUpdater
    implements ResourceValueListener<Resource> {
        protected final String address;
        protected final String valueKey;

        public SingleChangeUpdater(String address, String valueKey) {
            this.address = address;
            this.valueKey = valueKey;
        }

        public void resourceChanged(Resource res) {
            SwitchChannel.this.logger.debug("OGEMA value changed for HomeMatic {}/{}", (Object)this.address, (Object)this.valueKey);
            if (res instanceof FloatResource) {
                float value = ((FloatResource)res).getValue();
                SwitchChannel.this.conn.performSetValue(this.address, this.valueKey, Float.valueOf(value));
            } else if (res instanceof IntegerResource) {
                int value = ((IntegerResource)res).getValue();
                SwitchChannel.this.conn.performSetValue(this.address, this.valueKey, value);
            } else if (res instanceof StringResource) {
                String value = ((StringResource)res).getValue();
                SwitchChannel.this.conn.performSetValue(this.address, this.valueKey, value);
            } else if (res instanceof BooleanResource) {
                boolean value = ((BooleanResource)res).getValue();
                SwitchChannel.this.conn.performSetValue(this.address, this.valueKey, value);
            } else {
                LoggerFactory.getLogger(SwitchChannel.class).warn("HomeMatic parameter resource is of unsupported type: {}", (Object)res.getResourceType());
            }
        }
    }
}

