/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl.channels;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ogema.core.model.ResourceList;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.SingleValueResource;
import org.ogema.core.model.units.TemperatureResource;
import org.ogema.drivers.homematic.xmlrpc.hl.api.AbstractDeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.HomeMaticConnection;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmDevice;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEvent;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEventListener;
import org.ogema.drivers.homematic.xmlrpc.ll.api.ParameterDescription;
import org.ogema.model.devices.sensoractordevices.SensorDevice;
import org.ogema.model.sensors.HumiditySensor;
import org.ogema.model.sensors.TemperatureSensor;
import org.ogema.tools.resource.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeatherChannel
extends AbstractDeviceHandler {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public WeatherChannel(HomeMaticConnection conn) {
        super(conn);
    }

    @Override
    public boolean accept(DeviceDescription desc) {
        return "WEATHER".equalsIgnoreCase(desc.getType()) || "WEATHER_TRANSMIT".equalsIgnoreCase(desc.getType());
    }

    @Override
    public void setup(HmDevice parent, DeviceDescription desc, Map<String, Map<String, ParameterDescription<?>>> paramSets) {
        this.logger.debug("setup WEATHER handler for address {}", (Object)desc.getAddress());
        String swName = ResourceUtils.getValidResourceName((String)("WEATHER" + desc.getAddress()));
        Map<String, ParameterDescription<?>> values = paramSets.get(ParameterDescription.SET_TYPES.VALUES.name());
        if (values == null) {
            this.logger.warn("received no VALUES parameters for device {}", (Object)desc.getAddress());
            return;
        }
        HmDevice weatherChannel = this.conn.getChannel(parent, desc.getAddress());
        HashMap<String, SingleValueResource> resources = new HashMap<String, SingleValueResource>();
        for (Map.Entry<String, ParameterDescription<?>> e : values.entrySet()) {
            switch (e.getKey()) {
                case "TEMPERATURE": {
                    ResourceList sensors = ((SensorDevice)parent.addDecorator(swName, SensorDevice.class)).sensors();
                    sensors.create();
                    TemperatureResource reading = ((TemperatureSensor)sensors.addDecorator(e.getKey(), TemperatureSensor.class)).reading();
                    this.conn.registerControlledResource(weatherChannel, reading.getParent());
                    if (!reading.exists()) {
                        reading.create();
                        reading.getParent().activate(true);
                    }
                    this.logger.debug("found supported WEATHER parameter {} on {}", (Object)e.getKey(), (Object)desc.getAddress());
                    resources.put(e.getKey(), (SingleValueResource)reading);
                    break;
                }
                case "HUMIDITY": {
                    ResourceList sensors = ((SensorDevice)parent.addDecorator(swName, SensorDevice.class)).sensors();
                    sensors.create();
                    TemperatureResource reading = ((HumiditySensor)sensors.addDecorator(e.getKey(), HumiditySensor.class)).reading();
                    this.conn.registerControlledResource(weatherChannel, reading.getParent());
                    if (!reading.exists()) {
                        reading.create();
                        reading.getParent().activate(true);
                    }
                    this.logger.debug("found supported WEATHER parameter {} on {}", (Object)e.getKey(), (Object)desc.getAddress());
                    resources.put(e.getKey(), (SingleValueResource)reading);
                    break;
                }
            }
        }
        this.conn.addEventListener(new WeatherEventListener(resources, desc.getAddress()));
    }

    class WeatherEventListener
    implements HmEventListener {
        final Map<String, SingleValueResource> resources;
        final String address;

        public WeatherEventListener(Map<String, SingleValueResource> resources, String address) {
            this.resources = resources;
            this.address = address;
        }

        public void event(List<HmEvent> events) {
            for (HmEvent e : events) {
                SingleValueResource res;
                if (!this.address.equals(e.getAddress()) || (res = this.resources.get(e.getValueKey())) == null) continue;
                try {
                    PARAMS p = PARAMS.valueOf(e.getValueKey());
                    ((FloatResource)res).setValue(p.convertInput(e.getValueFloat()));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    static enum PARAMS {
        TEMPERATURE{

            @Override
            public float convertInput(float v) {
                return v + 273.15f;
            }
        }
        ,
        HUMIDITY{

            @Override
            public float convertInput(float v) {
                return v / 100.0f;
            }
        };


        public float convertInput(float v) {
            return v;
        }
    }
}

