/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl.events;

import java.util.HashMap;
import java.util.Map;
import org.ogema.core.application.ApplicationManager;
import org.ogema.drivers.homematic.xmlrpc.hl.events.LocalizableEventMessage;

public abstract class OgemaEventConstants {
    public static final String OGEMA_TIMESTAMP = "timestamp_ogema";
    public static final String TITLE_L10N = "title_l10n";
    public static final String MESSAGE_L10N = "message_l10n";

    private OgemaEventConstants() {
    }

    public static Map<String, ?> createEventProperties(ApplicationManager appman, String message, LocalizableEventMessage title, LocalizableEventMessage messageL10N) {
        HashMap<String, Object> eventProps = new HashMap<String, Object>();
        eventProps.put("bundle", appman.getAppID().getBundle());
        eventProps.put("timestamp", System.currentTimeMillis());
        if (message != null) {
            eventProps.put("message", System.currentTimeMillis());
        }
        eventProps.put(OGEMA_TIMESTAMP, appman.getFrameworkTime());
        if (title != null) {
            eventProps.put(TITLE_L10N, title);
        }
        if (messageL10N != null) {
            eventProps.put(MESSAGE_L10N, messageL10N);
        }
        return eventProps;
    }
}

