/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl;

import org.apache.xmlrpc.XmlRpcException;
import org.ogema.core.resourcemanager.ResourceStructureEvent;
import org.ogema.core.resourcemanager.ResourceStructureListener;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HomeMatic;
import org.slf4j.Logger;

class DeletionListener
implements ResourceStructureListener,
Runnable {
    final String device;
    final HomeMatic driver;
    final boolean resetOnDelete;
    final Logger logger;

    DeletionListener(String device, HomeMatic driver, boolean resetOnDelete, Logger logger) {
        this.device = device;
        this.driver = driver;
        this.resetOnDelete = resetOnDelete;
        this.logger = logger;
    }

    public void resourceStructureChanged(ResourceStructureEvent event) {
        if (ResourceStructureEvent.EventType.RESOURCE_DELETED.equals((Object)event.getType())) {
            new Thread(this).start();
        }
    }

    @Override
    public void run() {
        this.logger.debug("trying to delete {}, reset: {}", (Object)this.device, (Object)this.resetOnDelete);
        try {
            this.driver.deleteDevice(this.device, this.resetOnDelete ? 1 : 0);
            this.logger.debug("HomeMatic device {} un-paired and deleted", (Object)this.device);
        }
        catch (XmlRpcException ex) {
            this.logger.warn("deletion of {} failed, forcing removal from driver", (Object)this.device);
            try {
                this.driver.deleteDevice(this.device, 2);
                this.logger.debug("HomeMatic device {} removed without actual connection", (Object)this.device);
            }
            catch (XmlRpcException ex2) {
                this.logger.error("could not delete device {}", (Object)this.device);
            }
        }
    }
}

