/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.xmlrpc.XmlRpcException;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.Resource;
import org.ogema.core.model.ResourceList;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.StringResource;
import org.ogema.core.resourcemanager.ResourceDemandListener;
import org.ogema.core.resourcemanager.ResourceValueListener;
import org.ogema.drivers.homematic.xmlrpc.hl.HomeMaticDriver;
import org.ogema.drivers.homematic.xmlrpc.hl.Persistence;
import org.ogema.drivers.homematic.xmlrpc.hl.WriteAction;
import org.ogema.drivers.homematic.xmlrpc.hl.WriteScheduler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.DeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.DeviceHandlerFactory;
import org.ogema.drivers.homematic.xmlrpc.hl.api.HomeMaticConnection;
import org.ogema.drivers.homematic.xmlrpc.hl.channels.KeyChannel;
import org.ogema.drivers.homematic.xmlrpc.hl.channels.MaintenanceChannel;
import org.ogema.drivers.homematic.xmlrpc.hl.channels.MotionDetectorChannel;
import org.ogema.drivers.homematic.xmlrpc.hl.channels.PMSwitchDevice;
import org.ogema.drivers.homematic.xmlrpc.hl.channels.PowerMeterChannel;
import org.ogema.drivers.homematic.xmlrpc.hl.channels.ShutterContactChannel;
import org.ogema.drivers.homematic.xmlrpc.hl.channels.SwitchChannel;
import org.ogema.drivers.homematic.xmlrpc.hl.channels.ThermostatChannel;
import org.ogema.drivers.homematic.xmlrpc.hl.channels.WeatherChannel;
import org.ogema.drivers.homematic.xmlrpc.hl.discovery.Ccu;
import org.ogema.drivers.homematic.xmlrpc.hl.discovery.UdpDiscovery;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmDevice;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmLogicInterface;
import org.ogema.drivers.homematic.xmlrpc.ll.HomeMaticClient;
import org.ogema.drivers.homematic.xmlrpc.ll.HomeMaticClientCli;
import org.ogema.drivers.homematic.xmlrpc.ll.HomeMaticService;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceListener;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmBackend;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEvent;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEventListener;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HomeMatic;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmConnection
implements HomeMaticConnection {
    private final ApplicationManager appman;
    private final ComponentContext ctx;
    public static final Logger logger = LoggerFactory.getLogger(HomeMaticDriver.class);
    private final HomeMaticDriver hmDriver;
    final int MAX_RETRIES = 5;
    protected long reInitTryTime = 120000L;
    public static final long MAX_REINITTRYTIME = 86400000L;
    private Thread connectionThread;
    HomeMaticService hm;
    HomeMatic client;
    final HmLogicInterface baseResource;
    ServiceRegistration<HomeMaticClientCli> commandLine;
    private final ScheduledExecutorService t = Executors.newSingleThreadScheduledExecutor();
    ScheduledFuture<?> installModePoller;
    ScheduledFuture<?> pingCheck;
    final WriteScheduler writer;
    final List<DeviceHandler> handlers;
    private final ResourceDemandListener<HmDevice> devResourceListener = new ResourceDemandListener<HmDevice>(){

        public void resourceAvailable(HmDevice t) {
            if (!HmConnection.getToplevelResource(t).equalsLocation((Resource)HmConnection.this.baseResource)) {
                return;
            }
            HmConnection.this.hmDriver.setupDevice(t);
        }

        public void resourceUnavailable(HmDevice t) {
        }
    };
    final ResourceValueListener<BooleanResource> installModeListener = new ResourceValueListener<BooleanResource>(){

        public void resourceChanged(BooleanResource t) {
            if (t.equals(HmConnection.this.baseResource.installationMode().stateControl())) {
                try {
                    boolean onOff = t.getValue();
                    HmConnection.this.client.setInstallMode(onOff, 900, 1);
                    int secondsRemaining = HmConnection.this.client.getInstallMode();
                    HmConnection.this.baseResource.installationMode().stateFeedback().setValue(secondsRemaining > 0);
                }
                catch (XmlRpcException ex) {
                    logger.error("could not activate install mode", (Throwable)ex);
                }
            } else if (t.equals(HmConnection.this.baseResource.installationMode().stateFeedback())) {
                boolean installModeOn = HmConnection.this.baseResource.installationMode().stateFeedback().getValue();
                logger.info("installation mode {}", (Object)(installModeOn ? "on" : "off"));
            }
        }
    };
    final Runnable installModePolling = new Runnable(){

        @Override
        public void run() {
            try {
                int secondsRemaining = HmConnection.this.client.getInstallMode();
                logger.debug("polled installation mode: {}s", (Object)secondsRemaining);
                HmConnection.this.baseResource.installationMode().stateFeedback().setValue(secondsRemaining > 0);
            }
            catch (XmlRpcException ex) {
                logger.error("could not poll HomeMatic client for installation mode state", (Throwable)ex);
            }
        }
    };

    public static Resource getToplevelResource(Resource r) {
        Resource res = r.getLocationResource();
        while (!res.isTopLevel()) {
            if ((res = res.getParent()) != null) continue;
            throw new IllegalStateException("This should never occur!");
        }
        return res;
    }

    public HmConnection(List<DeviceHandlerFactory> handlerFactories, ApplicationManager appman, EventAdmin eventAdmin, ComponentContext ctx, HomeMaticDriver hmDriver, HmLogicInterface baseResource) {
        this.appman = appman;
        this.baseResource = baseResource;
        this.ctx = ctx;
        this.hmDriver = hmDriver;
        this.writer = new WriteScheduler(appman, eventAdmin);
        this.handlers = new ArrayList<DeviceHandler>();
        for (DeviceHandlerFactory fac : handlerFactories) {
            this.handlers.add(fac.createHandler(this));
        }
        this.handlers.add(new PMSwitchDevice(this));
        this.handlers.add(new MaintenanceChannel(this));
        this.handlers.add(new ThermostatChannel(this));
        this.handlers.add(new SwitchChannel(this));
        this.handlers.add(new PowerMeterChannel(this));
        this.handlers.add(new WeatherChannel(this));
        this.handlers.add(new ShutterContactChannel(this));
        this.handlers.add(new MotionDetectorChannel(this));
        this.handlers.add(new KeyChannel(this));
        this.writer.start();
    }

    private void connect() {
        logger.debug("Starting Homematic init for ogema-" + this.baseResource.getName() + ", may block for 20sec");
        try {
            this.hm.init(this.client, "ogema-" + this.baseResource.getName());
        }
        catch (XmlRpcException e) {
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                return;
            }
            logger.error("could not start HomeMatic driver for config {}", (Object)this.baseResource.getPath());
            logger.debug("Exception details:", (Throwable)e);
            this.retryConnect();
            return;
        }
        if (Thread.interrupted()) {
            Thread.currentThread().interrupt();
            logger.error("Thread interrupted for config {}", (Object)this.baseResource.getPath());
            return;
        }
        this.appman.getResourceAccess().addResourceDemand(HmDevice.class, this.devResourceListener);
        if (this.installModePoller == null) {
            this.installModePoller = this.t.scheduleWithFixedDelay(this.installModePolling, 0L, 60L, TimeUnit.SECONDS);
        }
        if (this.pingCheck == null) {
            this.pingCheck = this.t.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    HmConnection.this.checkPing();
                }
            }, 10L, 60L, TimeUnit.SECONDS);
        }
        logger.info("HomeMatic driver configured and registered according to config {}", (Object)this.baseResource.getPath());
    }

    @Override
    public void addEventListener(HmEventListener l) {
        this.hm.addEventListener(l);
    }

    @Override
    public void removeEventListener(HmEventListener l) {
        this.hm.removeEventListener(l);
    }

    Future<Boolean> checkPing() {
        final String callerId = "ogema" + System.currentTimeMillis();
        final CountDownLatch pongReceived = new CountDownLatch(1);
        long pingTimeoutSec = 10L;
        final HmEventListener pong = new HmEventListener(){

            public void event(List<HmEvent> events) {
                HmEvent e;
                if (events.size() == 1 && "PONG".equals((e = events.get(0)).getValueKey()) && ("CENTRAL".equals(e.getAddress()) || "CENTRAL:0".equals(e.getAddress())) && callerId.equals(e.getValueString())) {
                    pongReceived.countDown();
                }
            }
        };
        this.addEventListener(pong);
        return this.t.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    HmConnection.this.client.ping(callerId);
                    if (pongReceived.await(10L, TimeUnit.SECONDS)) {
                        logger.debug("ping OK");
                        Boolean bl = true;
                        return bl;
                    }
                    logger.warn("Homematic service does not respond, registering again...");
                    HmConnection.this.performConnect();
                    Boolean bl = false;
                    return bl;
                }
                catch (XmlRpcException ex) {
                    logger.warn("PING failed", (Throwable)ex);
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    HmConnection.this.removeEventListener(pong);
                }
            }
        });
    }

    @Override
    public <T> T getValue(String address, String value_key) throws IOException {
        try {
            return (T)this.client.getValue(address, value_key);
        }
        catch (XmlRpcException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void performSetValue(String address, String valueKey, Object value) {
        this.writer.addWriteAction(WriteAction.createSetValue(this.client, address, valueKey, value));
    }

    @Override
    public void performPutParamset(String address, String set, Map<String, Object> values) {
        this.writer.addWriteAction(WriteAction.createPutParamset(this.client, address, set, values));
    }

    @Override
    public void performAddLink(String sender, String receiver, String name, String description) {
        WriteAction writeAction = WriteAction.createAddLink(this.client, sender, receiver, name, description);
        this.writer.addWriteAction(writeAction);
    }

    @Override
    public void performRemoveLink(String sender, String receiver) {
        this.writer.addWriteAction(WriteAction.createRemoveLink(this.client, sender, receiver));
    }

    @Override
    public List<Map<String, Object>> performGetLinks(String address, int flags) {
        try {
            logger.debug("get links for {}", (Object)address);
            return this.client.getLinks(address, flags);
        }
        catch (XmlRpcException ex) {
            logger.error("getLinks failed for {}", (Object)address, (Object)ex);
            return null;
        }
    }

    @Override
    public HmDevice findControllingDevice(Resource ogemaDevice) {
        for (ResourceList l : ogemaDevice.getReferencingResources(ResourceList.class)) {
            if (l.getParent() == null || !(l.getParent() instanceof HmDevice)) continue;
            return (HmDevice)l.getParent();
        }
        for (Resource ref : ogemaDevice.getLocationResource().getReferencingNodes(true)) {
            if (ref.getParent() != null && ref.getParent().getParent() instanceof HmDevice) {
                return (HmDevice)ref.getParent().getParent();
            }
            for (ResourceList l : ref.getReferencingResources(ResourceList.class)) {
                if (l.getParent() == null || !(l.getParent() instanceof HmDevice)) continue;
                return (HmDevice)l.getParent();
            }
        }
        return null;
    }

    @Override
    public HmDevice getToplevelDevice(HmDevice channel) {
        if (channel.getParent() != null && channel.getParent().getParent() instanceof HmDevice) {
            return (HmDevice)channel.getParent().getParent();
        }
        return channel;
    }

    @Override
    public HmDevice getChannel(HmDevice device, String channelAddress) {
        Objects.requireNonNull(device);
        Objects.requireNonNull(channelAddress);
        for (HmDevice channel : device.channels().getAllElements()) {
            if (!channelAddress.equalsIgnoreCase(channel.address().getValue())) continue;
            return channel;
        }
        return null;
    }

    @Override
    public void registerControlledResource(HmDevice channel, Resource ogemaDevice) {
        Objects.requireNonNull(channel);
        Objects.requireNonNull(ogemaDevice);
        for (Resource entry : channel.controlledResources().getAllElements()) {
            if (!entry.equalsLocation(ogemaDevice)) continue;
            return;
        }
        channel.controlledResources().create().activate(false);
        channel.controlledResources().add(ogemaDevice);
    }

    public void init() {
        try {
            String serverUrl;
            HmLogicInterface config = this.baseResource;
            String xmlRpcServiceUrl = null;
            ArrayList<NetworkInterface> interfaces = new ArrayList<NetworkInterface>();
            if (config.networkInterface().isActive() || config.baseUrl().isActive() || config.clientUrl().isActive()) {
                serverUrl = this.getServerUrl(config, interfaces, xmlRpcServiceUrl);
                xmlRpcServiceUrl = config.clientUrl().isActive() ? config.clientUrl().getValue() : HmConnection.getXmlRpcInterface(config, interfaces);
            } else {
                if (!config.clientPort().isActive()) {
                    throw new IllegalStateException("Neither client port nor client URL set for config " + config);
                }
                xmlRpcServiceUrl = HmConnection.getXmlRpcInterface(config, interfaces);
                serverUrl = this.getServerUrl(config, interfaces, xmlRpcServiceUrl);
            }
            if (serverUrl == null || serverUrl.isEmpty()) {
                throw new IllegalStateException("Invalid server or client address " + serverUrl + ", " + xmlRpcServiceUrl);
            }
            if (xmlRpcServiceUrl == null || xmlRpcServiceUrl.isEmpty()) {
                throw new IllegalStateException("CCU XML-RPC service not found. Serial number: " + config.serialNumber().getValue());
            }
            String alias = HmConnection.getServletAlias(config);
            logger.info("New Homematic XML_RPC connection to {}, servlet URL {}{}", new Object[]{xmlRpcServiceUrl, serverUrl, alias});
            this.client = new HomeMaticClient(xmlRpcServiceUrl, config.ccuUser().isActive() ? config.ccuUser().getValue() : null, config.ccuPw().isActive() ? config.ccuPw().getValue() : null);
            this.commandLine = new HomeMaticClientCli(this.client).register(this.ctx.getBundleContext(), config.getName());
            this.hm = new HomeMaticService(this.ctx.getBundleContext(), serverUrl, alias);
            config.installationMode().stateControl().create();
            config.installationMode().stateFeedback().create();
            config.installationMode().activate(true);
            config.installationMode().stateControl().addValueListener(this.installModeListener, true);
            config.installationMode().stateFeedback().addValueListener(this.installModeListener, false);
            Persistence persistence = new Persistence(this.appman, config);
            this.hm.setBackend((HmBackend)persistence);
            this.hm.addDeviceListener((DeviceListener)persistence);
            this.performConnect();
        }
        catch (IOException ex) {
            logger.error("could not start HomeMatic driver for config {} (2)", (Object)this.baseResource.getPath());
            logger.debug("Exception details:", (Throwable)ex);
        }
    }

    private static String getServletAlias(HmLogicInterface config) {
        int port;
        if (config.alias().isActive()) {
            return config.alias().getValue();
        }
        try {
            port = config.clientPort().isActive() ? config.clientPort().getValue() : new URL(config.clientUrl().getValue()).getPort();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        switch (port) {
            case 2010: 
            case 42010: {
                return "/homematicip";
            }
            case 2001: 
            case 42001: {
                return "/homematic";
            }
            case 2000: 
            case 42000: {
                return "/homematicwired";
            }
        }
        return "/homematic" + port;
    }

    private String getServerUrl(HmLogicInterface config, List<NetworkInterface> interfaces, String clientUrl) throws SocketException, UnknownHostException, MalformedURLException {
        String address;
        String urlPattern = config.baseUrl().getValue();
        if (urlPattern == null || urlPattern.isEmpty()) {
            urlPattern = "http://%s:%d";
        }
        if (Boolean.getBoolean("org.ogema.drivers.homematic.xmlrpc.hl.testwithoutconnection")) {
            String address2 = String.format(urlPattern, "localhost", 9999);
            return address2;
        }
        String iface = config.networkInterface().getValue();
        if (interfaces.isEmpty()) {
            NetworkInterface nif;
            if (config.networkInterface().isActive()) {
                nif = NetworkInterface.getByName(iface);
                if (nif != null) {
                    interfaces.add(nif);
                }
            } else if (config.baseUrl().isActive()) {
                nif = NetworkInterface.getByInetAddress(Inet4Address.getByName(new URL(config.baseUrl().getValue()).getHost()));
                if (nif != null) {
                    interfaces.add(nif);
                }
            } else {
                interfaces.addAll(HmConnection.getBestMatchingInterfaces(clientUrl == null ? null : clientUrl.toLowerCase()));
            }
            if (interfaces.isEmpty()) {
                throw new IllegalArgumentException("Bad configuration: Network interface or base url not set and failed to determine interface automatically");
            }
            logger.debug("network interfaces selected: {}", interfaces);
        }
        if (config.baseUrl().isActive()) {
            address = config.baseUrl().getValue();
        } else {
            int port;
            NetworkInterface nif;
            Inet4Address i4address = null;
            Iterator<NetworkInterface> iterator = interfaces.iterator();
            while (iterator.hasNext() && (i4address = HmConnection.getAddressFromInterface(nif = iterator.next())) == null) {
            }
            if (i4address == null) {
                throw new IllegalArgumentException("could not determine IP address for interface " + iface);
            }
            logger.info("Selected IPv4 address for own network interface {}", i4address);
            String ipAddrString = i4address.getHostAddress();
            if (config.port().isActive()) {
                port = config.port().getValue();
            } else {
                port = 8080;
                try {
                    port = Integer.parseInt(this.ctx.getBundleContext().getProperty("org.osgi.service.http.port"));
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (SecurityException e) {
                    logger.warn("Failed to determine Jetty port", (Throwable)e);
                }
            }
            address = String.format(urlPattern, ipAddrString, port);
        }
        return address;
    }

    private static String getXmlRpcInterface(HmLogicInterface config, List<NetworkInterface> interfaces) throws SocketException {
        int port;
        Collection<Ccu> ccus = HmConnection.runCcuDiscovery(config, interfaces);
        if (ccus.isEmpty()) {
            logger.warn("No CCU found");
            return null;
        }
        if (ccus.size() > 1) {
            logger.warn("More than one matching CCU found: {}", ccus);
        } else {
            logger.debug("CCUs found: {}", ccus);
        }
        Ccu ccu = ccus.iterator().next();
        if (!config.serialNumber().isActive()) {
            ((StringResource)config.serialNumber().create()).setValue(ccu.getSerialNumber());
            config.serialNumber().activate(false);
        }
        if (interfaces.isEmpty()) {
            interfaces.add(ccu.getNetworkInterface());
        }
        String scheme = (port = config.clientPort().getValue()) > 40000 ? "https" : "http";
        return scheme + "://" + ccu.getAddress().getHostAddress() + ":" + port;
    }

    private static Collection<Ccu> runCcuDiscovery(HmLogicInterface config, List<NetworkInterface> interfaces) throws SocketException {
        List<NetworkInterface> ifs;
        if (!interfaces.isEmpty()) {
            ifs = interfaces;
        } else {
            ifs = new ArrayList<NetworkInterface>();
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                ifs.add(en.nextElement());
            }
        }
        String serialNr = config.serialNumber().isActive() ? config.serialNumber().getValue() : "*";
        Collection<Ccu> results = null;
        UdpDiscovery udp = new UdpDiscovery();
        Object object = null;
        try {
            block10: for (NetworkInterface nif : ifs) {
                for (InterfaceAddress ia : nif.getInterfaceAddresses()) {
                    InetAddress brdc = ia.getBroadcast();
                    if (brdc == null) continue;
                    udp.submit(brdc, nif, serialNr);
                    results = udp.getIntermediateResults(0L);
                    if (results == null) continue;
                    break block10;
                }
            }
            if (results == null) {
                results = udp.getIntermediateResults(10000L);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (udp != null) {
                if (object != null) {
                    try {
                        udp.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    udp.close();
                }
            }
        }
        if (results != null && !results.isEmpty()) {
            Collection<Ccu> ccus;
            if (!serialNr.equals("*")) {
                ccus = new ArrayList<Ccu>(results.size());
                for (Ccu ccu : results) {
                    if (!serialNr.equalsIgnoreCase(ccu.getSerialNumber())) continue;
                    ccus.add(ccu);
                }
            } else {
                ccus = results;
            }
            return ccus;
        }
        return Collections.emptyList();
    }

    protected void retryConnect() {
        logger.info("Will retry init for config {} after " + this.reInitTryTime / 1000L + " seconds.", (Object)this.baseResource.getPath());
        this.t.schedule(new Runnable(){

            @Override
            public void run() {
                HmConnection.this.performConnect();
            }
        }, this.reInitTryTime, TimeUnit.MILLISECONDS);
        this.reInitTryTime *= 2L;
        if (this.reInitTryTime > 86400000L) {
            this.reInitTryTime = 86400000L;
        }
    }

    protected void performConnect() {
        if (this.connectionThread == null || !this.connectionThread.isAlive()) {
            this.connectionThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (Boolean.getBoolean("org.ogema.drivers.homematic.xmlrpc.hl.testwithoutconnection")) {
                        return;
                    }
                    HmConnection.this.connect();
                }
            }, "homematic-xmlrpc-init");
            this.connectionThread.start();
        }
    }

    protected void close() {
        block6: {
            HmLogicInterface config = this.baseResource;
            try {
                this.t.shutdownNow();
                if (this.appman != null) {
                    this.appman.getResourceAccess().removeResourceDemand(HmDevice.class, this.devResourceListener);
                }
                config.installationMode().stateControl().removeValueListener(this.installModeListener);
                config.installationMode().stateFeedback().removeValueListener(this.installModeListener);
                if (this.client != null) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (HmConnection.this.hm != null) {
                                HmConnection.this.hm.close();
                            }
                            if (HmConnection.this.commandLine != null) {
                                HmConnection.this.commandLine.unregister();
                            }
                        }
                    }).start();
                }
                if (this.connectionThread != null && this.connectionThread.isAlive()) {
                    this.connectionThread.interrupt();
                }
                this.writer.close();
                if (logger != null) {
                    logger.info("HomeMatic configuration removed: {}", (Object)config);
                }
            }
            catch (Exception e) {
                if (logger == null) break block6;
                logger.error("HomeMatic XmlRpc driver shutdown failed", (Throwable)e);
            }
        }
    }

    private static Inet4Address getAddressFromInterface(NetworkInterface nif) {
        Enumeration<InetAddress> addresses = nif.getInetAddresses();
        while (addresses.hasMoreElements()) {
            InetAddress a = addresses.nextElement();
            if (!(a instanceof Inet4Address)) continue;
            return (Inet4Address)a;
        }
        return null;
    }

    private static List<NetworkInterface> getBestMatchingInterfaces(String clientUrl) throws SocketException {
        if (HmConnection.isOwnLoopbackAddress(clientUrl)) {
            return Collections.singletonList(NetworkInterface.getByName("lo"));
        }
        String targetAddress = clientUrl;
        try {
            targetAddress = new URL(clientUrl).getHost();
        }
        catch (NullPointerException | MalformedURLException exception) {
            // empty catch block
        }
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        TreeMap<Integer, ArrayList<NetworkInterface>> matches = new TreeMap<Integer, ArrayList<NetworkInterface>>();
        while (e.hasMoreElements()) {
            NetworkInterface n = e.nextElement();
            Enumeration<InetAddress> ee = n.getInetAddresses();
            int cnt = -1;
            while (ee.hasMoreElements()) {
                int level;
                InetAddress i = ee.nextElement();
                if (!(i instanceof Inet4Address) && !(i instanceof Inet6Address) || (level = targetAddress == null ? 1 : HmConnection.getAgreementLevel(i.getHostAddress().toLowerCase(), targetAddress)) <= cnt) continue;
                cnt = level;
            }
            if (cnt < 0) continue;
            ArrayList<NetworkInterface> ifs = (ArrayList<NetworkInterface>)matches.get(cnt);
            if (ifs == null) {
                ifs = new ArrayList<NetworkInterface>();
                matches.put(cnt, ifs);
            }
            ifs.add(n);
        }
        Logger logger = LoggerFactory.getLogger(HomeMaticDriver.class);
        if (matches.isEmpty()) {
            logger.error("No network interfaces found, cannot start driver");
            return null;
        }
        Iterator it = matches.descendingMap().values().iterator();
        ArrayList<NetworkInterface> list = new ArrayList<NetworkInterface>();
        while (it.hasNext()) {
            list.addAll((Collection)it.next());
        }
        return list;
    }

    private static int getAgreementLevel(String address, String targetAddress) {
        int sz = Math.min(address.length(), targetAddress.length());
        for (int i = 0; i < sz; ++i) {
            if (address.charAt(i) == targetAddress.charAt(i)) continue;
            return i;
        }
        return sz;
    }

    private static boolean isOwnLoopbackAddress(String clientUrl) {
        if (clientUrl == null) {
            return false;
        }
        return clientUrl.contains("localhost") || clientUrl.contains("127.0.0.1") || clientUrl.contains("0:0:0:0:0:0:0:1") || clientUrl.contains("::1");
    }
}

