/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl;

import java.io.Closeable;
import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;
import org.ogema.core.application.ApplicationManager;
import org.ogema.drivers.homematic.xmlrpc.hl.WriteAction;
import org.ogema.drivers.homematic.xmlrpc.hl.events.HomeMaticEventMessages;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteScheduler
implements Closeable {
    private static final long SLEEP_AFTER_ERROR = Long.getLong("ogema.homematic.xmlrpc.errorsleep", 5000L);
    private static final int MAX_RETRIES = Integer.getInteger("ogema.homematic.xmlrpc.retries", 5);
    private final EventAdmin eventAdmin;
    private final ApplicationManager appman;
    static final Comparator<WriteAction> WRITE_ACTION_COMPARATOR = new Comparator<WriteAction>(){

        @Override
        public int compare(WriteAction o1, WriteAction o2) {
            return Long.compare(o1.nextRun, o2.nextRun);
        }
    };
    final PriorityBlockingQueue<WriteAction> writeActions = new PriorityBlockingQueue<WriteAction>(50, WRITE_ACTION_COMPARATOR);
    private final Thread writerThread = new Thread(new Runnable(){

        @Override
        public void run() {
            WriteScheduler.this.schedulerImpl();
        }
    });
    final Logger logger = LoggerFactory.getLogger(this.getClass());

    public WriteScheduler(ApplicationManager appman, EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
        this.appman = appman;
        this.writerThread.setName("OGEMA HomeMatic-XMLRPC writer thread");
    }

    public void start() {
        this.writerThread.start();
    }

    @Override
    public void close() {
        if (this.writerThread.isAlive()) {
            this.writerThread.interrupt();
        }
    }

    public void addWriteAction(WriteAction write) {
        this.writeActions.add(write);
    }

    private void schedulerImpl() {
        try {
            while (!Thread.interrupted()) {
                WriteAction next = this.writeActions.take();
                boolean success = false;
                try {
                    success = next.write();
                }
                catch (Throwable t) {
                    this.logger.warn("WriteAction misbehaved and threw an exception", t);
                }
                if (!success) {
                    if (next.tries() >= MAX_RETRIES) {
                        this.logger.error("discarding write to {} after {} failed tries.", (Object)next.target(), (Object)next.tries());
                        this.eventAdmin.postEvent(HomeMaticEventMessages.createWriteFailedEvent(this.appman, next.target()));
                    } else {
                        this.writeActions.offer(next);
                    }
                    this.logger.debug("sleeping after failed write: {}ms", (Object)SLEEP_AFTER_ERROR);
                    Thread.sleep(SLEEP_AFTER_ERROR);
                    continue;
                }
                if (next.tries() <= 1) continue;
                this.logger.info("failed write for {} succeeded on try {}", (Object)next.target(), (Object)next.tries());
            }
        }
        catch (InterruptedException ie) {
            this.logger.debug("write thread shutting down");
        }
    }
}

