/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl.channels;

import java.util.List;
import java.util.Map;
import org.ogema.drivers.homematic.xmlrpc.hl.api.AbstractDeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.DeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.DeviceHandlerFactory;
import org.ogema.drivers.homematic.xmlrpc.hl.api.HomeMaticConnection;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmDevice;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEvent;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEventListener;
import org.ogema.drivers.homematic.xmlrpc.ll.api.ParameterDescription;
import org.ogema.tools.resource.util.ResourceUtils;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DeviceHandlerFactory.class}, property={"service.ranking:Integer=1"})
public class CO2Sensor
extends AbstractDeviceHandler
implements DeviceHandlerFactory {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int[] STATE2PPM_MAPPING = new int[]{400, 1000, 1500, 2000};

    @Override
    public DeviceHandler createHandler(HomeMaticConnection connection) {
        return new CO2Sensor(connection);
    }

    public CO2Sensor() {
        super(null);
    }

    public CO2Sensor(HomeMaticConnection conn) {
        super(conn);
    }

    @Override
    public boolean accept(DeviceDescription desc) {
        return "SENSOR_FOR_CARBON_DIOXIDE".equalsIgnoreCase(desc.getType());
    }

    @Override
    public void setup(HmDevice parent, DeviceDescription desc, Map<String, Map<String, ParameterDescription<?>>> paramSets) {
        this.logger.debug("setup SENSOR_FOR_CARBON_DIOXIDE handler for address {}", (Object)desc.getAddress());
        String swName = ResourceUtils.getValidResourceName((String)("SENSOR_FOR_CARBON_DIOXIDE" + desc.getAddress()));
        Map<String, ParameterDescription<?>> values = paramSets.get(ParameterDescription.SET_TYPES.VALUES.name());
        if (values == null) {
            this.logger.warn("received no VALUES parameters for device {}", (Object)desc.getAddress());
            return;
        }
        org.ogema.model.sensors.CO2Sensor sens = (org.ogema.model.sensors.CO2Sensor)parent.addDecorator(swName, org.ogema.model.sensors.CO2Sensor.class);
        sens.reading().create();
        this.conn.addEventListener(new StateEventListener(sens, desc.getAddress()));
        sens.activate(true);
    }

    class StateEventListener
    implements HmEventListener {
        final org.ogema.model.sensors.CO2Sensor sens;
        final String address;

        public StateEventListener(org.ogema.model.sensors.CO2Sensor sens, String address) {
            this.sens = sens;
            this.address = address;
        }

        public void event(List<HmEvent> events) {
            for (HmEvent e : events) {
                if (!this.address.equals(e.getAddress())) continue;
                if (PARAMS.STATE.name().equals(e.getValueKey())) {
                    int stateVal = e.getValueInt();
                    if (stateVal < 0 || stateVal > STATE2PPM_MAPPING.length - 1) {
                        CO2Sensor.this.logger.error("CO2Sensor STATE value out off supported range: {}", (Object)stateVal);
                        continue;
                    }
                    int ppm = STATE2PPM_MAPPING[stateVal];
                    this.sens.reading().setValue((float)ppm);
                    CO2Sensor.this.logger.debug("SENSOR_FOR_CARBON_DIOXIDE {}: state={} (>={}ppm)", new Object[]{e.getAddress(), stateVal, ppm});
                    continue;
                }
                CO2Sensor.this.logger.trace("unsupported / ignored event: {}", (Object)e);
            }
        }
    }

    static enum PARAMS {
        STATE;

    }
}

