/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl.channels;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ogema.core.model.Resource;
import org.ogema.core.model.ResourceList;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.simple.SingleValueResource;
import org.ogema.core.resourcemanager.ResourceValueListener;
import org.ogema.drivers.homematic.xmlrpc.hl.api.AbstractDeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.DeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.DeviceHandlerFactory;
import org.ogema.drivers.homematic.xmlrpc.hl.api.HomeMaticConnection;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmDevice;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEvent;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEventListener;
import org.ogema.drivers.homematic.xmlrpc.ll.api.ParameterDescription;
import org.ogema.model.devices.connectiondevices.ThermalValve;
import org.ogema.model.devices.sensoractordevices.SensorDevice;
import org.ogema.tools.resource.util.ResourceUtils;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DeviceHandlerFactory.class}, property={"service.ranking:Integer=1"})
public class IpFAL230Channel
extends AbstractDeviceHandler
implements DeviceHandlerFactory {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public DeviceHandler createHandler(HomeMaticConnection connection) {
        return new IpFAL230Channel(connection);
    }

    public IpFAL230Channel() {
        super(null);
    }

    public IpFAL230Channel(HomeMaticConnection conn) {
        super(conn);
    }

    @Override
    public boolean accept(DeviceDescription desc) {
        return ("HmIP-FAL230-C10".equalsIgnoreCase(desc.getParentType()) || "HmIP-FAL230-C6".equalsIgnoreCase(desc.getParentType())) && "CLIMATECONTROL_FLOOR_TRANSCEIVER".equalsIgnoreCase(desc.getType());
    }

    @Override
    public void setup(HmDevice parent, DeviceDescription desc, Map<String, Map<String, ParameterDescription<?>>> paramSets) {
        String deviceAddress = desc.getAddress();
        this.logger.debug("setup FAL230-VALVE handler for address {} type {}", (Object)desc.getAddress(), (Object)desc.getType());
        String swName = ResourceUtils.getValidResourceName((String)("VALVE" + desc.getAddress()));
        Map<String, ParameterDescription<?>> values = paramSets.get(ParameterDescription.SET_TYPES.VALUES.name());
        if (values == null) {
            this.logger.warn("received no VALUES parameters for device {}", (Object)desc.getAddress());
            return;
        }
        SensorDevice actDev = (SensorDevice)parent.getSubResource("valves", SensorDevice.class);
        if (!actDev.isActive()) {
            actDev.create();
            actDev.activate(false);
        }
        ThermalValve valve = (ThermalValve)actDev.addDecorator(swName, ThermalValve.class);
        this.conn.registerControlledResource(this.conn.getChannel(parent, deviceAddress), (Resource)valve);
        HashMap<String, SingleValueResource> resources = new HashMap<String, SingleValueResource>();
        for (Map.Entry<String, ParameterDescription<?>> e : values.entrySet()) {
            switch (e.getKey()) {
                case "STATE": {
                    FloatResource reading = valve.setting().stateFeedback();
                    if (!reading.exists()) {
                        reading.create();
                        valve.activate(true);
                    }
                    this.logger.debug("found supported valve parameter {} on {}", (Object)e.getKey(), (Object)desc.getAddress());
                    resources.put(e.getKey(), (SingleValueResource)reading);
                    break;
                }
            }
        }
        valve.activate(true);
        this.conn.addEventListener(new WeatherEventListener(resources, desc.getAddress()));
        this.setupHmParameterValues(valve, parent.address().getValue());
    }

    private void setupHmParameterValues(ThermalValve valve, String address) {
        ResourceList masterParameters;
        if (address.lastIndexOf(":") != -1) {
            address = address.substring(0, address.lastIndexOf(":"));
        }
        if (!(masterParameters = (ResourceList)valve.addDecorator("HmParametersMaster", ResourceList.class)).exists()) {
            masterParameters.setElementType(SingleValueResource.class);
            masterParameters.create();
        }
    }

    class ParameterListener
    implements ResourceValueListener<SingleValueResource> {
        final String address;

        public ParameterListener(String address) {
            this.address = address;
        }

        public void resourceChanged(SingleValueResource resource) {
            String paramName = resource.getName();
            Integer resourceValue = null;
            if (resource instanceof IntegerResource) {
                resourceValue = ((IntegerResource)resource).getValue();
            } else {
                IpFAL230Channel.this.logger.warn("unsupported parameter type: " + resource);
            }
            HashMap<String, Object> parameterSet = new HashMap<String, Object>();
            parameterSet.put(paramName, resourceValue);
            IpFAL230Channel.this.conn.performPutParamset(this.address, "MASTER", parameterSet);
            IpFAL230Channel.this.logger.info("Parameter set 'MASTER' updated for {}: {}", (Object)this.address, parameterSet);
        }
    }

    class WeatherEventListener
    implements HmEventListener {
        final Map<String, SingleValueResource> resources;
        final String address;

        public WeatherEventListener(Map<String, SingleValueResource> resources, String address) {
            this.resources = resources;
            this.address = address;
        }

        public void event(List<HmEvent> events) {
            for (HmEvent e : events) {
                SingleValueResource res;
                if (!this.address.equals(e.getAddress()) || (res = this.resources.get(e.getValueKey())) == null) continue;
                try {
                    PARAMS p = PARAMS.valueOf(e.getValueKey());
                    ((FloatResource)res).setValue(p.convertInput(e.getValueBoolean()));
                    IpFAL230Channel.this.logger.debug("resource updated: {} = {}", (Object)res.getPath(), e.getValue());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    static enum PARAMS {
        STATE{

            @Override
            public float convertInput(boolean v) {
                return v ? 1.0f : 0.0f;
            }
        }
        ,
        BATTERY_STATE;


        public float convertInput(boolean b) {
            return b ? 1.0f : 0.0f;
        }

        public float convertInput(float b) {
            return b;
        }

        public float convertOutput(float v) {
            return v;
        }
    }
}

