/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl.channels;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ogema.core.model.Resource;
import org.ogema.core.model.ResourceList;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.simple.SingleValueResource;
import org.ogema.core.resourcemanager.ResourceStructureEvent;
import org.ogema.core.resourcemanager.ResourceStructureListener;
import org.ogema.core.resourcemanager.ResourceValueListener;
import org.ogema.drivers.homematic.xmlrpc.hl.api.AbstractDeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.DeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.DeviceHandlerFactory;
import org.ogema.drivers.homematic.xmlrpc.hl.api.HomeMaticConnection;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmDevice;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEvent;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEventListener;
import org.ogema.drivers.homematic.xmlrpc.ll.api.ParameterDescription;
import org.ogema.model.devices.buildingtechnology.Thermostat;
import org.ogema.model.sensors.TemperatureSensor;
import org.ogema.tools.resource.util.ResourceUtils;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DeviceHandlerFactory.class}, property={"service.ranking:Integer=1"})
public class IpFALMOTChannel
extends AbstractDeviceHandler
implements DeviceHandlerFactory {
    public static final String PARAM_TEMPERATUREFALL_MODUS = "TEMPERATUREFALL_MODUS";
    public static final String LINKED_TEMP_SENS_DECORATOR = "linkedTempSens";
    Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public DeviceHandler createHandler(HomeMaticConnection connection) {
        return new IpFALMOTChannel(connection);
    }

    public IpFALMOTChannel() {
        super(null);
    }

    public IpFALMOTChannel(HomeMaticConnection conn) {
        super(conn);
    }

    @Override
    public boolean accept(DeviceDescription desc) {
        return "HmIP-FALMOT-C12".equalsIgnoreCase(desc.getParentType()) && "CLIMATECONTROL_FLOOR_TRANSCEIVER".equalsIgnoreCase(desc.getType());
    }

    @Override
    public void setup(HmDevice parent, DeviceDescription desc, Map<String, Map<String, ParameterDescription<?>>> paramSets) {
        String deviceAddress = desc.getAddress();
        this.logger.debug("setup FALMOT-THERMOSTAT handler for address {} type {}", (Object)desc.getAddress(), (Object)desc.getType());
        String swName = ResourceUtils.getValidResourceName((String)("THERMOSTAT" + desc.getAddress()));
        Map<String, ParameterDescription<?>> values = paramSets.get(ParameterDescription.SET_TYPES.VALUES.name());
        if (values == null) {
            this.logger.warn("received no VALUES parameters for device {}", (Object)desc.getAddress());
            return;
        }
        Thermostat thermos = (Thermostat)parent.addDecorator(swName, Thermostat.class);
        this.conn.registerControlledResource(this.conn.getChannel(parent, deviceAddress), (Resource)thermos);
        HashMap<String, SingleValueResource> resources = new HashMap<String, SingleValueResource>();
        for (Map.Entry<String, ParameterDescription<?>> e : values.entrySet()) {
            switch (e.getKey()) {
                case "LEVEL": {
                    FloatResource reading = thermos.valve().setting().stateFeedback();
                    if (!reading.exists()) {
                        reading.create();
                        thermos.activate(true);
                    }
                    this.logger.debug("found supported thermostat parameter {} on {}", (Object)e.getKey(), (Object)desc.getAddress());
                    resources.put(e.getKey(), (SingleValueResource)reading);
                    break;
                }
            }
        }
        thermos.activate(true);
        this.conn.addEventListener(new WeatherEventListener(resources, desc.getAddress()));
        this.setupHmParameterValues(thermos, parent.address().getValue());
        this.setupTempSensLinking(thermos);
    }

    private void setupHmParameterValues(Thermostat thermos, String address) {
        ResourceList masterParameters;
        if (address.lastIndexOf(":") != -1) {
            address = address.substring(0, address.lastIndexOf(":"));
        }
        if (!(masterParameters = (ResourceList)thermos.addDecorator("HmParametersMaster", ResourceList.class)).exists()) {
            masterParameters.setElementType(SingleValueResource.class);
            masterParameters.create();
        }
        IntegerResource tf_modus = (IntegerResource)masterParameters.getSubResource(PARAM_TEMPERATUREFALL_MODUS, IntegerResource.class);
        ParameterListener l = new ParameterListener(address);
        if (tf_modus.isActive()) {
            l.resourceChanged((SingleValueResource)tf_modus);
        }
        tf_modus.addValueListener((ResourceValueListener)l, true);
    }

    private void linkTempSens(Thermostat thermos, TemperatureSensor tempSens, boolean removeLink) {
        String thermosAddress = this.getWeatherReceiverChannelAddress(thermos);
        if (thermosAddress == null) {
            return;
        }
        HmDevice tempSensChannel = this.conn.findControllingDevice((Resource)tempSens);
        if (tempSensChannel == null) {
            this.logger.warn("cannot find HomeMatic channel for TemperatureSensor {}", (Object)tempSens);
            return;
        }
        if (!tempSensChannel.type().getValue().equalsIgnoreCase("WEATHER")) {
            this.logger.warn("HomeMatic channel controlling TemperatureSensor {} is not a WEATHER channel (type is {}). Cannot link", (Object)tempSens, (Object)tempSensChannel.type().getValue());
            return;
        }
        String weatherAddress = tempSensChannel.address().getValue();
        if (removeLink) {
            this.conn.performRemoveLink(weatherAddress, thermosAddress);
            return;
        }
        this.logger.info("HomeMatic weather channel for TempSens {}: {}", (Object)tempSens, (Object)weatherAddress);
        this.conn.performAddLink(weatherAddress, thermosAddress, "TempSens", "external temperature sensor");
    }

    private void setupTempSensLinking(final Thermostat thermos) {
        TemperatureSensor tempSens = (TemperatureSensor)thermos.getSubResource(LINKED_TEMP_SENS_DECORATOR, TemperatureSensor.class);
        ResourceStructureListener l = new ResourceStructureListener(){

            public void resourceStructureChanged(ResourceStructureEvent event) {
                Resource added = event.getChangedResource();
                if (event.getType() == ResourceStructureEvent.EventType.SUBRESOURCE_ADDED) {
                    if (added.getName().equals(IpFALMOTChannel.LINKED_TEMP_SENS_DECORATOR) && added instanceof TemperatureSensor) {
                        IpFALMOTChannel.this.linkTempSens(thermos, (TemperatureSensor)added, false);
                    }
                } else if (event.getType() == ResourceStructureEvent.EventType.SUBRESOURCE_REMOVED && added.getName().equals(IpFALMOTChannel.LINKED_TEMP_SENS_DECORATOR)) {
                    String weatherChannelAddress = IpFALMOTChannel.this.getWeatherReceiverChannelAddress(thermos);
                    if (weatherChannelAddress == null) {
                        return;
                    }
                    for (Map<String, Object> link : IpFALMOTChannel.this.getConnection().performGetLinks(weatherChannelAddress, 0)) {
                        Object sender;
                        if (!weatherChannelAddress.equals(link.get("RECEIVER")) || !((sender = link.get("SENDER")) instanceof String)) continue;
                        IpFALMOTChannel.this.getConnection().performRemoveLink((String)sender, weatherChannelAddress);
                        IpFALMOTChannel.this.logger.info("Thermostat-temperature sensor connection removed. Thermostat channel {}, temperature sensor {}", (Object)weatherChannelAddress, sender);
                    }
                }
            }
        };
        thermos.addStructureListener(l);
        if (tempSens.isActive()) {
            this.linkTempSens(thermos, tempSens, false);
        }
    }

    private String getWeatherReceiverChannelAddress(Thermostat thermos) {
        HmDevice thermostatChannel = this.conn.findControllingDevice((Resource)thermos);
        if (thermostatChannel == null) {
            this.logger.error("cannot find HomeMatic channel for Thermostat {}", (Object)thermos);
            return null;
        }
        HmDevice thermostatDevice = this.conn.getToplevelDevice(thermostatChannel);
        return thermostatDevice.address().getValue() + ":6";
    }

    class ParameterListener
    implements ResourceValueListener<SingleValueResource> {
        final String address;

        public ParameterListener(String address) {
            this.address = address;
        }

        public void resourceChanged(SingleValueResource resource) {
            String paramName = resource.getName();
            Integer resourceValue = null;
            if (resource instanceof IntegerResource) {
                resourceValue = ((IntegerResource)resource).getValue();
            } else {
                IpFALMOTChannel.this.logger.warn("unsupported parameter type: " + resource);
            }
            HashMap<String, Object> parameterSet = new HashMap<String, Object>();
            parameterSet.put(paramName, resourceValue);
            IpFALMOTChannel.this.conn.performPutParamset(this.address, "MASTER", parameterSet);
            IpFALMOTChannel.this.logger.info("Parameter set 'MASTER' updated for {}: {}", (Object)this.address, parameterSet);
        }
    }

    class WeatherEventListener
    implements HmEventListener {
        final Map<String, SingleValueResource> resources;
        final String address;

        public WeatherEventListener(Map<String, SingleValueResource> resources, String address) {
            this.resources = resources;
            this.address = address;
        }

        public void event(List<HmEvent> events) {
            for (HmEvent e : events) {
                SingleValueResource res;
                if (!this.address.equals(e.getAddress()) || (res = this.resources.get(e.getValueKey())) == null) continue;
                try {
                    PARAMS p = PARAMS.valueOf(e.getValueKey());
                    ((FloatResource)res).setValue(p.convertInput(e.getValueFloat()));
                    IpFALMOTChannel.this.logger.debug("resource updated: {} = {}", (Object)res.getPath(), e.getValue());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    static enum PARAMS {
        SET_POINT_TEMPERATURE{

            @Override
            public float convertInput(float v) {
                return v + 273.15f;
            }

            @Override
            public float convertOutput(float v) {
                return v - 273.15f;
            }
        }
        ,
        ACTUAL_TEMPERATURE{

            @Override
            public float convertInput(float v) {
                return v + 273.15f;
            }
        }
        ,
        LEVEL{

            @Override
            public float convertInput(float v) {
                return v;
            }
        }
        ,
        BATTERY_STATE;


        public float convertInput(float v) {
            return v;
        }

        public float convertOutput(float v) {
            return v;
        }
    }
}

