/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl.channels;

import java.util.List;
import java.util.Map;
import org.ogema.drivers.homematic.xmlrpc.hl.api.AbstractDeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.DeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.DeviceHandlerFactory;
import org.ogema.drivers.homematic.xmlrpc.hl.api.HomeMaticConnection;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmDevice;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEvent;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEventListener;
import org.ogema.drivers.homematic.xmlrpc.ll.api.ParameterDescription;
import org.ogema.model.devices.sensoractordevices.SensorDevice;
import org.ogema.model.sensors.LightSensor;
import org.ogema.model.sensors.OccupancySensor;
import org.ogema.tools.resource.util.ResourceUtils;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DeviceHandlerFactory.class}, property={"service.ranking:Integer=1"})
public class IpMotionDetector
extends AbstractDeviceHandler
implements DeviceHandlerFactory {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public DeviceHandler createHandler(HomeMaticConnection connection) {
        return new IpMotionDetector(connection);
    }

    public IpMotionDetector() {
        super(null);
    }

    public IpMotionDetector(HomeMaticConnection conn) {
        super(conn);
    }

    @Override
    public boolean accept(DeviceDescription desc) {
        return "MOTIONDETECTOR_TRANSCEIVER".equalsIgnoreCase(desc.getType());
    }

    @Override
    public void setup(HmDevice parent, DeviceDescription desc, Map<String, Map<String, ParameterDescription<?>>> paramSets) {
        this.logger.debug("setup MOTIONDETECTOR_TRANSCEIVER handler for address {}", (Object)desc.getAddress());
        String swName = ResourceUtils.getValidResourceName((String)("MOTIONDETECTOR_TRANSCEIVER" + desc.getAddress()));
        Map<String, ParameterDescription<?>> values = paramSets.get(ParameterDescription.SET_TYPES.VALUES.name());
        if (values == null) {
            this.logger.warn("received no VALUES parameters for device {}", (Object)desc.getAddress());
            return;
        }
        SensorDevice sd = (SensorDevice)parent.addDecorator(swName, SensorDevice.class);
        OccupancySensor sens = (OccupancySensor)sd.sensors().addDecorator("motion", OccupancySensor.class);
        sens.reading().create();
        LightSensor illumination = (LightSensor)sd.sensors().addDecorator("illumination", LightSensor.class);
        illumination.reading().create();
        this.conn.addEventListener(new MotionEventListener(sens, illumination, desc.getAddress()));
        sd.activate(true);
    }

    class MotionEventListener
    implements HmEventListener {
        final OccupancySensor sens;
        final LightSensor illumination;
        final String address;

        public MotionEventListener(OccupancySensor sens, LightSensor illumination, String address) {
            this.sens = sens;
            this.illumination = illumination;
            this.address = address;
        }

        public void event(List<HmEvent> events) {
            for (HmEvent e : events) {
                if (!this.address.equals(e.getAddress())) continue;
                if (PARAMS.MOTION.name().equals(e.getValueKey())) {
                    this.sens.reading().setValue(e.getValueBoolean());
                    IpMotionDetector.this.logger.debug("MOTIONDETECTOR_TRANSCEIVER {} motion detected: {}", (Object)e.getAddress(), (Object)e.getValueBoolean());
                    continue;
                }
                if (PARAMS.ILLUMINATION.name().equals(e.getValueKey())) {
                    this.illumination.reading().setValue(e.getValueFloat());
                    IpMotionDetector.this.logger.debug("MOTIONDETECTOR_TRANSCEIVER {} illumination: {}", (Object)e.getAddress(), (Object)Float.valueOf(e.getValueFloat()));
                    continue;
                }
                IpMotionDetector.this.logger.trace("unsupported / ignored event: {}", (Object)e);
            }
        }
    }

    static enum PARAMS {
        MOTION,
        ILLUMINATION;

    }
}

