/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl.channels;

import java.util.List;
import java.util.Map;
import org.ogema.drivers.homematic.xmlrpc.hl.api.AbstractDeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.DeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.DeviceHandlerFactory;
import org.ogema.drivers.homematic.xmlrpc.hl.api.HomeMaticConnection;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmDevice;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEvent;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEventListener;
import org.ogema.drivers.homematic.xmlrpc.ll.api.ParameterDescription;
import org.ogema.model.sensors.DoorWindowSensor;
import org.ogema.tools.resource.util.ResourceUtils;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DeviceHandlerFactory.class}, property={"service.ranking:Integer=1"})
public class IpShutterContact
extends AbstractDeviceHandler
implements DeviceHandlerFactory {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public IpShutterContact() {
        super(null);
    }

    public IpShutterContact(HomeMaticConnection conn) {
        super(conn);
    }

    @Override
    public DeviceHandler createHandler(HomeMaticConnection connection) {
        return new IpShutterContact(connection);
    }

    @Override
    public boolean accept(DeviceDescription desc) {
        return "HMIP-SWDO".equals(desc.getParentType()) && "SHUTTER_CONTACT".equalsIgnoreCase(desc.getType());
    }

    @Override
    public void setup(HmDevice parent, DeviceDescription desc, Map<String, Map<String, ParameterDescription<?>>> paramSets) {
        this.logger.debug("setup SHUTTER_CONTACT handler for address {}", (Object)desc.getAddress());
        String swName = ResourceUtils.getValidResourceName((String)("SHUTTER_CONTACT" + desc.getAddress()));
        Map<String, ParameterDescription<?>> values = paramSets.get(ParameterDescription.SET_TYPES.VALUES.name());
        if (values == null) {
            this.logger.warn("received no VALUES parameters for device {}", (Object)desc.getAddress());
            return;
        }
        DoorWindowSensor sens = (DoorWindowSensor)parent.addDecorator(swName, DoorWindowSensor.class);
        sens.reading().create();
        sens.activate(true);
        sens.battery().chargeSensor().reading().create();
        sens.activate(true);
        this.conn.addEventListener(new ShutterContactListener(sens, desc.getAddress()));
    }

    class ShutterContactListener
    implements HmEventListener {
        final DoorWindowSensor sens;
        final String address;

        public ShutterContactListener(DoorWindowSensor sens, String address) {
            this.sens = sens;
            this.address = address;
        }

        public void event(List<HmEvent> events) {
            for (HmEvent e : events) {
                if (!this.address.equals(e.getAddress()) || !PARAMS.STATE.name().equals(e.getValueKey())) continue;
                boolean open = e.getValueInt() != 0;
                this.sens.reading().setValue(open);
                IpShutterContact.this.logger.debug("SHUTTER_CONTACT {} = {}", (Object)this.address, (Object)open);
            }
        }
    }

    static enum PARAMS {
        STATE,
        LOWBAT;

    }
}

