/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl.channels;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ogema.core.model.ResourceList;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.simple.SingleValueResource;
import org.ogema.core.model.units.TemperatureResource;
import org.ogema.core.resourcemanager.ResourceValueListener;
import org.ogema.drivers.homematic.xmlrpc.hl.api.AbstractDeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.DeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.DeviceHandlerFactory;
import org.ogema.drivers.homematic.xmlrpc.hl.api.HomeMaticConnection;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmDevice;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEvent;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEventListener;
import org.ogema.drivers.homematic.xmlrpc.ll.api.ParameterDescription;
import org.ogema.model.devices.sensoractordevices.SensorDevice;
import org.ogema.model.sensors.HumiditySensor;
import org.ogema.model.sensors.TemperatureSensor;
import org.ogema.tools.resource.util.ResourceUtils;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DeviceHandlerFactory.class}, property={"service.ranking:Integer=1"})
public class IpWeatherRoomSensorChannel
extends AbstractDeviceHandler
implements DeviceHandlerFactory {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public IpWeatherRoomSensorChannel() {
        super(null);
    }

    public IpWeatherRoomSensorChannel(HomeMaticConnection conn) {
        super(conn);
    }

    @Override
    public DeviceHandler createHandler(HomeMaticConnection connection) {
        return new IpWeatherRoomSensorChannel(connection);
    }

    @Override
    public boolean accept(DeviceDescription desc) {
        String parentType = desc.getParentType();
        String type = desc.getType();
        if ("HmIP-STH".equalsIgnoreCase(desc.getParentType()) || "HmIP-STHO".equalsIgnoreCase(desc.getParentType())) {
            System.out.println("Type for " + parentType + " : " + type);
            return "HEATING_CLIMATECONTROL_TRANSCEIVER".equalsIgnoreCase(desc.getType()) || "CLIMATE_TRANSCEIVER".equalsIgnoreCase(desc.getType());
        }
        return false;
    }

    @Override
    public void setup(HmDevice parent, DeviceDescription desc, Map<String, Map<String, ParameterDescription<?>>> paramSets) {
        this.logger.debug("setup WEATHER handler for address {} type {}", (Object)desc.getAddress(), (Object)desc.getType());
        String swName = ResourceUtils.getValidResourceName((String)("WEATHER" + desc.getAddress()));
        Map<String, ParameterDescription<?>> values = paramSets.get(ParameterDescription.SET_TYPES.VALUES.name());
        if (values == null) {
            this.logger.warn("received no VALUES parameters for device {}", (Object)desc.getAddress());
            return;
        }
        HmDevice weatherChannel = this.conn.getChannel(parent, desc.getAddress());
        HashMap<String, SingleValueResource> resources = new HashMap<String, SingleValueResource>();
        for (Map.Entry<String, ParameterDescription<?>> e : values.entrySet()) {
            switch (e.getKey()) {
                case "ACTUAL_TEMPERATURE": {
                    ResourceList sensors = ((SensorDevice)parent.addDecorator(swName, SensorDevice.class)).sensors();
                    sensors.create();
                    TemperatureResource reading = ((TemperatureSensor)sensors.addDecorator(e.getKey(), TemperatureSensor.class)).reading();
                    this.conn.registerControlledResource(weatherChannel, reading.getParent());
                    if (!reading.exists()) {
                        reading.create();
                        reading.getParent().activate(true);
                    }
                    this.logger.debug("found supported HmIP-STH-sensor parameter {} on {}", (Object)e.getKey(), (Object)desc.getAddress());
                    resources.put(e.getKey(), (SingleValueResource)reading);
                    break;
                }
                case "HUMIDITY": {
                    ResourceList sensors = ((SensorDevice)parent.addDecorator(swName, SensorDevice.class)).sensors();
                    sensors.create();
                    TemperatureResource reading = ((HumiditySensor)sensors.addDecorator(e.getKey(), HumiditySensor.class)).reading();
                    this.conn.registerControlledResource(weatherChannel, reading.getParent());
                    if (!reading.exists()) {
                        reading.create();
                        reading.getParent().activate(true);
                    }
                    this.logger.debug("found supported HmIP-STH-sensor parameter {} on {}", (Object)e.getKey(), (Object)desc.getAddress());
                    resources.put(e.getKey(), (SingleValueResource)reading);
                    break;
                }
            }
        }
        this.conn.addEventListener(new WeatherEventListener(resources, desc.getAddress()));
    }

    class ParameterListener
    implements ResourceValueListener<SingleValueResource> {
        final String address;

        public ParameterListener(String address) {
            this.address = address;
        }

        public void resourceChanged(SingleValueResource resource) {
            String paramName = resource.getName();
            Integer resourceValue = null;
            if (resource instanceof IntegerResource) {
                resourceValue = ((IntegerResource)resource).getValue();
            } else {
                IpWeatherRoomSensorChannel.this.logger.warn("unsupported parameter type: " + resource);
            }
            HashMap<String, Object> parameterSet = new HashMap<String, Object>();
            parameterSet.put(paramName, resourceValue);
            IpWeatherRoomSensorChannel.this.conn.performPutParamset(this.address, "MASTER", parameterSet);
            IpWeatherRoomSensorChannel.this.logger.info("Parameter set 'MASTER' updated for {}: {}", (Object)this.address, parameterSet);
        }
    }

    class WeatherEventListener
    implements HmEventListener {
        final Map<String, SingleValueResource> resources;
        final String address;

        public WeatherEventListener(Map<String, SingleValueResource> resources, String address) {
            this.resources = resources;
            this.address = address;
        }

        public void event(List<HmEvent> events) {
            for (HmEvent e : events) {
                SingleValueResource res;
                if (!this.address.equals(e.getAddress()) || (res = this.resources.get(e.getValueKey())) == null) continue;
                try {
                    PARAMS p = PARAMS.valueOf(e.getValueKey());
                    ((FloatResource)res).setValue(p.convertInput(e.getValueFloat()));
                    IpWeatherRoomSensorChannel.this.logger.debug("resource updated: {} = {}", (Object)res.getPath(), e.getValue());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    static enum PARAMS {
        ACTUAL_TEMPERATURE{

            @Override
            public float convertInput(float v) {
                return v + 273.15f;
            }
        }
        ,
        HUMIDITY{

            @Override
            public float convertInput(float v) {
                return v / 100.0f;
            }
        };


        public float convertInput(float v) {
            return v;
        }

        public float convertOutput(float v) {
            return v;
        }
    }
}

