/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl.channels;

import java.util.List;
import java.util.Map;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.drivers.homematic.xmlrpc.hl.api.AbstractDeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.HomeMaticConnection;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmDevice;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEvent;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEventListener;
import org.ogema.drivers.homematic.xmlrpc.ll.api.ParameterDescription;
import org.ogema.model.actors.RemoteControl;
import org.ogema.tools.resource.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyChannel
extends AbstractDeviceHandler {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public KeyChannel(HomeMaticConnection conn) {
        super(conn);
    }

    @Override
    public boolean accept(DeviceDescription desc) {
        return "KEY".equalsIgnoreCase(desc.getType());
    }

    @Override
    public void setup(HmDevice parent, DeviceDescription desc, Map<String, Map<String, ParameterDescription<?>>> paramSets) {
        this.logger.debug("setup KEY handler for address {}", (Object)desc.getAddress());
        String remoteName = "KEYS";
        RemoteControl rc = (RemoteControl)parent.addDecorator(remoteName, RemoteControl.class);
        rc.shortPress().create();
        rc.longPress().create();
        rc.activate(true);
        String eventResourceName = this.getEventResourceName(parent, desc);
        this.logger.debug("mapping channel {} of device type {} to {}", new Object[]{desc.getAddress(), parent.type().getValue(), eventResourceName});
        BooleanResource shortPressEventResource = (BooleanResource)((BooleanResource)rc.shortPress().addDecorator(eventResourceName, BooleanResource.class)).create();
        BooleanResource longPressEventResource = (BooleanResource)((BooleanResource)rc.longPress().addDecorator(eventResourceName, BooleanResource.class)).create();
        this.conn.addEventListener(new KeyEventListener(desc.getAddress(), shortPressEventResource, longPressEventResource));
    }

    protected String getEventResourceName(HmDevice device, DeviceDescription keyChannel) {
        String channelAddress;
        int i;
        if ("HM-RC-4-3".equals(device.type().getValue())) {
            if (keyChannel.getAddress().endsWith(":2")) {
                return "KEY1";
            }
            if (keyChannel.getAddress().endsWith(":1")) {
                return "KEY2";
            }
            if (keyChannel.getAddress().endsWith(":4")) {
                return "KEY3";
            }
            if (keyChannel.getAddress().endsWith(":3")) {
                return "KEY4";
            }
        }
        if ((i = (channelAddress = keyChannel.getAddress()).lastIndexOf(":")) > -1) {
            try {
                int channelNum = Integer.parseInt(channelAddress.substring(i + 1));
                return "KEY" + channelNum;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ResourceUtils.getValidResourceName((String)("KEY_" + keyChannel.getAddress()));
    }

    class KeyEventListener
    implements HmEventListener {
        final String address;
        final BooleanResource longPressEventResource;
        final BooleanResource shortPressEventResource;

        public KeyEventListener(String address, BooleanResource shortPress, BooleanResource longPress) {
            this.address = address;
            this.shortPressEventResource = shortPress;
            this.longPressEventResource = longPress;
        }

        public void event(List<HmEvent> events) {
            block8: for (HmEvent e : events) {
                if (!this.address.equals(e.getAddress())) continue;
                switch (e.getValueKey()) {
                    case "PRESS_SHORT": {
                        this.shortPressEventResource.activate(false);
                        this.shortPressEventResource.setValue(true);
                        KeyChannel.this.logger.debug("short press event on {}", (Object)this.shortPressEventResource.getPath());
                        continue block8;
                    }
                    case "PRESS_LONG": {
                        this.longPressEventResource.activate(false);
                        this.longPressEventResource.setValue(true);
                        KeyChannel.this.logger.debug("long press event on {}", (Object)this.longPressEventResource.getPath());
                        continue block8;
                    }
                }
                KeyChannel.this.logger.trace("unsupported KEY event '{}'", (Object)e.getValueKey());
            }
        }
    }
}

