/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl.channels;

import java.util.List;
import java.util.Map;
import org.ogema.drivers.homematic.xmlrpc.hl.api.AbstractDeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.HomeMaticConnection;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmDevice;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEvent;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEventListener;
import org.ogema.drivers.homematic.xmlrpc.ll.api.ParameterDescription;
import org.ogema.model.sensors.OccupancySensor;
import org.ogema.tools.resource.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MotionDetectorChannel
extends AbstractDeviceHandler {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public MotionDetectorChannel(HomeMaticConnection conn) {
        super(conn);
    }

    @Override
    public boolean accept(DeviceDescription desc) {
        return "MOTION_DETECTOR".equalsIgnoreCase(desc.getType());
    }

    @Override
    public void setup(HmDevice parent, DeviceDescription desc, Map<String, Map<String, ParameterDescription<?>>> paramSets) {
        this.logger.debug("setup MOTION_DETECTOR handler for address {}", (Object)desc.getAddress());
        String swName = ResourceUtils.getValidResourceName((String)("MOTION_DETECTOR" + desc.getAddress()));
        Map<String, ParameterDescription<?>> values = paramSets.get(ParameterDescription.SET_TYPES.VALUES.name());
        if (values == null) {
            this.logger.warn("received no VALUES parameters for device {}", (Object)desc.getAddress());
            return;
        }
        OccupancySensor sens = (OccupancySensor)parent.addDecorator(swName, OccupancySensor.class);
        sens.reading().create();
        sens.activate(true);
        this.conn.addEventListener(new MotionEventListener(sens, desc.getAddress()));
    }

    class MotionEventListener
    implements HmEventListener {
        final OccupancySensor sens;
        final String address;

        public MotionEventListener(OccupancySensor sens, String address) {
            this.sens = sens;
            this.address = address;
        }

        public void event(List<HmEvent> events) {
            for (HmEvent e : events) {
                if (!this.address.equals(e.getAddress())) continue;
                if (PARAMS.MOTION.name().equals(e.getValueKey())) {
                    this.sens.reading().setValue(e.getValueBoolean());
                    MotionDetectorChannel.this.logger.debug("MOTION_DETECTOR {} motion detected: {}", (Object)e.getAddress(), (Object)e.getValueBoolean());
                    continue;
                }
                if (!PARAMS.ERROR.name().equals(e.getValueKey())) continue;
                int n = e.getValueInt();
            }
        }
    }

    static enum PARAMS {
        MOTION,
        BRIGHTNESS,
        ERROR;

    }
}

