/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl.channels;

import java.util.List;
import java.util.Map;
import org.ogema.core.model.Resource;
import org.ogema.core.resourcemanager.ResourceStructureEvent;
import org.ogema.core.resourcemanager.ResourceStructureListener;
import org.ogema.drivers.homematic.xmlrpc.hl.api.AbstractDeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.HomeMaticConnection;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmDevice;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.ParameterDescription;
import org.ogema.model.actors.OnOffSwitch;
import org.ogema.model.connections.ElectricityConnection;
import org.ogema.model.devices.sensoractordevices.SingleSwitchBox;
import org.ogema.tools.resource.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMSwitchDevice
extends AbstractDeviceHandler {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public PMSwitchDevice(HomeMaticConnection conn) {
        super(conn);
    }

    @Override
    public boolean accept(DeviceDescription desc) {
        String type = desc.getType();
        return "HM-ES-PMSw1-Pl".equals(type) || "HM-ES-PMSw1-Pl-DN-R1".equals(type) || "HMIP-PSM".equals(type);
    }

    protected ResourceStructureListener subChannelListener(final HmDevice dev) {
        return new ResourceStructureListener(){

            public void resourceStructureChanged(ResourceStructureEvent event) {
                if (event.getType() == ResourceStructureEvent.EventType.SUBRESOURCE_ADDED && PMSwitchDevice.this.performSwitchBoxSetup(dev)) {
                    dev.removeStructureListener(this);
                }
            }
        };
    }

    @Override
    public void setup(HmDevice pmswitch, DeviceDescription desc, Map<String, Map<String, ParameterDescription<?>>> paramSets) {
        ResourceStructureListener l = this.subChannelListener(pmswitch);
        pmswitch.addStructureListener(l);
        if (this.performSwitchBoxSetup(pmswitch)) {
            pmswitch.removeStructureListener(l);
        }
    }

    protected boolean performSwitchBoxSetup(HmDevice dev) {
        List elConns = dev.getSubResources(ElectricityConnection.class, false);
        List switches = dev.getSubResources(OnOffSwitch.class, false);
        if (elConns.size() == 1 && switches.size() == 1) {
            String ssbName = ResourceUtils.getValidResourceName((String)("HM-SingleSwitchBox-" + dev.address().getValue()));
            this.logger.debug("set up SingleSwitchBox for HomeMatic device {}", (Object)dev.address().getValue());
            OnOffSwitch sw = (OnOffSwitch)switches.get(0);
            ElectricityConnection elConn = (ElectricityConnection)elConns.get(0);
            SingleSwitchBox ssb = (SingleSwitchBox)dev.getSubResource(ssbName, SingleSwitchBox.class);
            ssb.onOffSwitch().stateControl().create().activate(false);
            ssb.onOffSwitch().stateFeedback().create().activate(false);
            ssb.electricityConnection().create().activate(false);
            ssb.onOffSwitch().activate(false);
            elConn.setAsReference((Resource)ssb.electricityConnection());
            sw.setAsReference((Resource)ssb.onOffSwitch());
            ssb.activate(false);
            return true;
        }
        return false;
    }
}

