/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl.channels;

import java.util.List;
import java.util.Map;
import org.ogema.drivers.homematic.xmlrpc.hl.api.AbstractDeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.HomeMaticConnection;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmDevice;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEvent;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEventListener;
import org.ogema.drivers.homematic.xmlrpc.ll.api.ParameterDescription;
import org.ogema.model.sensors.DoorWindowSensor;
import org.ogema.tools.resource.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutterContactChannel
extends AbstractDeviceHandler {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final float LOWBATVALUE = 0.1f;

    public ShutterContactChannel(HomeMaticConnection conn) {
        super(conn);
    }

    @Override
    public boolean accept(DeviceDescription desc) {
        return "SHUTTER_CONTACT".equalsIgnoreCase(desc.getType());
    }

    @Override
    public void setup(HmDevice parent, DeviceDescription desc, Map<String, Map<String, ParameterDescription<?>>> paramSets) {
        this.logger.debug("setup SHUTTER_CONTACT handler for address {}", (Object)desc.getAddress());
        String swName = ResourceUtils.getValidResourceName((String)("SHUTTER_CONTACT" + desc.getAddress()));
        Map<String, ParameterDescription<?>> values = paramSets.get(ParameterDescription.SET_TYPES.VALUES.name());
        if (values == null) {
            this.logger.warn("received no VALUES parameters for device {}", (Object)desc.getAddress());
            return;
        }
        DoorWindowSensor sens = (DoorWindowSensor)parent.addDecorator(swName, DoorWindowSensor.class);
        sens.reading().create();
        sens.activate(true);
        sens.battery().chargeSensor().reading().create();
        sens.activate(true);
        this.conn.addEventListener(new ShutterContactListener(sens, desc.getAddress()));
    }

    class ShutterContactListener
    implements HmEventListener {
        final DoorWindowSensor sens;
        final String address;

        public ShutterContactListener(DoorWindowSensor sens, String address) {
            this.sens = sens;
            this.address = address;
        }

        public void event(List<HmEvent> events) {
            for (HmEvent e : events) {
                if (!this.address.equals(e.getAddress())) continue;
                if (PARAMS.STATE.name().equals(e.getValueKey())) {
                    this.sens.reading().setValue(e.getValueBoolean());
                    ShutterContactChannel.this.logger.debug("SHUTTER_CONTACT {} = {}", (Object)this.address, (Object)e.getValueBoolean());
                    continue;
                }
                if (!PARAMS.LOWBAT.name().equals(e.getValueKey())) continue;
                this.sens.battery().chargeSensor().reading().setValue(e.getValueBoolean() ? 0.1f : 1.0f);
            }
        }
    }

    static enum PARAMS {
        STATE,
        LOWBAT;

    }
}

