/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl.discovery;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.ogema.drivers.homematic.xmlrpc.hl.HmConnection;
import org.ogema.drivers.homematic.xmlrpc.hl.discovery.Ccu;

public class UdpDiscovery
implements AutoCloseable {
    private static final byte UDP_SEPARATOR = 0;
    private static final byte UDP_END = 73;
    private static final byte[] DEVICE_TYPE = "eQ3-*".getBytes(StandardCharsets.UTF_8);
    public static final String DEFAULT_SERIAL_NR = "*";
    public static final long LISTEN_TIMEOUT = 5000L;
    private final List<Future<Collection<Ccu>>> results = Collections.synchronizedList(new ArrayList());
    private final ExecutorService exec = Executors.newFixedThreadPool(4);

    public void submit(final InetAddress broadcastAddress, final NetworkInterface nif, final String serialNumber) {
        try {
            this.results.add(this.exec.submit(new Callable<Collection<Ccu>>(){

                @Override
                public Collection<Ccu> call() throws Exception {
                    return UdpDiscovery.this.sendBroadcast(broadcastAddress, nif, serialNumber);
                }
            }));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        this.exec.shutdownNow();
    }

    public Collection<Ccu> getIntermediateResults(long waitTimeMillis) {
        long start = System.currentTimeMillis();
        for (Future<Collection<Ccu>> f : this.results) {
            long l = waitTimeMillis = waitTimeMillis <= 0L ? waitTimeMillis : waitTimeMillis - (System.currentTimeMillis() - start);
            if (!f.isDone() && waitTimeMillis <= 0L) {
                return null;
            }
            try {
                Collection<Ccu> ccus = f.get(waitTimeMillis <= 0L ? 1L : waitTimeMillis, TimeUnit.MILLISECONDS);
                if (ccus.isEmpty()) continue;
                return ccus;
            }
            catch (InterruptedException e) {
                try {
                    Thread.currentThread().interrupt();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return Collections.emptySet();
            }
            catch (TimeoutException e) {
                return null;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    private Collection<Ccu> sendBroadcast(InetAddress address, NetworkInterface nif, String serialNumber) throws IOException {
        HmConnection.logger.trace("Starting Homematic CCU discovery scan for {}", (Object)address);
        MulticastSocket socket = new MulticastSocket();
        socket.setBroadcast(true);
        socket.setTimeToLive(5);
        socket.setSoTimeout(1000);
        socket.setNetworkInterface(nif);
        byte[] sender = UdpDiscovery.send(socket, address, serialNumber);
        return Collections.unmodifiableCollection(UdpDiscovery.listen(sender, socket));
    }

    private static byte[] send(MulticastSocket socket, InetAddress broadcastAddress, String serialNumber) throws IOException {
        byte[] sender = new byte[3];
        new Random().nextBytes(sender);
        ByteBuffer bb = ByteBuffer.allocate(256);
        bb.put((byte)2);
        bb.put(sender).put((byte)0).put(DEVICE_TYPE).put((byte)0).put(serialNumber.getBytes(StandardCharsets.UTF_8)).put((byte)0).put((byte)73);
        int pos = bb.position();
        bb.rewind();
        DatagramPacket packet = new DatagramPacket(bb.array(), pos, broadcastAddress, 43439);
        socket.send(packet);
        return sender;
    }

    private static Collection<Ccu> listen(byte[] sender, MulticastSocket socket) throws IOException {
        long startTime = System.currentTimeMillis();
        long currentTime = System.currentTimeMillis();
        HashSet<Ccu> responses = new HashSet<Ccu>();
        while (currentTime - startTime < 5000L) {
            Ccu ccu = UdpDiscovery.waitForCcuResponse(sender, socket);
            if (ccu != null) {
                responses.add(ccu);
            }
            currentTime = System.currentTimeMillis();
        }
        HmConnection.logger.trace("CCU responses {}", responses);
        socket.close();
        return responses;
    }

    private static Ccu waitForCcuResponse(byte[] sender, MulticastSocket socket) throws IOException {
        try {
            byte[] buffer = new byte[256];
            DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
            socket.receive(dp);
            byte[] result = dp.getData();
            ByteBuffer bb = ByteBuffer.wrap(result);
            if (!bb.hasRemaining() || bb.get() != 2) {
                return null;
            }
            for (int i = 0; i < sender.length; ++i) {
                if (bb.hasRemaining() && bb.get() == sender[i]) continue;
                return null;
            }
            String type = UdpDiscovery.parseNextString(bb);
            String serialNr = UdpDiscovery.parseNextString(bb);
            return new Ccu(dp.getAddress(), socket.getNetworkInterface(), type, serialNr);
        }
        catch (SocketTimeoutException ex) {
            return null;
        }
    }

    private static String parseNextString(ByteBuffer bb) {
        StringBuilder sb = new StringBuilder();
        boolean started = false;
        while (bb.hasRemaining()) {
            byte b = bb.get();
            if (b == 0) {
                if (!started) continue;
                break;
            }
            if (b == 0) continue;
            sb.append((char)b);
            started = true;
        }
        return sb.toString();
    }
}

