/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.ll;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HomeMatic;
import org.ogema.drivers.homematic.xmlrpc.ll.api.ParameterDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.ServiceMessage;
import org.ogema.drivers.homematic.xmlrpc.ll.api.XmlRpcStruct;
import org.ogema.drivers.homematic.xmlrpc.ll.xmlrpc.DeviceDescriptionXmlRpc;
import org.ogema.drivers.homematic.xmlrpc.ll.xmlrpc.MapXmlRpcStruct;
import org.ogema.drivers.homematic.xmlrpc.ll.xmlrpc.ParameterDescriptionXmlRpc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeMaticClient
implements HomeMatic {
    final XmlRpcClient client;
    final Logger logger;

    public HomeMaticClient(String urlString) throws IOException {
        URL url = new URL(urlString);
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setServerURL(url);
        config.setEnabledForExtensions(true);
        config.setEncoding("ISO-8859-1");
        config.setEnabledForExceptions(true);
        this.client = new XmlRpcClient();
        this.client.setConfig(config);
        this.logger = LoggerFactory.getLogger((String)(this.getClass().getCanonicalName() + "-" + url.getHost()));
    }

    @Override
    public void init(String url, String interfaceId) throws XmlRpcException {
        this.client.execute("init", new Object[]{url, interfaceId});
    }

    @Override
    public void ping(String callerId) throws XmlRpcException {
        this.client.execute("ping", new Object[]{callerId});
    }

    @Override
    public DeviceDescription getDeviceDescription(String address) throws XmlRpcException {
        Object o = this.client.execute("getDeviceDescription", new Object[]{address});
        return new DeviceDescriptionXmlRpc((Map)o);
    }

    @Override
    public List<DeviceDescription> listDevices() throws XmlRpcException {
        Object[] a = (Object[])this.client.execute("listDevices", new Object[0]);
        ArrayList<DeviceDescription> rval = new ArrayList<DeviceDescription>(a.length);
        for (Object o : a) {
            rval.add(new DeviceDescriptionXmlRpc((Map)o));
        }
        return rval;
    }

    @Override
    public Map<String, ParameterDescription<?>> getParamsetDescription(String address, String type) throws XmlRpcException {
        Map rawMap = (Map)this.client.execute("getParamsetDescription", new Object[]{address, type});
        LinkedHashMap rval = new LinkedHashMap();
        for (Map.Entry e : rawMap.entrySet()) {
            rval.put((String)e.getKey(), (ParameterDescription<?>)new ParameterDescriptionXmlRpc((Map)e.getValue()));
        }
        return rval;
    }

    @Override
    public XmlRpcStruct getParamset(String address, String paramset_key) throws XmlRpcException {
        return new MapXmlRpcStruct((Map)this.client.execute("getParamset", new Object[]{address, paramset_key}));
    }

    @Override
    public String getParamsetId(String address, String type) throws XmlRpcException {
        return (String)this.client.execute("getParamsetId", new Object[]{address, type});
    }

    @Override
    public void putParamset(String address, String paramset_key, XmlRpcStruct set) throws XmlRpcException {
        this.client.execute("putParamset", new Object[]{address, paramset_key, set.toMap()});
    }

    @Override
    public int getInstallMode() throws XmlRpcException {
        return ((Number)this.client.execute("getInstallMode", new Object[0])).intValue();
    }

    @Override
    public void setInstallMode(boolean on, int time, int mode) throws XmlRpcException {
        this.client.execute("setInstallMode", new Object[]{on, time, mode});
    }

    @Override
    public <T> T getValue(String address, String value_key) throws XmlRpcException {
        return (T)this.client.execute("getValue", new Object[]{address, value_key});
    }

    @Override
    public void setValue(String address, String value_key, Object value) throws XmlRpcException {
        Object obj = this.client.execute("setValue", new Object[]{address, value_key, value});
        if (obj != null) {
            this.logger.debug("setValue returned object of type: {}, value: {}", (Object)obj.getClass().getName(), (Object)obj.toString());
        } else {
            this.logger.debug("setValue returned object null");
        }
    }

    @Override
    public boolean reportValueUsage(String address, String valueId, int refCounter) throws XmlRpcException {
        return (Boolean)this.client.execute("reportValueUsage", new Object[]{address, valueId, refCounter});
    }

    @Override
    public void addLink(String sender, String receiver, String name, String description) throws XmlRpcException {
        this.client.execute("addLink", new Object[]{sender, receiver, name, description});
    }

    @Override
    public void removeLink(String sender, String receiver) throws XmlRpcException {
        this.client.execute("removeLink", new Object[]{sender, receiver});
    }

    @Override
    public List<String> getLinkPeers(String address) throws XmlRpcException {
        Object[] rval = (Object[])this.client.execute("getLinkPeers", new Object[]{address});
        ArrayList<String> peers = new ArrayList<String>(rval.length);
        for (Object o : rval) {
            peers.add(String.valueOf(o));
        }
        return peers;
    }

    @Override
    public Map<String, Object> getLinkInfo(String sender, String receiver) throws XmlRpcException {
        return (Map)this.client.execute("getLinkInfo", new Object[]{sender, receiver});
    }

    @Override
    public List<Map<String, Object>> getLinks(String address, int flags) throws XmlRpcException {
        Object[] rval = (Object[])this.client.execute("getLinks", new Object[]{address, flags});
        ArrayList<Map<String, Object>> l = new ArrayList<Map<String, Object>>();
        for (Object o : rval) {
            l.add((Map)o);
        }
        return l;
    }

    @Override
    public List<ServiceMessage> getServiceMessages() throws XmlRpcException {
        Object o = this.client.execute("getServiceMessages", new Object[0]);
        if (o != null && !(o instanceof Object[])) {
            System.err.printf("getServiceMessages strange return value: '%s'%n", o);
            return Collections.emptyList();
        }
        Object[] rval = (Object[])o;
        if (rval == null || rval.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ServiceMessage> l = new ArrayList<ServiceMessage>(rval.length);
        for (Object e : rval) {
            l.add(new DefaultServiceMessage((Object[])e));
        }
        return l;
    }

    @Override
    public void deleteDevice(String address, int flags) throws XmlRpcException {
        this.client.execute("deleteDevice", new Object[]{address, flags});
    }

    @Override
    public void abortDeleteDevice(String address) throws XmlRpcException {
        this.client.execute("abortDeleteDevice", new Object[]{address});
    }

    @Override
    public XmlRpcStruct rssiInfo() throws XmlRpcException {
        return new MapXmlRpcStruct((Map)this.client.execute("rssiInfo", new Object[0]));
    }

    public static class DefaultServiceMessage
    implements ServiceMessage {
        private final String address;
        private final String ID;
        private final Object value;

        DefaultServiceMessage(String address, String ID, Object value) {
            this.address = address;
            this.ID = ID;
            this.value = value;
        }

        DefaultServiceMessage(Object[] a) {
            this.address = (String)a[0];
            this.ID = (String)a[1];
            this.value = a[2];
        }

        @Override
        public String getAddress() {
            return this.address;
        }

        @Override
        public String getID() {
            return this.ID;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("(%s, %s, %s)", this.address, this.ID, this.value);
        }
    }
}

