/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.ll;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HomeMatic;
import org.ogema.drivers.homematic.xmlrpc.ll.api.ParameterDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.ServiceMessage;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class HomeMaticClientCli {
    private final HomeMatic client;

    public HomeMaticClientCli(HomeMatic client) {
        this.client = client;
    }

    public ServiceRegistration<HomeMaticClientCli> register(BundleContext ctx, String commandScope) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.command.scope", commandScope);
        ((Dictionary)props).put("osgi.command.function", new String[]{"list", "params", "tim", "read", "readValue", "valueUsage", "set", "addLink", "removeLink", "getLinkInfo", "getLinks", "deleteDevice", "abortDeleteDevice", "getServiceMessages", "client"});
        return ctx.registerService(HomeMaticClientCli.class, (Object)this, props);
    }

    public ServiceRegistration<HomeMaticClientCli> register(BundleContext ctx) {
        return this.register(ctx, "hm");
    }

    public void list() throws Exception {
        List<DeviceDescription> l = this.client.listDevices();
        for (DeviceDescription dd : l) {
            System.out.printf("%s%s (v%s) @ %s%n", dd.isDevice() ? "" : "  ", dd.getType(), dd.getVersion(), dd.getAddress());
        }
    }

    public void params(String addr) throws Exception {
        DeviceDescription dd = this.client.getDeviceDescription(addr);
        for (String setName : dd.getParamsets()) {
            Map<String, ParameterDescription<?>> params = this.client.getParamsetDescription(addr, setName);
            for (Map.Entry<String, ParameterDescription<?>> entrySet : params.entrySet()) {
                String key = entrySet.getKey();
                ParameterDescription<?> value = entrySet.getValue();
                System.out.printf("[%s] %s = ", setName, key);
                this.printParameterDescription(value, System.out);
                System.out.printf("%n", new Object[0]);
            }
        }
    }

    private void printParameterDescription(ParameterDescription<?> desc, PrintStream out) {
        Map<String, Object> struct = desc.toMap();
        out.append("{");
        boolean firstEntry = true;
        for (Map.Entry<String, Object> e : struct.entrySet()) {
            if (firstEntry) {
                firstEntry = false;
            } else {
                out.append(", ");
            }
            out.append(e.getKey()).append("=");
            Object val = e.getValue();
            if (val.getClass().isArray()) {
                try {
                    out.append(Arrays.toString((Object[])val));
                }
                catch (StackOverflowError wtf) {
                    out.append("XXXXXXXXXXXXXXXX");
                }
                continue;
            }
            out.append(val.toString());
        }
        out.append("}");
    }

    public void read(String addr) throws Exception {
        DeviceDescription dd = this.client.getDeviceDescription(addr);
        for (String setName : dd.getParamsets()) {
            Map<String, Object> values = this.client.getParamset(addr, setName).toMap();
            ArrayList<String> keys = new ArrayList<String>(values.keySet());
            Collections.sort(keys, String.CASE_INSENSITIVE_ORDER);
            if (keys.isEmpty()) {
                System.out.printf("%s values: {}%n", setName);
                continue;
            }
            System.out.printf("%s values: {%n", setName);
            for (String key : keys) {
                System.out.printf("  %s=%s%n", key, values.get(key));
            }
            System.out.printf("}%n", setName);
        }
    }

    public void tim() throws Exception {
        int rem = this.client.getInstallMode();
        if (rem > 0) {
            this.client.setInstallMode(false, 0, 1);
        } else {
            this.client.setInstallMode(true, 900, 1);
        }
        rem = this.client.getInstallMode();
        if (rem == 0) {
            System.out.printf("install mode off%n", new Object[0]);
        } else {
            System.out.printf("install mode on, time remaining = %ds%n", rem);
        }
    }

    public void valueUsage(String address, String valueId, int refCounter) throws Exception {
        System.out.println(this.client.reportValueUsage(address, valueId, refCounter));
    }

    public void set(String address, String valueId, Object value) throws Exception {
        this.client.setValue(address, valueId, value);
        System.out.printf("value=%s%n", String.valueOf(this.client.getValue(address, valueId)));
    }

    public void readValue(String address, String valueKey) throws Exception {
        System.out.println(this.client.getValue(address, valueKey));
    }

    public void addLink(String sender, String receiver, String name, String description) throws Exception {
        this.client.addLink(sender, receiver, name, description);
    }

    public void removeLink(String sender, String receiver) throws Exception {
        this.client.removeLink(sender, receiver);
    }

    public Map<String, Object> getLinkInfo(String sender, String receiver) throws Exception {
        return this.client.getLinkInfo(sender, receiver);
    }

    public void getLinks(String address, int flags) throws Exception {
        System.out.println(this.client.getLinks(address, flags));
    }

    public void deleteDevice(String address, int flags) throws Exception {
        this.client.deleteDevice(address, flags);
    }

    public void abortDeleteDevice(String address) throws Exception {
        this.client.abortDeleteDevice(address);
    }

    public void getServiceMessages() throws Exception {
        for (ServiceMessage msg : this.client.getServiceMessages()) {
            System.out.println(msg);
        }
    }

    public HomeMatic client(String none) {
        return this.client;
    }
}

