/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.ll.xmlrpc;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.xmlrpc.MapXmlRpcStruct;

public class DeviceDescriptionXmlRpc
extends MapXmlRpcStruct
implements DeviceDescription {
    static final List<DeviceDescription.KEYS> REQUIRED_KEYS = Arrays.asList(DeviceDescription.KEYS.PARAMSETS, DeviceDescription.KEYS.RF_ADDRESS, DeviceDescription.KEYS.CHILDREN, DeviceDescription.KEYS.INTERFACE, DeviceDescription.KEYS.RX_MODE, DeviceDescription.KEYS.ADDRESS, DeviceDescription.KEYS.FIRMWARE, DeviceDescription.KEYS.PARENT, DeviceDescription.KEYS.VERSION, DeviceDescription.KEYS.FLAGS, DeviceDescription.KEYS.ROAMING, DeviceDescription.KEYS.TYPE);
    private static final Map<DeviceDescription.KEYS, Object> EMPTYDEVICE = new LinkedHashMap<DeviceDescription.KEYS, Object>();

    public DeviceDescriptionXmlRpc(Map<String, Object> struct) {
        super(struct);
    }

    public DeviceDescriptionXmlRpc(DeviceDescription desc) {
        super(new LinkedHashMap<String, Object>());
        for (String key : desc.keySet()) {
            this.struct.put(key, desc.getValue(key));
        }
    }

    public DeviceDescriptionXmlRpc(String address, int version) {
        super(new LinkedHashMap<String, Object>());
        for (Map.Entry<DeviceDescription.KEYS, Object> e : EMPTYDEVICE.entrySet()) {
            this.struct.put(e.getKey().name(), e.getValue());
        }
        this.struct.put(DeviceDescription.KEYS.ADDRESS.name(), address);
        this.struct.put(DeviceDescription.KEYS.VERSION.name(), version);
    }

    public static String[] asStringArray(Object[] a) {
        if (a == null) {
            return null;
        }
        String[] s = new String[a.length];
        for (int i = 0; i < a.length; ++i) {
            s[i] = a[i].toString();
        }
        return s;
    }

    @Override
    public String getAddress() {
        return this.getString(DeviceDescription.KEYS.ADDRESS.name());
    }

    @Override
    public String[] getParamsets() {
        return this.getStringArray(DeviceDescription.KEYS.PARAMSETS.name());
    }

    @Override
    public String getParent() {
        return this.getString(DeviceDescription.KEYS.PARENT.name());
    }

    @Override
    public String getParentType() {
        return this.getString(DeviceDescription.KEYS.PARENT_TYPE.name());
    }

    @Override
    public String getType() {
        return this.getString(DeviceDescription.KEYS.TYPE.name());
    }

    @Override
    public boolean isDevice() {
        String parent = this.getParent();
        return parent == null || parent.isEmpty();
    }

    @Override
    public int getVersion() {
        return this.getInt(DeviceDescription.KEYS.VERSION.name());
    }

    @Override
    public String[] getChildren() {
        return this.getStringArray(DeviceDescription.KEYS.CHILDREN.name());
    }

    static {
        EMPTYDEVICE.put(DeviceDescription.KEYS.PARAMSETS, new Object[0]);
        EMPTYDEVICE.put(DeviceDescription.KEYS.RF_ADDRESS, 0);
        EMPTYDEVICE.put(DeviceDescription.KEYS.CHILDREN, new Object[0]);
        EMPTYDEVICE.put(DeviceDescription.KEYS.UPDATABLE, 0);
        EMPTYDEVICE.put(DeviceDescription.KEYS.INTERFACE, "");
        EMPTYDEVICE.put(DeviceDescription.KEYS.RX_MODE, 0);
        EMPTYDEVICE.put(DeviceDescription.KEYS.ADDRESS, "");
        EMPTYDEVICE.put(DeviceDescription.KEYS.FIRMWARE, "?");
        EMPTYDEVICE.put(DeviceDescription.KEYS.PARENT, "");
        EMPTYDEVICE.put(DeviceDescription.KEYS.VERSION, 0);
        EMPTYDEVICE.put(DeviceDescription.KEYS.FLAGS, 0);
        EMPTYDEVICE.put(DeviceDescription.KEYS.ROAMING, 0);
        EMPTYDEVICE.put(DeviceDescription.KEYS.TYPE, "");
    }
}

