/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.ll;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.Servlet;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.server.RequestProcessorFactoryFactory;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceListener;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmBackend;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEvent;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEventListener;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HomeMatic;
import org.ogema.drivers.homematic.xmlrpc.ll.internal.DefaultHmEvent;
import org.ogema.drivers.homematic.xmlrpc.ll.internal.HomeMaticCalls;
import org.ogema.drivers.homematic.xmlrpc.ll.internal.HomeMaticXmlRpcServlet;
import org.ogema.drivers.homematic.xmlrpc.ll.internal.SystemCalls;
import org.ogema.drivers.homematic.xmlrpc.ll.xmlrpc.DeviceDescriptionXmlRpc;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeMaticService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String interfaceUrl;
    private List<DeviceListener> deviceListeners = new CopyOnWriteArrayList<DeviceListener>();
    private List<HmEventListener> eventListeners = new CopyOnWriteArrayList<HmEventListener>();
    private final ServiceRegistration<Servlet> registration;
    private final HomeMaticXmlRpcServlet servlet;
    private HmBackend backend;
    HomeMaticCalls defaultHandler = new HomeMaticCalls(){

        @Override
        public Object listDevices(String param) {
            HomeMaticService.this.logger.info("listDevices {}", (Object)param);
            ArrayList<Map<String, Object>> rval = new ArrayList<Map<String, Object>>();
            for (DeviceDescription dd : HomeMaticService.this.backend.getKnownDevices(param)) {
                rval.add(new DeviceDescriptionXmlRpc(dd).getStruct());
            }
            return rval;
        }

        @Override
        public Void newDevices(String interfaceId, Object[] descriptions) {
            HomeMaticService.this.logger.info("newDevices interface: {}", (Object)interfaceId);
            ArrayList<DeviceDescriptionXmlRpc> dds = new ArrayList<DeviceDescriptionXmlRpc>(descriptions.length);
            for (Object o : descriptions) {
                dds.add(new DeviceDescriptionXmlRpc((Map)o));
            }
            for (DeviceListener l : HomeMaticService.this.deviceListeners) {
                l.deviceAdded(interfaceId, Collections.unmodifiableList(dds));
            }
            return null;
        }

        @Override
        public Void deleteDevices(String interfaceId, Object[] addresses) {
            HomeMaticService.this.logger.warn("received unsupported deleteDevices calls: iterface={}, addresses={}", (Object)interfaceId, Arrays.asList(addresses));
            return null;
        }

        @Override
        public Void readdedDevice(String interfaceId, String[] addresses) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Void replaceDevice(String interfaceId, String oldDeviceAddress, String newDeviceAddress) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Void updateDevice(String interfaceId, String address, int hint) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Void event(String interfaceId, String address, String valueKey, int value) {
            DefaultHmEvent e = new DefaultHmEvent(interfaceId, address, valueKey, value);
            HomeMaticService.this.logger.trace("event({},{},{},{})", new Object[]{interfaceId, address, valueKey, value});
            List<HmEvent> events = Collections.singletonList(e);
            for (HmEventListener l : HomeMaticService.this.eventListeners) {
                l.event(events);
            }
            return null;
        }
    };
    SystemCalls systemHandler = new SystemCalls(){

        @Override
        public Object multicall(Object[] calls) {
            if (HomeMaticService.this.logger.isDebugEnabled()) {
                for (int i = 0; i < calls.length; ++i) {
                    Map call = (Map)calls[i];
                    String methodName = call.get("methodName").toString();
                    Object[] callParams = (Object[])call.get("params");
                    HomeMaticService.this.logger.debug("multicall {}/{}: {}({})", new Object[]{i + 1, calls.length, methodName, Arrays.asList(callParams)});
                }
            }
            ArrayList<DefaultHmEvent> events = new ArrayList<DefaultHmEvent>();
            for (Object callO : calls) {
                Map call = (Map)callO;
                String methodName = call.get("methodName").toString();
                Object[] callParams = (Object[])call.get("params");
                if ("event".equals(methodName)) {
                    String interfaceId = String.valueOf(callParams[0]);
                    String address = String.valueOf(callParams[1]);
                    String valueKey = String.valueOf(callParams[2]);
                    Object value = callParams[3];
                    HomeMaticService.this.logger.trace("event({},{},{},{})", new Object[]{interfaceId, address, valueKey, value});
                    events.add(new DefaultHmEvent(interfaceId, address, valueKey, value));
                    continue;
                }
                HomeMaticService.this.logger.warn("unsupported multicall method: {}", (Object)methodName);
                for (int j = 0; j < callParams.length; ++j) {
                    HomeMaticService.this.logger.debug("param {}: {}", (Object)j, callParams[j]);
                }
            }
            if (!events.isEmpty()) {
                HomeMaticService.this.logger.debug("Processing " + events.size() + " for " + HomeMaticService.this.eventListeners.size() + " event listeners. First address:" + ((HmEvent)events.get(0)).getAddress());
                for (HmEventListener l : HomeMaticService.this.eventListeners) {
                    l.event(Collections.unmodifiableList(events));
                }
            }
            Object[] result = new Object[calls.length];
            return result;
        }

        @Override
        public Object listMethods(String s) {
            return new String[]{"listDevices", "newDevices"};
        }
    };
    RequestProcessorFactoryFactory procfac = new RequestProcessorFactoryFactory(){
        RequestProcessorFactoryFactory.RequestProcessorFactory rpfSystem = new RequestProcessorFactoryFactory.RequestProcessorFactory(){

            @Override
            public Object getRequestProcessor(XmlRpcRequest pRequest) throws XmlRpcException {
                return HomeMaticService.this.systemHandler;
            }
        };
        RequestProcessorFactoryFactory.RequestProcessorFactory rpfDefault = new RequestProcessorFactoryFactory.RequestProcessorFactory(){

            @Override
            public Object getRequestProcessor(XmlRpcRequest pRequest) throws XmlRpcException {
                return HomeMaticService.this.defaultHandler;
            }
        };

        @Override
        public RequestProcessorFactoryFactory.RequestProcessorFactory getRequestProcessorFactory(Class pClass) throws XmlRpcException {
            if (pClass.equals(SystemCalls.class)) {
                return this.rpfSystem;
            }
            if (pClass.equals(HomeMaticCalls.class)) {
                return this.rpfDefault;
            }
            return null;
        }
    };

    public HomeMaticService(BundleContext ctx, String urlBase, String alias) {
        this.interfaceUrl = urlBase + alias;
        this.servlet = new HomeMaticXmlRpcServlet(ctx, this.procfac);
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        ((Dictionary)parameters).put("osgi.http.whiteboard.servlet.pattern", alias);
        ((Dictionary)parameters).put("servlet.init.enabledForExtensions", "true");
        ((Dictionary)parameters).put("servlet.init.encoding", "ISO-8859-1");
        this.registration = ctx.registerService(Servlet.class, (Object)this.servlet, parameters);
    }

    public void close() {
        try {
            this.registration.unregister();
            this.servlet.destroy();
        }
        catch (Exception e) {
            this.logger.error("Error removing HomeMatic servlet", (Throwable)e);
        }
    }

    public void addDeviceListener(DeviceListener l) {
        this.deviceListeners.add(l);
    }

    public void removeDeviceListener(DeviceListener l) {
        this.deviceListeners.remove(l);
    }

    public void addEventListener(HmEventListener l) {
        this.eventListeners.add(l);
    }

    public void removeEventListener(HmEventListener l) {
        this.eventListeners.remove(l);
    }

    public void setBackend(HmBackend b) {
        this.backend = b;
    }

    public void init(HomeMatic client, String interfaceId) throws XmlRpcException {
        this.logger.debug("register logic interface {}, url {}", (Object)interfaceId, (Object)this.interfaceUrl);
        client.init(this.interfaceUrl, interfaceId);
    }
}

