/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.ll;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.felix.service.command.Descriptor;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HomeMatic;
import org.ogema.drivers.homematic.xmlrpc.ll.api.ParameterDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.ServiceMessage;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class HomeMaticClientCli {
    private final HomeMatic client;

    public HomeMaticClientCli(HomeMatic client) {
        this.client = client;
    }

    public ServiceRegistration<HomeMaticClientCli> register(BundleContext ctx, String commandScope) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.command.scope", commandScope);
        ((Dictionary)props).put("osgi.command.function", new String[]{"list", "params", "tim", "read", "readValue", "valueUsage", "set", "addLink", "removeLink", "getLinkInfo", "getLinks", "deleteDevice", "abortDeleteDevice", "getServiceMessages", "client", "ping"});
        return ctx.registerService(HomeMaticClientCli.class, (Object)this, props);
    }

    public ServiceRegistration<HomeMaticClientCli> register(BundleContext ctx) {
        return this.register(ctx, "hm");
    }

    @Descriptor(value="Read and print the list of known devices along with their type and version.")
    public void list() throws Exception {
        List<DeviceDescription> l = this.client.listDevices();
        for (DeviceDescription dd : l) {
            System.out.printf("%s%s (v%s) @ %s%n", dd.isDevice() ? "" : "  ", dd.getType(), dd.getVersion(), dd.getAddress());
        }
    }

    @Descriptor(value="Read and print all available parameter descriptions from a device.")
    public void params(@Descriptor(value="Device/channel address, such as 'LEQ0568335' or 'LEQ0568335:1'") String addr) throws Exception {
        DeviceDescription dd = this.client.getDeviceDescription(addr);
        for (String setName : dd.getParamsets()) {
            Map<String, ParameterDescription<?>> params = this.client.getParamsetDescription(addr, setName);
            for (Map.Entry<String, ParameterDescription<?>> entrySet : params.entrySet()) {
                String key = entrySet.getKey();
                ParameterDescription<?> value = entrySet.getValue();
                System.out.printf("[%s] %s = ", setName, key);
                HomeMaticClientCli.printParameterDescription(value, System.out);
                System.out.printf("%n", new Object[0]);
            }
        }
    }

    private static void printParameterDescription(ParameterDescription<?> desc, PrintStream out) {
        Map<String, Object> struct = desc.toMap();
        out.append("{");
        boolean firstEntry = true;
        for (Map.Entry<String, Object> e : struct.entrySet()) {
            if (firstEntry) {
                firstEntry = false;
            } else {
                out.append(", ");
            }
            out.append(e.getKey()).append("=");
            Object val = e.getValue();
            if (val.getClass().isArray()) {
                try {
                    out.append(Arrays.toString((Object[])val));
                }
                catch (StackOverflowError wtf) {
                    out.append("XXXXXXXXXXXXXXXX");
                }
                continue;
            }
            out.append(val.toString());
        }
        out.append("}");
    }

    @Descriptor(value="Read and print all available parameter sets from a device.")
    public void read(@Descriptor(value="Device/channel address, such as 'LEQ0568335' or 'LEQ0568335:1'") String addr) throws Exception {
        DeviceDescription dd = this.client.getDeviceDescription(addr);
        for (String setName : dd.getParamsets()) {
            Map<String, Object> values = this.client.getParamset(addr, setName).toMap();
            ArrayList<String> keys = new ArrayList<String>(values.keySet());
            Collections.sort(keys, String.CASE_INSENSITIVE_ORDER);
            if (keys.isEmpty()) {
                System.out.printf("%s values: {}%n", setName);
                continue;
            }
            System.out.printf("%s values: {%n", setName);
            for (String key : keys) {
                System.out.printf("  %s=%s%n", key, values.get(key));
            }
            System.out.printf("}%n", setName);
        }
    }

    @Descriptor(value="Toggle installation mode")
    public void tim() throws Exception {
        int rem = this.client.getInstallMode();
        if (rem > 0) {
            this.client.setInstallMode(false, 0, 1);
        } else {
            this.client.setInstallMode(true, 900, 1);
        }
        rem = this.client.getInstallMode();
        if (rem == 0) {
            System.out.printf("install mode off%n", new Object[0]);
        } else {
            System.out.printf("install mode on, time remaining = %ds%n", rem);
        }
    }

    @Descriptor(value="Ping")
    public void ping(@Descriptor(value="Caller id") String callerId) throws Exception {
        this.client.ping(callerId);
    }

    @Descriptor(value="value usage")
    public void valueUsage(@Descriptor(value="Device/channel address, such as 'LEQ0568335' or 'LEQ0568335:1'") String address, @Descriptor(value="Value id") String valueId, @Descriptor(value="Reference counter") int refCounter) throws Exception {
        System.out.println(this.client.reportValueUsage(address, valueId, refCounter));
    }

    @Descriptor(value="Set parameter value")
    public void set(@Descriptor(value="Device/channel address, such as 'LEQ0568335' or 'LEQ0568335:1'") String address, @Descriptor(value="Parameter key") String valueId, @Descriptor(value="Value") Object value) throws Exception {
        this.client.setValue(address, valueId, value);
        System.out.printf("value=%s%n", String.valueOf(this.client.getValue(address, valueId)));
    }

    @Descriptor(value="Read a parameter value")
    public Object readValue(@Descriptor(value="Device/channel address, such as 'LEQ0568335' or 'LEQ0568335:1'") String address, @Descriptor(value="Value key") String valueKey) throws Exception {
        return this.client.getValue(address, valueKey);
    }

    @Descriptor(value="Create a link between two devices")
    public void addLink(@Descriptor(value="Sender address") String sender, @Descriptor(value="Receiver address") String receiver, @Descriptor(value="Name (??)") String name, @Descriptor(value="Description (??)") String description) throws Exception {
        this.client.addLink(sender, receiver, name, description);
    }

    @Descriptor(value="Example to remove a link from a TH sensor (LEQ0568335) to a thermostat (OEQ2083227) (non-IP): \"removeLink LEQ0568335:1 OEQ2083227:1\"")
    public void removeLink(@Descriptor(value="Sender") String sender, @Descriptor(value="Receiver") String receiver) throws Exception {
        this.client.removeLink(sender, receiver);
    }

    public Map<String, Object> getLinkInfo(@Descriptor(value="Sender") String sender, @Descriptor(value="Receiver") String receiver) throws Exception {
        return this.client.getLinkInfo(sender, receiver);
    }

    public void getLinks(@Descriptor(value="Device/channel address, such as 'LEQ0568335' or 'LEQ0568335:1'") String address, @Descriptor(value="Flags (??)") int flags) throws Exception {
        System.out.println(this.client.getLinks(address, flags));
    }

    public void deleteDevice(@Descriptor(value="Device/channel address, such as 'LEQ0568335' or 'LEQ0568335:1'") String address, @Descriptor(value="Flags (??)") int flags) throws Exception {
        this.client.deleteDevice(address, flags);
    }

    public void abortDeleteDevice(@Descriptor(value="Device/channel address, such as 'LEQ0568335' or 'LEQ0568335:1'") String address) throws Exception {
        this.client.abortDeleteDevice(address);
    }

    public void getServiceMessages() throws Exception {
        for (ServiceMessage msg : this.client.getServiceMessages()) {
            System.out.println(msg);
        }
    }

    public HomeMatic client(String none) {
        return this.client;
    }
}

