/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.modbus;

import com.ghgande.j2mod.modbus.io.ModbusSerialTransaction;
import com.ghgande.j2mod.modbus.io.ModbusTCPTransaction;
import com.ghgande.j2mod.modbus.io.ModbusTransaction;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.net.SerialConnection;
import com.ghgande.j2mod.modbus.net.TCPMasterConnection;
import com.ghgande.j2mod.modbus.util.SerialParameters;
import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.ogema.core.channelmanager.driverspi.ChannelLocator;
import org.ogema.core.channelmanager.driverspi.DeviceLocator;
import org.ogema.core.hardwaremanager.HardwareDescriptor;
import org.ogema.core.hardwaremanager.HardwareManager;
import org.ogema.core.hardwaremanager.SerialHardwareDescriptor;
import org.ogema.core.hardwaremanager.UsbHardwareDescriptor;
import org.ogema.driver.modbus.Channel;
import org.ogema.driver.modbus.ModbusDriver;

public class Connection {
    private final DeviceLocator locator;
    private final ModbusDriver driver;
    private final List<Channel> channels = new ArrayList<Channel>();
    private Object connection;
    private ModbusTransaction transaction;

    Connection(ModbusDriver driver, DeviceLocator locator) throws IOException {
        this.driver = driver;
        this.locator = locator;
        this.createTransaction(locator);
    }

    private void createTransaction(DeviceLocator locator) throws IOException {
        if (locator.getInterfaceName() != null && !"".equals(locator.getInterfaceName())) {
            if (locator.getParameters() == null) {
                throw new IOException("malformed DeviceLocator. getParameters() == 0 for RTU connection");
            }
            SerialParameters params = this.parseParameterString(locator.getParameters());
            params.setPortName(locator.getInterfaceName());
            params.setEncoding("rtu");
            SerialConnection con = new SerialConnection(params);
            try {
                con.open();
            }
            catch (Exception e) {
                throw new IOException("could not open serial connection. Original Message: " + e.getMessage(), e);
            }
            this.connection = con;
            this.transaction = new ModbusSerialTransaction(con);
        } else if (locator.getDeviceAddress() != null) {
            String addr = locator.getDeviceAddress();
            final String[] parts = addr.split(":");
            Object o = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    TCPMasterConnection con;
                    try {
                        InetAddress ipAddr = InetAddress.getByName(parts[0]);
                        con = new TCPMasterConnection(ipAddr);
                        if (parts.length > 1) {
                            try {
                                int port = Integer.parseInt(parts[1]);
                                con.setPort(port);
                            }
                            catch (NumberFormatException e) {
                                throw new IOException("malformed DeviceLocator. getDeviceAdress() returned contained illegal port number", e);
                            }
                        }
                        con.connect();
                    }
                    catch (IOException e) {
                        return e;
                    }
                    catch (Exception e) {
                        return new IOException("could not open tcp connection", e);
                    }
                    return con;
                }
            });
            if (o instanceof IOException) {
                throw (IOException)o;
            }
            this.connection = o;
            this.transaction = new ModbusTCPTransaction((TCPMasterConnection)o);
        } else {
            throw new IOException("malformed DeviceLocator. It has neither device address nor interface");
        }
    }

    private String getPortName(String iface) {
        String portName = null;
        HardwareManager hw = this.driver.getHardwareManager();
        HardwareDescriptor desc = hw.getDescriptor(iface);
        if (desc.getHardwareType() == HardwareDescriptor.HardwareType.USB) {
            portName = ((UsbHardwareDescriptor)desc).getPortName();
        } else if (desc.getHardwareType() == HardwareDescriptor.HardwareType.SERIAL) {
            portName = ((SerialHardwareDescriptor)desc).getPortName();
        }
        return portName;
    }

    DeviceLocator getDeviceLocator() {
        return this.locator;
    }

    private SerialParameters parseParameterString(String parameter) throws IOException {
        SerialParameters newParams = new SerialParameters();
        try {
            String[] splitted = parameter.split(":");
            if (splitted.length < 6) {
                throw new IOException("malformed DeviceLocator. getParameters() has only " + splitted.length + " elements (expected 6)");
            }
            newParams.setBaudRate(Integer.parseInt(splitted[0], 10));
            newParams.setDatabits(Integer.parseInt(splitted[1], 10));
            newParams.setParity(splitted[2]);
            newParams.setStopbits(splitted[3]);
            newParams.setFlowControlIn(splitted[4]);
            newParams.setFlowControlOut(splitted[5]);
            newParams.setEcho(Integer.parseInt(splitted[6], 10) != 0);
        }
        catch (NumberFormatException e) {
            throw new IOException("malformed DeviceLocator. getParameters() has malformed integer values", e);
        }
        return newParams;
    }

    public static String createParameterString(SerialParameters params) {
        String result = params.getBaudRateString();
        result = result + ":" + params.getDatabitsString();
        result = result + ":" + params.getParityString();
        result = result + ":" + params.getStopbitsString();
        result = result + ":" + params.getFlowControlInString();
        result = result + ":" + params.getFlowControlOutString();
        result = result + ":" + (params.isEcho() ? (char)'1' : '0');
        return result;
    }

    List<Channel> getChannels() {
        return this.channels;
    }

    List<ChannelLocator> getChannelLocators() {
        ArrayList<ChannelLocator> result = new ArrayList<ChannelLocator>(this.channels.size());
        for (Channel chan : this.channels) {
            result.add(chan.getChannelLocator());
        }
        return result;
    }

    private Channel findChannel(ChannelLocator channel) {
        for (Channel chan : this.channels) {
            if (!chan.getChannelLocator().equals((Object)channel)) continue;
            return chan;
        }
        return null;
    }

    private void addChannel(Channel chan) {
        this.channels.add(chan);
    }

    synchronized void removeChannel(ChannelLocator locator) {
        Channel channel = this.findChannel(locator);
        if (channel != null) {
            this.channels.remove(channel);
        }
    }

    boolean hasChannels() {
        return !this.channels.isEmpty();
    }

    synchronized ModbusResponse executeTransaction(ModbusRequest request) throws Exception {
        this.transaction.setRequest(request);
        this.transaction.execute();
        return this.transaction.getResponse();
    }

    synchronized void close() {
        if (this.connection instanceof SerialConnection) {
            ((SerialConnection)this.connection).close();
        } else if (this.connection instanceof TCPMasterConnection) {
            ((TCPMasterConnection)this.connection).close();
        }
        this.connection = null;
        this.transaction = null;
    }

    synchronized Channel getChannel(ChannelLocator channelLocator) throws IOException {
        Channel channel = this.findChannel(channelLocator);
        if (channel == null) {
            channel = Channel.createChannel(channelLocator);
            this.addChannel(channel);
        }
        return channel;
    }
}

