/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.modbus;

import com.ghgande.j2mod.modbus.ModbusSlaveException;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ReadMultipleRegistersRequest;
import com.ghgande.j2mod.modbus.msg.ReadMultipleRegistersResponse;
import com.ghgande.j2mod.modbus.msg.WriteMultipleRegistersRequest;
import com.ghgande.j2mod.modbus.msg.WriteSingleRegisterRequest;
import com.ghgande.j2mod.modbus.procimg.Register;
import com.ghgande.j2mod.modbus.procimg.SimpleRegister;
import java.io.IOException;
import org.ogema.core.channelmanager.driverspi.ChannelLocator;
import org.ogema.core.channelmanager.measurements.ObjectValue;
import org.ogema.core.channelmanager.measurements.Quality;
import org.ogema.core.channelmanager.measurements.SampledValue;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.driver.modbus.Channel;
import org.ogema.driver.modbus.Connection;
import org.ogema.driver.modbus.ModbusDriver;

public class HoldingChannel
extends Channel {
    public static final int MAX_READ = 125;
    public static final int MAX_WRITE = 123;
    private final ReadMultipleRegistersRequest readRequest;
    private WriteMultipleRegistersRequest writeMultipleRequest;
    private WriteSingleRegisterRequest writeSingleRequest;
    private int registerCount;

    public HoldingChannel(ChannelLocator locator, String[] splitAddress) {
        super(locator);
        int reg;
        int device;
        try {
            device = Integer.decode(splitAddress[0]);
            reg = Integer.decode(splitAddress[2]);
            this.registerCount = Integer.decode(splitAddress[3]);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new IllegalArgumentException("could not create Channel with Address " + locator.getChannelAddress(), e);
        }
        this.readRequest = new ReadMultipleRegistersRequest();
        this.readRequest.setUnitID(device);
        this.readRequest.setReference(reg);
        this.readRequest.setWordCount(this.registerCount);
        if (this.registerCount > 1) {
            this.writeMultipleRequest = new WriteMultipleRegistersRequest();
            this.writeMultipleRequest.setUnitID(device);
            this.writeMultipleRequest.setReference(reg);
            Register[] registers = new Register[this.registerCount];
            for (int i = 0; i < registers.length; ++i) {
                registers[i] = new SimpleRegister(0);
            }
            this.writeMultipleRequest.setRegisters(registers);
        } else if (this.registerCount == 1) {
            this.writeSingleRequest = new WriteSingleRegisterRequest();
            this.writeSingleRequest.setUnitID(device);
            this.writeSingleRequest.setReference(reg);
            SimpleRegister register = new SimpleRegister(0);
            this.writeSingleRequest.setRegister((Register)register);
        } else {
            throw new IllegalArgumentException("could not create Channel with this address due to negative register count: " + locator.getChannelAddress());
        }
    }

    @Override
    public SampledValue readValue(Connection connection) throws IOException {
        ObjectValue value = null;
        Quality quality = Quality.BAD;
        try {
            ReadMultipleRegistersResponse response = (ReadMultipleRegistersResponse)connection.executeTransaction((ModbusRequest)this.readRequest);
            int[] array = new int[response.getWordCount()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = response.getRegisterValue(i);
                ModbusDriver.logger.trace("Register_Value: " + array[i]);
            }
            value = new ObjectValue((Object)array);
            quality = Quality.GOOD;
        }
        catch (ModbusSlaveException mse) {
            System.out.println("Slave Exception: " + mse.getType());
            mse.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new SampledValue(value, System.currentTimeMillis(), quality);
    }

    @Override
    public void writeValue(Connection connection, Value value) throws IOException {
        Object ov = value.getObjectValue();
        try {
            if (this.registerCount == 1) {
                int singleInt = (Integer)ov;
                Register register = this.writeSingleRequest.getRegister();
                register.setValue(singleInt);
                connection.executeTransaction((ModbusRequest)this.writeSingleRequest);
            } else {
                int[] array = (int[])value.getObjectValue();
                Register[] registers = this.writeMultipleRequest.getRegisters();
                for (int i = 0; i < array.length; ++i) {
                    registers[i].setValue(array[i]);
                }
                connection.executeTransaction((ModbusRequest)this.writeMultipleRequest);
            }
        }
        catch (ModbusSlaveException mse) {
            throw new IOException("Slave Exception: " + mse.getType(), mse);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

