/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.modbus;

import com.ghgande.j2mod.modbus.ModbusSlaveException;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ReadCoilsRequest;
import com.ghgande.j2mod.modbus.msg.ReadCoilsResponse;
import com.ghgande.j2mod.modbus.msg.WriteMultipleCoilsRequest;
import com.ghgande.j2mod.modbus.util.BitVector;
import java.io.IOException;
import org.ogema.core.channelmanager.driverspi.ChannelLocator;
import org.ogema.core.channelmanager.measurements.ObjectValue;
import org.ogema.core.channelmanager.measurements.Quality;
import org.ogema.core.channelmanager.measurements.SampledValue;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.driver.modbus.Channel;
import org.ogema.driver.modbus.Connection;

public class CoilChannel
extends Channel {
    public static final int MAX_READ = 2000;
    public static final int MAX_WRITE = 1968;
    private final ReadCoilsRequest readRequest;
    private final WriteMultipleCoilsRequest writeRequest;

    public CoilChannel(ChannelLocator locator, String[] splitAddress) {
        super(locator);
        int count;
        int reg;
        int device;
        try {
            device = Integer.decode(splitAddress[0]);
            if (device < 0 || device > 254) {
                throw new IllegalArgumentException();
            }
            reg = Integer.decode(splitAddress[2]);
            if (reg < 0 || reg > 65535) {
                throw new IllegalArgumentException();
            }
            count = Integer.decode(splitAddress[3]);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new IllegalArgumentException("could not create Channel with Address " + locator.getChannelAddress(), e);
        }
        this.readRequest = new ReadCoilsRequest();
        this.readRequest.setUnitID(device);
        this.readRequest.setReference(reg);
        this.readRequest.setBitCount(count);
        this.writeRequest = new WriteMultipleCoilsRequest();
        this.writeRequest.setUnitID(device);
        this.writeRequest.setReference(reg);
        this.writeRequest.setCoils(new BitVector(count));
    }

    @Override
    public SampledValue readValue(Connection connection) throws IOException {
        ObjectValue value = null;
        Quality quality = Quality.BAD;
        try {
            ReadCoilsResponse response = (ReadCoilsResponse)connection.executeTransaction((ModbusRequest)this.readRequest);
            int[] array = new int[response.getBitCount()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = response.getCoilStatus(i) ? 1 : 0;
            }
            value = new ObjectValue((Object)array);
            quality = Quality.GOOD;
        }
        catch (ModbusSlaveException mse) {
            System.out.println("Slave Exception: " + mse.getType());
            mse.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new SampledValue(value, System.currentTimeMillis(), quality);
    }

    @Override
    public void writeValue(Connection connection, Value value) throws IOException {
        try {
            int[] array = (int[])value.getObjectValue();
            for (int i = 0; i < array.length; ++i) {
                this.writeRequest.setCoilStatus(i, array[i] != 0);
            }
            connection.executeTransaction((ModbusRequest)this.writeRequest);
        }
        catch (ModbusSlaveException mse) {
            throw new IOException("Slave Exception: " + mse.getType(), mse);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

