/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.modbus;

import com.ghgande.j2mod.modbus.ModbusSlaveException;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ReadInputRegistersRequest;
import com.ghgande.j2mod.modbus.msg.ReadInputRegistersResponse;
import java.io.IOException;
import org.ogema.core.channelmanager.driverspi.ChannelLocator;
import org.ogema.core.channelmanager.measurements.ObjectValue;
import org.ogema.core.channelmanager.measurements.Quality;
import org.ogema.core.channelmanager.measurements.SampledValue;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.driver.modbus.Channel;
import org.ogema.driver.modbus.Connection;

public class InputChannel
extends Channel {
    public static final int MAX_READ = 125;
    private final ReadInputRegistersRequest readRequest;

    public InputChannel(ChannelLocator locator, String[] splitAddress) {
        super(locator);
        int count;
        int reg;
        int device;
        try {
            device = Integer.decode(splitAddress[0]);
            reg = Integer.decode(splitAddress[2]);
            count = Integer.decode(splitAddress[3]);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new IllegalArgumentException("could not create Channel with Address " + locator.getChannelAddress(), e);
        }
        this.readRequest = new ReadInputRegistersRequest();
        this.readRequest.setUnitID(device);
        this.readRequest.setReference(reg);
        this.readRequest.setWordCount(count);
    }

    @Override
    public SampledValue readValue(Connection connection) throws IOException {
        ObjectValue value = null;
        Quality quality = Quality.BAD;
        try {
            ReadInputRegistersResponse response = (ReadInputRegistersResponse)connection.executeTransaction((ModbusRequest)this.readRequest);
            int[] array = new int[response.getWordCount()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = response.getRegisterValue(i);
            }
            value = new ObjectValue((Object)array);
            quality = Quality.GOOD;
        }
        catch (ModbusSlaveException mse) {
            System.out.println("Slave Exception: " + mse.getType());
            mse.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new SampledValue(value, System.currentTimeMillis(), quality);
    }

    @Override
    public void writeValue(Connection connection, Value value) throws IOException {
        throw new IOException("MODBUS holding input registers are read-only.");
    }
}

