/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.modbus;

import java.io.IOException;
import org.ogema.core.channelmanager.driverspi.ChannelLocator;
import org.ogema.core.channelmanager.measurements.SampledValue;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.driver.modbus.CoilChannel;
import org.ogema.driver.modbus.Connection;
import org.ogema.driver.modbus.DiscreteChannel;
import org.ogema.driver.modbus.HoldingChannel;
import org.ogema.driver.modbus.InputChannel;

public abstract class Channel {
    public static final String TYPE_INPUT = "INPUT_REGISTERS";
    public static final String TYPE_HOLDING = "HOLDING_REGISTERS";
    public static final String TYPE_DISCRETE = "DISCRETE_INPUTS";
    public static final String TYPE_COIL = "COILS";
    protected ChannelLocator locator;

    public static Channel createChannel(ChannelLocator locator) throws IllegalArgumentException {
        String[] splitAddress = locator.getChannelAddress().split(":");
        switch (splitAddress[1]) {
            case "INPUT_REGISTERS": {
                return new InputChannel(locator, splitAddress);
            }
            case "HOLDING_REGISTERS": {
                return new HoldingChannel(locator, splitAddress);
            }
            case "DISCRETE_INPUTS": {
                return new DiscreteChannel(locator, splitAddress);
            }
            case "COILS": {
                return new CoilChannel(locator, splitAddress);
            }
        }
        throw new IllegalArgumentException("could not create Channel with Address " + locator.getChannelAddress());
    }

    protected Channel(ChannelLocator locator) {
        this.locator = locator;
    }

    public ChannelLocator getChannelLocator() {
        return this.locator;
    }

    public abstract SampledValue readValue(Connection var1) throws IOException;

    public abstract void writeValue(Connection var1, Value var2) throws IOException;
}

