/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.modbus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.ogema.core.channelmanager.driverspi.ChannelDriver;
import org.ogema.core.channelmanager.driverspi.ChannelLocator;
import org.ogema.core.channelmanager.driverspi.ChannelScanListener;
import org.ogema.core.channelmanager.driverspi.ChannelUpdateListener;
import org.ogema.core.channelmanager.driverspi.DeviceListener;
import org.ogema.core.channelmanager.driverspi.DeviceLocator;
import org.ogema.core.channelmanager.driverspi.DeviceScanListener;
import org.ogema.core.channelmanager.driverspi.NoSuchChannelException;
import org.ogema.core.channelmanager.driverspi.NoSuchDeviceException;
import org.ogema.core.channelmanager.driverspi.NoSuchInterfaceException;
import org.ogema.core.channelmanager.driverspi.SampledValueContainer;
import org.ogema.core.channelmanager.driverspi.ValueContainer;
import org.ogema.core.channelmanager.measurements.Quality;
import org.ogema.core.channelmanager.measurements.SampledValue;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.core.hardwaremanager.HardwareDescriptor;
import org.ogema.core.hardwaremanager.HardwareListener;
import org.ogema.core.hardwaremanager.HardwareManager;
import org.ogema.core.hardwaremanager.UsbHardwareDescriptor;
import org.ogema.driver.modbus.Channel;
import org.ogema.driver.modbus.Connection;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={ChannelDriver.class})
public class ModbusDriver
implements ChannelDriver,
HardwareListener {
    private static final String DRIVER_ID = "modbus-combined";
    private static final String DESCRIPTION = "MODBUS/RTU or MODBUS/TCP";
    static final Logger logger = LoggerFactory.getLogger(ModbusDriver.class);
    private final List<Connection> connectionList;
    private Set<DeviceListener> deviceListeners = new HashSet<DeviceListener>();
    @Reference
    private HardwareManager hardwareManager;

    public ModbusDriver() {
        this.connectionList = new ArrayList<Connection>();
    }

    @Activate
    protected void activate(BundleContext ctx) {
        this.hardwareManager.addListener((HardwareListener)this);
    }

    @Deactivate
    protected void deactivate(BundleContext ctx) {
        this.hardwareManager.removeListener((HardwareListener)this);
    }

    public String getDriverId() {
        return DRIVER_ID;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public void startDeviceScan(String interfaceId, String filter, DeviceScanListener listener) throws UnsupportedOperationException, NoSuchInterfaceException, IOException {
        throw new UnsupportedOperationException();
    }

    public void abortDeviceScan(String interfaceId, String filter) {
    }

    public void startChannelScan(DeviceLocator device, ChannelScanListener listener) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public List<ChannelLocator> getChannelList(DeviceLocator device) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void readChannels(List<SampledValueContainer> channels) throws UnsupportedOperationException, IOException {
        if (channels == null) {
            return;
        }
        for (SampledValueContainer container : channels) {
            this.readChannel(container);
        }
    }

    void readChannel(SampledValueContainer svc) throws IOException {
        SampledValue result;
        if (svc == null) {
            return;
        }
        ChannelLocator channelLocator = svc.getChannelLocator();
        if (channelLocator == null) {
            throw new IOException("malformed SampledValueContainer. getChannelLocator() == null");
        }
        DeviceLocator deviceLocator = channelLocator.getDeviceLocator();
        if (deviceLocator == null) {
            throw new IOException("malformed channelLocator. getDeviceLocator() == null");
        }
        try {
            Connection con = this.getConnection(deviceLocator);
            Channel channel = con.getChannel(channelLocator);
            result = channel.readValue(con);
        }
        catch (IOException e) {
            logger.error(String.format("could not read channel {} because of io errors", channelLocator), (Throwable)e);
            result = new SampledValue(null, System.currentTimeMillis(), Quality.BAD);
        }
        catch (NullPointerException e) {
            result = new SampledValue(null, System.currentTimeMillis(), Quality.BAD);
        }
        svc.setSampledValue(result);
    }

    private synchronized Connection getConnection(DeviceLocator deviceLocator) throws IOException {
        Connection connection = this.findConnection(deviceLocator);
        if (connection == null) {
            connection = new Connection(this, deviceLocator);
            this.addConnection(connection);
        }
        return connection;
    }

    public void listenChannels(List<SampledValueContainer> channels, ChannelUpdateListener listener) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void writeChannels(List<ValueContainer> channels) throws UnsupportedOperationException, IOException, NoSuchDeviceException, NoSuchChannelException {
        for (ValueContainer container : channels) {
            this.writeChannel(container.getChannelLocator(), container.getValue());
        }
    }

    public void shutdown() {
        for (Connection con : this.connectionList) {
            this.removeConnection(con);
            con.close();
        }
    }

    public void channelAdded(ChannelLocator channel) {
    }

    public synchronized void channelRemoved(ChannelLocator channel) {
        DeviceLocator device = channel.getDeviceLocator();
        Connection con = this.findConnection(device);
        if (con != null) {
            con.removeChannel(channel);
            if (!con.hasChannels()) {
                this.removeConnection(con);
                con.close();
            }
        }
    }

    private void removeConnection(Connection con) {
        this.connectionList.remove(con);
    }

    private void addConnection(Connection con) {
        this.connectionList.add(con);
    }

    private Connection findConnection(DeviceLocator locator) {
        for (Connection con : this.connectionList) {
            if (!con.getDeviceLocator().equals((Object)locator)) continue;
            return con;
        }
        return null;
    }

    public void hardwareAdded(HardwareDescriptor descriptor) {
    }

    public synchronized void hardwareRemoved(HardwareDescriptor descriptor) {
        if (descriptor.getHardwareType() == HardwareDescriptor.HardwareType.USB) {
            String name2 = ((UsbHardwareDescriptor)descriptor).getPortName();
            for (Connection con : this.connectionList) {
                String name1 = con.getDeviceLocator().getInterfaceName();
                if (!name1.equals(name2)) continue;
                this.connectionList.remove(con);
                con.close();
                this.callDeviceListeners(con.getDeviceLocator());
                break;
            }
        }
    }

    HardwareManager getHardwareManager() {
        return this.hardwareManager;
    }

    public void addDeviceListener(DeviceListener listener) {
        this.deviceListeners.add(listener);
    }

    public void removeDeviceListener(DeviceListener listener) {
        this.deviceListeners.remove(listener);
    }

    private void callDeviceListeners(DeviceLocator device) {
        for (DeviceListener listener : this.deviceListeners) {
            try {
                listener.deviceRemoved(device);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void writeChannel(ChannelLocator channelLocator, Value value) throws UnsupportedOperationException, IOException, NoSuchDeviceException, NoSuchChannelException {
        try {
            Connection con = this.getConnection(channelLocator.getDeviceLocator());
            Channel channel = con.getChannel(channelLocator);
            channel.writeValue(con, value);
        }
        catch (NullPointerException e) {
            throw new IOException("Unknown channel: " + channelLocator, e);
        }
    }

    protected void bindHardwareManager(HardwareManager hardwareManager) {
        this.hardwareManager = hardwareManager;
    }

    protected void unbindHardwareManager(HardwareManager hardwareManager) {
        if (this.hardwareManager == hardwareManager) {
            this.hardwareManager = null;
        }
    }
}

