/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.messages.sms;

import de.iwes.widgets.api.OgemaGuiService;
import de.iwes.widgets.api.messaging.listener.MessageListener;
import de.iwes.widgets.api.messaging.listener.ReceivedMessage;
import de.iwes.widgets.api.widgets.localisation.OgemaLocale;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.logging.OgemaLogger;
import org.ogema.core.resourcemanager.AccessPriority;
import org.ogema.core.resourcemanager.pattern.ResourcePatternAccess;
import org.ogema.messages.sms.SmsReceiverPattern;
import org.ogema.messages.sms.SmsSenderPattern;

@Component(specVersion="1.2")
@Service(value={Application.class, MessageListener.class})
public class SMSService
implements Application,
MessageListener {
    private volatile ResourcePatternAccess patternAccess;
    private volatile OgemaLogger logger;
    @Reference
    private OgemaGuiService guiService;

    public void start(ApplicationManager am) {
        this.patternAccess = am.getResourcePatternAccess();
        this.logger = am.getLogger();
    }

    private boolean sendSMSviaMail(ReceivedMessage ms, SmsSenderPattern sender, List<String> recipients, Properties properties, String encoding) throws RuntimeException {
        boolean allMessagesSent = true;
        final String email = sender.email.getValue();
        final String pw = sender.password.getValue();
        Session session = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(email, pw);
            }
        });
        List receivers = this.patternAccess.getPatterns(SmsReceiverPattern.class, AccessPriority.PRIO_LOWEST);
        if (receivers.isEmpty()) {
            this.logger.warn("No sms-receivers activated");
            return false;
        }
        for (String receiver : recipients) {
            try {
                SmsReceiverPattern rec = SMSService.getReceiver(receiver, receivers);
                if (rec == null) {
                    this.logger.warn("User '" + receiver + "' not found");
                    continue;
                }
                this.logger.debug("Current sms-receiver is '" + rec.userName + "' with sms(email) '" + rec.email.getValue() + "'");
                MimeMessage message = new MimeMessage(session);
                message.setFrom((Address)new InternetAddress(email));
                message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(rec.email.getValue()));
                message.setSubject(ms.getOriginalMessage().title(null));
                String body = "Notification : " + ms.getOriginalMessage().message(null) + "\nSender : " + ms.getAppName() + "\nTime : " + new Date(ms.getTimestamp()).toString();
                message.setText(body);
                message.setSentDate(new Date());
                AccessController.doPrivileged(new PrivilegedAction<Void>((Message)message, email, pw, ms, rec, encoding){
                    final /* synthetic */ Message val$message;
                    final /* synthetic */ String val$email;
                    final /* synthetic */ String val$pw;
                    final /* synthetic */ ReceivedMessage val$ms;
                    final /* synthetic */ SmsReceiverPattern val$rec;
                    final /* synthetic */ String val$encoding;
                    {
                        this.val$message = message;
                        this.val$email = string;
                        this.val$pw = string2;
                        this.val$ms = receivedMessage;
                        this.val$rec = smsReceiverPattern;
                        this.val$encoding = string3;
                    }

                    @Override
                    public Void run() {
                        try {
                            Transport.send((Message)this.val$message, (String)this.val$email, (String)this.val$pw);
                        }
                        catch (MessagingException e) {
                            throw new RuntimeException(e);
                        }
                        SMSService.this.logger.error("Sms(email) sent from {} to {} via {}", new Object[]{this.val$ms.getAppName(), this.val$rec.email.getValue(), this.val$encoding});
                        return null;
                    }
                });
            }
            catch (Exception e) {
                this.logger.error("MessagingExpection caught while sending a new email from user " + sender.email.getValue() + " to user " + receiver, (Throwable)e);
                allMessagesSent = false;
            }
        }
        return allMessagesSent;
    }

    private static final SmsReceiverPattern getReceiver(String userName, List<SmsReceiverPattern> receivers) {
        for (SmsReceiverPattern pat : receivers) {
            if (!pat.userName.getValue().equals(userName)) continue;
            return pat;
        }
        return null;
    }

    public List<String> getKnownUsers() {
        if (this.patternAccess == null) {
            return Collections.emptyList();
        }
        List receivers = this.patternAccess.getPatterns(SmsReceiverPattern.class, AccessPriority.PRIO_LOWEST);
        ArrayList<String> users = new ArrayList<String>();
        for (SmsReceiverPattern pattern : receivers) {
            users.add(pattern.userName.getValue());
        }
        return users;
    }

    public void newMessageAvailable(ReceivedMessage message, List<String> recipients) {
        if (this.patternAccess == null) {
            return;
        }
        List senders = this.patternAccess.getPatterns(SmsSenderPattern.class, AccessPriority.PRIO_LOWEST);
        if (senders.isEmpty()) {
            this.logger.error("No sender configured, could not send sms(email)");
            return;
        }
        SmsSenderPattern sender = (SmsSenderPattern)((Object)senders.get(0));
        for (SmsSenderPattern pat : senders) {
            if (!pat.active.getValue()) continue;
            sender = pat;
            break;
        }
        String url = sender.serverURL.getValue();
        int port = sender.port.getValue();
        Properties properties = new Properties();
        properties.put("mail.smtp.starttls.enable", "true");
        properties.put("mail.smtp.starttls.required", "true");
        properties.put("mail.smtp.host", url);
        properties.put("mail.smtp.auth", "true");
        properties.put("mail.smtp.port", (Object)port);
        properties.put("mail.smtp.debug", "true");
        boolean allMessagesSent = this.sendSMSviaMail(message, sender, recipients, properties, "STARTTLS");
        if (!allMessagesSent) {
            this.logger.error("Sending message via STARTTLS failed, trying to send it via SSL now, using the same host and port");
            properties = new Properties();
            properties.put("mail.smtp.ssl.enable", "true");
            properties.put("mail.smtp.host", url);
            properties.put("mail.smtp.auth", "true");
            properties.put("mail.smtp.port", (Object)port);
            properties.put("mail.smtp.debug", "true");
            this.sendSMSviaMail(message, sender, recipients, properties, "SSL");
        }
    }

    public void stop(Application.AppStopReason arg0) {
        this.patternAccess = null;
        this.logger = null;
    }

    public String getId() {
        return "Sms-connector";
    }

    public String getDescription(OgemaLocale locale) {
        return "Sms-connector";
    }

    protected void bindGuiService(OgemaGuiService ogemaGuiService) {
        this.guiService = ogemaGuiService;
    }

    protected void unbindGuiService(OgemaGuiService ogemaGuiService) {
        if (this.guiService == ogemaGuiService) {
            this.guiService = null;
        }
    }
}

