/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.messaging.configuration;

import de.iwes.widgets.api.OgemaGuiService;
import de.iwes.widgets.api.extended.WidgetData;
import de.iwes.widgets.api.messaging.listener.MessageListener;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetApp;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.accordion.Accordion;
import de.iwes.widgets.html.accordion.AccordionData;
import de.iwes.widgets.html.accordion.AccordionItem;
import de.iwes.widgets.html.alert.Alert;
import de.iwes.widgets.html.alert.AlertData;
import de.iwes.widgets.html.form.label.Header;
import de.iwes.widgets.messaging.MessageReader;
import de.iwes.widgets.messaging.MessagingApp;
import de.iwes.widgets.messaging.model.MessagingService;
import de.iwes.widgets.messaging.model.UserConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.application.Timer;
import org.ogema.core.application.TimerListener;
import org.ogema.core.logging.OgemaLogger;
import org.ogema.core.model.ResourceList;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.StringResource;
import org.ogema.messaging.configuration.AllMessagingApps;
import org.ogema.messaging.configuration.Util;
import org.ogema.messaging.configuration.localisation.SelectConnectorDictionary;
import org.ogema.messaging.configuration.localisation.SelectConnectorDictionary_de;
import org.ogema.messaging.configuration.localisation.SelectConnectorDictionary_en;
import org.ogema.messaging.configuration.templates.AppSnippet;
import org.ogema.tools.resource.util.ResourceUtils;
import org.slf4j.LoggerFactory;

@Component(specVersion="1.2")
@Service(value={Application.class})
public class SelectConnector
implements Application {
    private static final long GARBAGE_COLLECTOR_UPDATE_INTERVAL = 1800000L;
    private OgemaLogger logger;
    private WidgetApp wApp;
    private WidgetPage<SelectConnectorDictionary> page;
    private static final AllMessagingApps allApps = new AllMessagingApps();
    private final Set<String> users = new HashSet<String>();
    private final Map<String, MessageListener> listeners = new HashMap<String, MessageListener>();
    private ResourceList<de.iwes.widgets.messaging.model.MessagingApp> appList;
    @Reference
    private OgemaGuiService guiService;
    @Reference
    private MessageReader messageReader;
    private final TimerListener garbageCollector = new TimerListener(){

        public void timerElapsed(Timer timer) {
            SelectConnector.this.logger.debug("Running select connector garbage collector, to identify stale user forwarding configurations");
            Map listeners = SelectConnector.this.messageReader.getMessageListeners();
            List apps = SelectConnector.this.appList.getAllElements();
            for (de.iwes.widgets.messaging.model.MessagingApp app : apps) {
                if (!app.services().isActive()) continue;
                for (MessagingService ml : app.services().getAllElements()) {
                    MessageListener actualListener = (MessageListener)listeners.get(ml.serviceId().getValue());
                    if (actualListener == null) {
                        ml.deactivate(true);
                        continue;
                    }
                    if (!ml.users().isActive()) continue;
                    try {
                        List users = actualListener.getKnownUsers();
                        for (UserConfig uc : ml.users().getAllElements()) {
                            try {
                                if (users.contains(uc.userName().getValue())) continue;
                                SelectConnector.this.logger.info("Found forwarding configuration for inexistent user " + uc.userName().getValue());
                                uc.delete();
                            }
                            catch (Exception e) {
                                SelectConnector.this.logger.info("Could not determine whether user config is real, removing it: " + uc, (Throwable)e);
                                uc.delete();
                            }
                        }
                    }
                    catch (Throwable e) {
                        LoggerFactory.getLogger(this.getClass()).error("", e);
                    }
                }
            }
        }
    };

    public void stop(Application.AppStopReason reason) {
        if (this.wApp != null) {
            this.wApp.close();
        }
        this.wApp = null;
        this.page = null;
        this.logger = null;
        this.appList = null;
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.users.clear();
        this.listeners.clear();
    }

    public void start(ApplicationManager appManager) {
        this.logger = appManager.getLogger();
        this.logger.debug("{} started", (Object)this.getClass().getName());
        this.wApp = this.guiService.createWidgetApp("/de/iwes/ogema/apps/select-connector", appManager);
        this.page = this.wApp.createStartPage();
        this.page.registerLocalisation(SelectConnectorDictionary_de.class).registerLocalisation(SelectConnectorDictionary_en.class);
        this.appList = (ResourceList)appManager.getResourceManagement().createResource("messagingApps", ResourceList.class);
        this.appList.setElementType(de.iwes.widgets.messaging.model.MessagingApp.class);
        Header header = new Header(this.page, "header", "Message forwarding configurations"){

            public void onGET(OgemaHttpRequest req) {
                this.setText(((SelectConnectorDictionary)SelectConnector.this.page.getDictionary(req)).header(), req);
            }
        };
        header.addDefaultStyle(WidgetData.TEXT_ALIGNMENT_CENTERED);
        this.page.append((OgemaWidget)header).linebreak();
        Alert info = new Alert(this.page, "description", "Explanation"){

            public void onGET(OgemaHttpRequest req) {
                this.setHtml(((SelectConnectorDictionary)SelectConnector.this.page.getDictionary(req)).description(), req);
                this.allowDismiss(true, req);
                this.autoDismiss(-1L, req);
            }
        };
        this.page.append((OgemaWidget)info).linebreak();
        info.addDefaultStyle(AlertData.BOOTSTRAP_INFO);
        info.setDefaultVisibility(true);
        Accordion appAccordion = new Accordion(this.page, "appAccordion", true){
            private static final long serialVersionUID = 1L;
            private AtomicLong lastUpdate;
            private AtomicBoolean running;
            {
                this.lastUpdate = new AtomicLong(0L);
                this.running = new AtomicBoolean(false);
            }

            public void onGET(OgemaHttpRequest req) {
                if (System.currentTimeMillis() - this.lastUpdate.get() < 5000L) {
                    return;
                }
                if (this.running.getAndSet(true)) {
                    return;
                }
                this.writeLock(req);
                try {
                    SelectConnector.this.refreshMessagingApps(this, req);
                }
                finally {
                    this.lastUpdate.set(System.currentTimeMillis());
                    this.running.set(false);
                    this.writeUnlock(req);
                }
            }
        };
        appAccordion.addDefaultStyle(AccordionData.BOOTSTRAP_GREEN);
        this.page.append((OgemaWidget)appAccordion);
        appManager.createTimer(1800000L, this.garbageCollector);
    }

    private static final boolean contains(List<MessagingApp> list, de.iwes.widgets.messaging.model.MessagingApp app) {
        for (MessagingApp entry : list) {
            if (!entry.getMessagingId().equals(app.appId().getValue())) continue;
            return true;
        }
        return false;
    }

    public void refreshMessagingApps(Accordion appAccordion, OgemaHttpRequest req) {
        String appId;
        HashMap<String, MessageListener> newListeners = new HashMap<String, MessageListener>();
        HashSet<String> listenersToBeRemoved = new HashSet<String>();
        HashSet<String> newUsers = new HashSet<String>();
        HashSet<String> usersToBeRemoved = new HashSet<String>();
        Map localListeners = this.messageReader.getMessageListeners();
        HashSet<String> localUsers = new HashSet<String>();
        Iterator<Map.Entry<String, MessageListener>> it = this.listeners.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, MessageListener> entry = it.next();
            String string = (String)entry.getKey();
            if (localListeners.containsKey(string) && (!localListeners.containsKey(entry.getKey()) || ((MessageListener)localListeners.get(entry.getKey())).equals(entry.getValue()))) continue;
            listenersToBeRemoved.add(string);
            it.remove();
        }
        for (Map.Entry entry : localListeners.entrySet()) {
            if (!this.listeners.containsKey(entry.getKey()) || this.listeners.containsKey(entry.getKey()) && !this.listeners.get(entry.getKey()).equals(entry.getValue())) {
                newListeners.put((String)entry.getKey(), (MessageListener)entry.getValue());
                this.listeners.put((String)entry.getKey(), (MessageListener)entry.getValue());
            }
            try {
                for (String user : ((MessageListener)entry.getValue()).getKnownUsers()) {
                    localUsers.add(user);
                    if (this.users.contains(user)) continue;
                    this.users.add(user);
                    newUsers.add(user);
                }
            }
            catch (Throwable e) {
                LoggerFactory.getLogger(Util.class).error("", e);
            }
        }
        Iterator<String> userIt = this.users.iterator();
        while (userIt.hasNext()) {
            String string = userIt.next();
            if (localUsers.contains(string)) continue;
            userIt.remove();
            usersToBeRemoved.add(string);
        }
        boolean bl = !newUsers.isEmpty() || !newListeners.isEmpty() || !listenersToBeRemoved.isEmpty() || !usersToBeRemoved.isEmpty();
        List appIds = this.messageReader.getMessageSenders();
        appIds.add(allApps);
        List apps = this.appList.getAllElements();
        for (int i = 0; i < apps.size(); ++i) {
            de.iwes.widgets.messaging.model.MessagingApp app = (de.iwes.widgets.messaging.model.MessagingApp)apps.get(i);
            appId = app.appId().getValue();
            if (SelectConnector.contains(appIds, app)) continue;
            app.delete();
            try {
                appAccordion.removeItem(appId, req);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (de.iwes.widgets.messaging.model.MessagingApp app : appIds) {
            AccordionItem item;
            boolean isNew;
            appId = app.getMessagingId();
            String resourceName = ResourceUtils.getValidResourceName((String)appId);
            de.iwes.widgets.messaging.model.MessagingApp messagingApp = (de.iwes.widgets.messaging.model.MessagingApp)((de.iwes.widgets.messaging.model.MessagingApp)this.appList.getSubResource(resourceName, de.iwes.widgets.messaging.model.MessagingApp.class)).create();
            StringResource id = (StringResource)messagingApp.appId().create();
            id.setValue(appId);
            if (!messagingApp.active().isActive()) {
                ((BooleanResource)messagingApp.active().create()).setValue(true);
            }
            boolean bl2 = isNew = (item = appAccordion.getItem(resourceName, req)) == null;
            if (isNew) {
                AppSnippet appSnippet = new AppSnippet(this.page, true, messagingApp, this.messageReader, (MessagingApp)app);
                appAccordion.addItem(resourceName, (OgemaWidget)appSnippet, req);
                item = appAccordion.getItem(resourceName, req);
            }
            boolean tableRefreshed = false;
            AppSnippet snippet = (AppSnippet)item.getWidget();
            if (isNew || bl) {
                tableRefreshed = snippet.update(newUsers, usersToBeRemoved, newListeners, listenersToBeRemoved);
            }
            if (tableRefreshed) continue;
            HashMap<String, MessageListener> unchangedListeners = new HashMap<String, MessageListener>(this.listeners);
            for (String newListener : newListeners.keySet()) {
                unchangedListeners.remove(newListener);
            }
            HashSet<String> unchangedUsers = new HashSet<String>(this.users);
            unchangedUsers.removeAll(newUsers);
            snippet.updateDropdowns(unchangedListeners, unchangedUsers);
        }
    }

    protected void bindGuiService(OgemaGuiService ogemaGuiService) {
        this.guiService = ogemaGuiService;
    }

    protected void unbindGuiService(OgemaGuiService ogemaGuiService) {
        if (this.guiService == ogemaGuiService) {
            this.guiService = null;
        }
    }

    protected void bindMessageReader(MessageReader messageReader) {
        this.messageReader = messageReader;
    }

    protected void unbindMessageReader(MessageReader messageReader) {
        if (this.messageReader == messageReader) {
            this.messageReader = null;
        }
    }
}

