/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.messaging.configuration;

import de.iwes.widgets.api.messaging.listener.MessageListener;
import de.iwes.widgets.messaging.model.MessagingApp;
import de.iwes.widgets.messaging.model.MessagingService;
import de.iwes.widgets.messaging.model.UserConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.simple.StringResource;
import org.ogema.messaging.configuration.MessagePriority;
import org.ogema.tools.resource.util.ResourceUtils;
import org.slf4j.LoggerFactory;

public class Util {
    public static Map<String, List<String>> getServicesByUsers(Collection<MessageListener> listeners) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (MessageListener listener : listeners) {
            try {
                List users = listener.getKnownUsers();
                String id = listener.getId();
                for (String user : users) {
                    ArrayList<String> servicesPerUser = (ArrayList<String>)map.get(user);
                    if (servicesPerUser == null) {
                        servicesPerUser = new ArrayList<String>();
                        map.put(user, servicesPerUser);
                    }
                    servicesPerUser.add(id);
                }
            }
            catch (Throwable e) {
                LoggerFactory.getLogger(Util.class).error("", e);
            }
        }
        return map;
    }

    public static final UserConfig getUserConfig(String userName, String serviceId, MessagingApp app) {
        try {
            String validServiceId = ResourceUtils.getValidResourceName((String)serviceId);
            MessagingService serviceRes = (MessagingService)app.services().getSubResource(validServiceId, MessagingService.class);
            if (!serviceRes.isActive()) {
                return null;
            }
            for (UserConfig uc : serviceRes.users().getAllElements()) {
                StringResource name = uc.userName();
                if (!name.isActive() || !name.getValue().equals(userName)) continue;
                return uc;
            }
            return null;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(Util.class).warn("Exception trying to extract user config " + userName + ", service " + serviceId);
            return null;
        }
    }

    public static final UserConfig createUserConfig(String userName, String serviceId, MessagingApp app) {
        String validServiceId = ResourceUtils.getValidResourceName((String)serviceId);
        MessagingService serviceRes = (MessagingService)app.services().getSubResource(validServiceId, MessagingService.class);
        if (!serviceRes.isActive()) {
            return null;
        }
        if (serviceRes.users().getElementType() == null) {
            serviceRes.users().create();
            serviceRes.users().setElementType(UserConfig.class);
            serviceRes.users().activate(false);
        }
        UserConfig uc = (UserConfig)serviceRes.users().add();
        ((StringResource)uc.userName().create()).setValue(userName);
        uc.priority().create();
        return uc;
    }

    public static final void refreshUsersFromService(List<String> knownUsers, MessagingService serviceRes) {
        for (String userName : knownUsers) {
            boolean userFound = false;
            for (UserConfig uc : serviceRes.users().getAllElements()) {
                String configUserName = uc.userName().getValue();
                if (!configUserName.equals(userName)) continue;
                userFound = true;
                break;
            }
            if (userFound) continue;
            UserConfig uc = (UserConfig)serviceRes.users().add();
            StringResource userN = (StringResource)uc.userName().create();
            userN.setValue(userName);
            IntegerResource prio = (IntegerResource)uc.priority().create();
            prio.setValue(MessagePriority.NONE.getPriority());
            uc.activate(true);
        }
        for (UserConfig uc : serviceRes.users().getAllElements()) {
            String configUserName = uc.userName().getValue();
            if (knownUsers.contains(configUserName)) continue;
            uc.delete();
        }
    }
}

