/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.messaging.configuration.templates;

import de.iwes.widgets.api.extended.html.bricks.PageSnippet;
import de.iwes.widgets.api.messaging.listener.MessageListener;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.WidgetStyle;
import de.iwes.widgets.html.complextable.DynamicTable;
import de.iwes.widgets.html.complextable.DynamicTableData;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.html.form.dropdown.Dropdown;
import de.iwes.widgets.html.form.label.Label;
import de.iwes.widgets.messaging.MessageReader;
import de.iwes.widgets.messaging.MessagingApp;
import de.iwes.widgets.messaging.model.MessagingService;
import de.iwes.widgets.messaging.model.UserConfig;
import de.iwes.widgets.resource.widget.textfield.BooleanResourceCheckbox;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.ogema.core.model.ResourceList;
import org.ogema.core.model.simple.StringResource;
import org.ogema.messaging.configuration.AllMessagingApps;
import org.ogema.messaging.configuration.SelectConnector;
import org.ogema.messaging.configuration.templates.PriorityDropdown;
import org.ogema.messaging.configuration.templates.UserTemplate;
import org.ogema.tools.resource.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppSnippet
extends PageSnippet {
    private static final long serialVersionUID = 1L;
    private final WidgetPage<?> page;
    private static final Logger logger = LoggerFactory.getLogger(SelectConnector.class);
    private final DynamicTable<String> userTable;
    private final de.iwes.widgets.messaging.model.MessagingApp messagingApp;
    private final MessageReader messageReader;

    public AppSnippet(WidgetPage<?> page, boolean globalPage, de.iwes.widgets.messaging.model.MessagingApp messagingApp, MessageReader messageReader, MessagingApp ma) {
        super(page, ResourceUtils.getValidResourceName((String)messagingApp.appId().getValue()), true);
        String description;
        this.page = page;
        this.messagingApp = messagingApp;
        this.messageReader = messageReader;
        String id = ResourceUtils.getValidResourceName((String)messagingApp.appId().getValue());
        String name = ma.getName();
        name = name == null || name.trim().isEmpty() ? "" : name + ": ";
        boolean allApps = ma instanceof AllMessagingApps;
        if (!allApps) {
            Label symbolicName = new Label(page, "symbolicName_" + id, name + ma.getBundleSymbolicName() + ", version " + ma.getVersion());
            this.append((OgemaWidget)symbolicName, null).linebreak(null);
        }
        if ((description = ma.getDescription()) != null && !description.trim().isEmpty()) {
            Label descriptionLabel = new Label(page, "description_" + id, "Description: " + description);
            this.append((OgemaWidget)descriptionLabel, null).linebreak(null);
        }
        if (!allApps) {
            BooleanResourceCheckbox active = new BooleanResourceCheckbox(page, "activeChkbx_" + id, "active", messagingApp.active());
            this.append((OgemaWidget)active, null);
        }
        this.userTable = new DynamicTable(page, "userTable_" + id, true);
        this.createUserTable();
    }

    public void updateDropdowns(Map<String, MessageListener> unchangedListeners, Set<String> unchangedUsers) {
        for (Map.Entry<String, MessageListener> entry : unchangedListeners.entrySet()) {
            for (String user : unchangedUsers) {
                try {
                    Dropdown dd;
                    boolean known = entry.getValue().getKnownUsers().contains(user);
                    String rowId = ResourceUtils.getValidResourceName((String)user);
                    String colId = ResourceUtils.getValidResourceName((String)entry.getKey()) + "Column";
                    Object content = this.userTable.getCellContent(rowId, colId, null);
                    if (!known && content instanceof Dropdown) {
                        dd = (Dropdown)content;
                        dd.destroyWidget();
                        this.userTable.setCell(rowId, colId, (Object)"", null);
                        continue;
                    }
                    if (!known || content instanceof Dropdown) continue;
                    dd = new PriorityDropdown(this.page, user, entry.getKey(), this.getId(), this.messagingApp);
                    this.userTable.setCell(rowId, colId, (Object)dd, null);
                }
                catch (Throwable e) {
                    logger.error("Error updating user dropdowns", e);
                }
            }
        }
    }

    private void updateListenerResources(Map<String, MessageListener> newListeners, Set<String> listenersToBeRemoved) {
        String path;
        ResourceList serviceList = (ResourceList)this.messagingApp.services().create();
        for (String id : listenersToBeRemoved) {
            try {
                path = ResourceUtils.getValidResourceName((String)id);
                ((MessagingService)serviceList.getSubResource(path, MessagingService.class)).delete();
            }
            catch (Exception e) {
                logger.error("Error removing messaging listener resource", (Throwable)e);
            }
        }
        for (String id : newListeners.keySet()) {
            try {
                path = ResourceUtils.getValidResourceName((String)id);
                MessagingService serviceRes = (MessagingService)((MessagingService)serviceList.getSubResource(path, MessagingService.class)).create();
                ((StringResource)serviceRes.serviceId().create()).setValue(id);
                serviceRes.users().create();
            }
            catch (Exception e) {
                logger.error("Error adding messaging listener resource", (Throwable)e);
            }
        }
    }

    private void updateUsersResources(Set<String> usersToBeRemoved) {
        for (MessagingService service : this.messagingApp.services().getAllElements()) {
            for (UserConfig uc : service.users().getAllElements()) {
                try {
                    String user = uc.userName().getValue();
                    if (!usersToBeRemoved.contains(user)) continue;
                    uc.delete();
                }
                catch (Exception e) {
                    logger.error("Error removing messaging user configuration resource", (Throwable)e);
                }
            }
        }
    }

    private void updateUsersTable(Set<String> newUsers, Set<String> usersToBeRemoved) {
        try {
            for (String user : usersToBeRemoved) {
                this.userTable.removeItem((Object)user, null);
            }
            for (String user : newUsers) {
                this.userTable.addItem((Object)user, null);
            }
        }
        catch (Exception e) {
            logger.error("Error updating users table", (Throwable)e);
        }
    }

    private void refreshTable(Set<String> newUsers) {
        try {
            Set rows = this.userTable.getRows(null);
            this.userTable.clear(null);
            this.userTable.refreshHeader(null);
            rows.remove("__headerRow__");
            rows.addAll(newUsers);
            for (String user : rows) {
                this.userTable.addItem((Object)user, null);
            }
        }
        catch (Exception e) {
            logger.error("Error updating messaging app table", (Throwable)e);
        }
    }

    public boolean update(Set<String> newUsers, Set<String> usersToBeRemoved, Map<String, MessageListener> newListeners, Set<String> listenersToBeRemoved) {
        boolean anyServiceChanged;
        boolean anyUsersChanged = !newUsers.isEmpty() || !usersToBeRemoved.isEmpty();
        boolean bl = anyServiceChanged = !newListeners.isEmpty() || !listenersToBeRemoved.isEmpty();
        if (anyServiceChanged) {
            this.updateListenerResources(newListeners, listenersToBeRemoved);
        }
        if (anyUsersChanged) {
            this.updateUsersResources(usersToBeRemoved);
            if (!anyServiceChanged) {
                this.updateUsersTable(newUsers, usersToBeRemoved);
            }
        }
        if (anyServiceChanged) {
            this.refreshTable(newUsers);
        }
        this.messagingApp.activate(true);
        return anyServiceChanged;
    }

    public void createUserTable() {
        UserTemplate userTemplate = new UserTemplate(this.userTable, this.page, this.getId(), this.messagingApp, this.messageReader);
        this.userTable.setRowTemplate((RowTemplate)userTemplate);
        this.userTable.setDefaultRowIdComparator(null);
        ArrayList<WidgetStyle> styles = new ArrayList<WidgetStyle>();
        styles.add(DynamicTableData.CELL_ALIGNMENT_CENTERED);
        this.userTable.setDefaultStyles(styles);
        this.append((OgemaWidget)this.userTable, null);
    }

    public DynamicTable<String> getUserTable() {
        return this.userTable;
    }
}

