/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.messaging.configuration.templates;

import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.form.dropdown.Dropdown;
import de.iwes.widgets.html.form.dropdown.DropdownOption;
import de.iwes.widgets.messaging.model.MessagingApp;
import de.iwes.widgets.messaging.model.UserConfig;
import java.util.ArrayList;
import java.util.Comparator;
import org.ogema.messaging.configuration.MessagePriority;
import org.ogema.messaging.configuration.Util;
import org.ogema.tools.resource.util.ResourceUtils;

public class PriorityDropdown
extends Dropdown {
    private static final long serialVersionUID = 1L;
    private final String userName;
    private final String serviceId;
    private final MessagingApp app;
    private static final Comparator<DropdownOption> PRIO_COMPARATOR = new Comparator<DropdownOption>(){

        @Override
        public int compare(DropdownOption drop0, DropdownOption drop1) {
            if (drop0 == drop1) {
                return 0;
            }
            return MessagePriority.valueOf(drop0.id()).getPriority() - MessagePriority.valueOf(drop1.id()).getPriority();
        }
    };

    public PriorityDropdown(WidgetPage<?> page, String userName, String serviceId, String snippetId, MessagingApp app) {
        super(page, "UserId_" + ResourceUtils.getValidResourceName((String)userName) + "_ServiceId_" + ResourceUtils.getValidResourceName((String)serviceId) + "_AppId_" + snippetId + "_PriorityDropdown", true);
        this.userName = userName;
        this.serviceId = serviceId;
        this.app = app;
        ArrayList<DropdownOption> options = new ArrayList<DropdownOption>();
        for (MessagePriority pr : MessagePriority.values()) {
            String p = pr.name();
            options.add(new DropdownOption(p, p, false));
        }
        ((DropdownOption)options.get(0)).select(true);
        this.setDefaultOptions(options);
        this.setComparator(PRIO_COMPARATOR);
    }

    public void onGET(OgemaHttpRequest req) {
        int prio;
        UserConfig uc = Util.getUserConfig(this.userName, this.serviceId, this.app);
        MessagePriority mp = MessagePriority.NONE;
        if (uc != null && (mp = MessagePriority.forInteger(prio = uc.priority().getValue())) == null) {
            mp = MessagePriority.NONE;
        }
        this.selectSingleOption(mp.toString(), req);
    }

    public void onPOSTComplete(String data, OgemaHttpRequest req) {
        MessagePriority prio = MessagePriority.valueOf(this.getSelectedValue(req));
        if (prio == null) {
            prio = MessagePriority.NONE;
        }
        UserConfig uc = Util.getUserConfig(this.userName, this.serviceId, this.app);
        if (prio == MessagePriority.NONE && uc != null) {
            uc.delete();
        } else if (prio != MessagePriority.NONE) {
            if (uc == null) {
                uc = Util.createUserConfig(this.userName, ResourceUtils.getValidResourceName((String)this.serviceId), this.app);
            }
            uc.priority().setValue(prio.getPriority());
            uc.activate(true);
        }
    }
}

