/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.messaging.configuration.templates;

import de.iwes.widgets.api.messaging.listener.MessageListener;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.complextable.DynamicTable;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.messaging.MessageReader;
import de.iwes.widgets.messaging.model.MessagingApp;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ogema.messaging.configuration.templates.PriorityDropdown;
import org.ogema.tools.resource.util.ResourceUtils;
import org.slf4j.LoggerFactory;

public class UserTemplate
extends RowTemplate<String> {
    protected final WidgetPage<?> page;
    private final String snippetId;
    protected final DynamicTable<String> userTable;
    private final MessagingApp app;
    private final MessageReader messageReader;

    public UserTemplate(DynamicTable<String> userTable, WidgetPage<?> page, String snippetId, MessagingApp app, MessageReader messageReader) {
        this.page = page;
        this.app = app;
        this.messageReader = messageReader;
        this.snippetId = snippetId;
        this.userTable = userTable;
    }

    public String getLineId(String object) {
        return ResourceUtils.getValidResourceName((String)object);
    }

    public Map<String, Object> getHeader() {
        LinkedHashMap<String, Object> userHeader = new LinkedHashMap<String, Object>();
        userHeader.put("userNameColumn", "Name:");
        Set serviceIds = this.messageReader.getMessageListeners().keySet();
        for (String serviceId : serviceIds) {
            userHeader.put(ResourceUtils.getValidResourceName((String)serviceId) + "Column", serviceId);
        }
        return userHeader;
    }

    public RowTemplate.Row addRow(String userName, OgemaHttpRequest req) {
        RowTemplate.Row row = new RowTemplate.Row();
        row.addCell("userNameColumn", (Object)userName);
        for (Map.Entry entry : this.messageReader.getMessageListeners().entrySet()) {
            try {
                String serviceId = (String)entry.getKey();
                String validServiceId = ResourceUtils.getValidResourceName((String)serviceId);
                boolean knownUser = ((MessageListener)entry.getValue()).getKnownUsers().contains(userName);
                if (!knownUser) {
                    row.addCell(validServiceId + "Column", (Object)"");
                    continue;
                }
                PriorityDropdown priority = new PriorityDropdown(this.page, userName, serviceId, this.snippetId, this.app);
                row.addCell(validServiceId + "Column", (Object)priority);
            }
            catch (Throwable e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("", e);
            }
        }
        return row;
    }
}

