/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.apps.message.reader.gui;

import de.iwes.widgets.api.extended.OgemaWidgetBase;
import de.iwes.widgets.api.extended.html.bricks.PageSnippet;
import de.iwes.widgets.api.messaging.listener.ReceivedMessage;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetGroup;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.dynamics.TriggeredAction;
import de.iwes.widgets.api.widgets.dynamics.TriggeringAction;
import de.iwes.widgets.api.widgets.localisation.OgemaLocale;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.form.button.Button;
import de.iwes.widgets.html.form.label.Label;
import de.iwes.widgets.html.popup.Popup;
import de.iwes.widgets.html.popup.PopupData;
import de.iwes.widgets.html.textarea.TextArea;
import java.util.LinkedList;
import org.ogema.apps.message.reader.gui.PageBuilder;

public class MailPopup
extends Popup {
    private static final long serialVersionUID = 1L;
    private final PageSnippet bodyContainer;
    private final Label receiveTimeLabel;
    private final Label receiveTime;
    private final Label titleLabel;
    private final TextArea messageText;
    private final Button deleteButton;
    private final WidgetGroup widgets;

    public MailPopup(WidgetPage<?> page, String id) {
        super(page, id, true);
        this.titleLabel = new Label(page, "mod_titleLabel"){
            private static final long serialVersionUID = 1L;

            public void onGET(OgemaHttpRequest req) {
                OgemaLocale locale = req.getLocale();
                ReceivedMessage message = MailPopup.this.getCurrentMessage(req);
                if (message == null) {
                    return;
                }
                String title = message.getOriginalMessage().title(locale);
                this.setText(title, req);
            }
        };
        this.receiveTime = new Label(page, "mod_receiveTime", "Receival time"){
            private static final long serialVersionUID = 1L;

            public void onGET(OgemaHttpRequest req) {
                ReceivedMessage message = MailPopup.this.getCurrentMessage(req);
                if (message == null) {
                    return;
                }
                long time = message.getTimestamp();
                String timeStr = PageBuilder.getTimeString(time);
                this.setText(timeStr, req);
            }
        };
        this.receiveTimeLabel = new Label(page, "mod_receiveTimeLabel", "Received");
        this.messageText = new TextArea(page, "mod_messageText"){
            private static final long serialVersionUID = 1L;

            public void onGET(OgemaHttpRequest req) {
                OgemaLocale locale = req.getLocale();
                ReceivedMessage message = MailPopup.this.getCurrentMessage(req);
                if (message == null) {
                    return;
                }
                String msg = message.getOriginalMessage().message(locale);
                this.setText(msg, req);
            }
        };
        this.deleteButton = new Button(page, "mod_deleteButton", "Delete Message");
        this.bodyContainer = new PageSnippet(page, "mod_bodyContainer", true);
        LinkedList<Object> widgetsList = new LinkedList<Object>();
        widgetsList.add(this.titleLabel);
        widgetsList.add(this.receiveTimeLabel);
        widgetsList.add(this.receiveTime);
        widgetsList.add(this.messageText);
        widgetsList.add(this.deleteButton);
        this.widgets = page.registerWidgetGroup("popupWidgets", widgetsList);
        this.setWidgets();
    }

    public MailPopupOptions createNewSession() {
        return new MailPopupOptions(this);
    }

    public MailPopupOptions getData(OgemaHttpRequest req) {
        return (MailPopupOptions)super.getData(req);
    }

    public ReceivedMessage getCurrentMessage(OgemaHttpRequest req) {
        return this.getData(req).getCurrentMessage();
    }

    public void setCurrentMessage(ReceivedMessage currentMessage, OgemaHttpRequest req) {
        this.getData(req).setCurrentMessage(currentMessage);
    }

    void initialize() {
        this.setBody((OgemaWidgetBase)this.bodyContainer, null);
        this.triggerAction(this.widgets, TriggeringAction.GET_REQUEST, TriggeredAction.GET_REQUEST);
        this.triggerAction((OgemaWidget)this, TriggeringAction.GET_REQUEST, TriggeredAction.SHOW_WIDGET);
    }

    private void setWidgets() {
        this.bodyContainer.append((OgemaWidget)this.receiveTimeLabel, null);
        this.bodyContainer.append((OgemaWidget)this.receiveTime, null).linebreak(null);
        this.bodyContainer.append((OgemaWidget)this.titleLabel, null).linebreak(null).linebreak(null);
        this.bodyContainer.append((OgemaWidget)this.messageText, null).linebreak(null);
        this.bodyContainer.append((OgemaWidget)this.deleteButton, null);
    }

    public class MailPopupOptions
    extends PopupData {
        private ReceivedMessage currentMessage;

        public MailPopupOptions(MailPopup widget) {
            super((Popup)widget);
            this.currentMessage = null;
        }

        public ReceivedMessage getCurrentMessage() {
            return this.currentMessage;
        }

        public void setCurrentMessage(ReceivedMessage currentMessage) {
            this.currentMessage = currentMessage;
        }
    }
}

