/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.messaging.basic.services.config;

import de.iwes.widgets.api.extended.OgemaWidgetBase;
import de.iwes.widgets.api.extended.WidgetData;
import de.iwes.widgets.api.extended.html.bricks.PageSnippet;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.WidgetStyle;
import de.iwes.widgets.api.widgets.dynamics.TriggeredAction;
import de.iwes.widgets.api.widgets.dynamics.TriggeringAction;
import de.iwes.widgets.api.widgets.html.HtmlItem;
import de.iwes.widgets.api.widgets.html.StaticTable;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.alert.Alert;
import de.iwes.widgets.html.alert.AlertData;
import de.iwes.widgets.html.complextable.DynamicTable;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.html.form.button.Button;
import de.iwes.widgets.html.form.button.ButtonData;
import de.iwes.widgets.html.form.label.Header;
import de.iwes.widgets.html.form.label.Label;
import de.iwes.widgets.html.form.textfield.TextField;
import de.iwes.widgets.html.popup.Popup;
import java.net.URI;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.ResourceList;
import org.ogema.core.model.simple.StringResource;
import org.ogema.core.resourcemanager.ResourceDemandListener;
import org.ogema.core.resourcemanager.ResourceManagement;
import org.ogema.messaging.basic.services.config.localisation.MessageSettingsDictionary;
import org.ogema.messaging.basic.services.config.model.ReceiverConfiguration;
import org.ogema.messaging.basic.services.config.template.ReceiverTemplate;

public class ReceiverPageBuilder
implements ResourceDemandListener<ReceiverConfiguration> {
    private static final String EMAIL_REGEX = "[A-Za-z0-9.-]+[@][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$";
    private static final String SMS_REGEX = "[0-9]+[A-Za-z0-9.-]+[@][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$";
    private static final String XMPP_REGEX = "[A-Za-z0-9.-]+[@][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$";
    private final ResourceList<ReceiverConfiguration> receiverConfigs;
    private final DynamicTable<ReceiverConfiguration> receiverTable;

    public ReceiverPageBuilder(WidgetPage<MessageSettingsDictionary> page, ApplicationManager appMan) {
        ResourceManagement resMan = appMan.getResourceManagement();
        this.receiverConfigs = (ResourceList)resMan.createResource("receiverConfigurations", ResourceList.class);
        this.receiverConfigs.setElementType(ReceiverConfiguration.class);
        this.receiverConfigs.activate(false);
        this.receiverTable = new DynamicTable(page, "receiverTable", true);
        if (Boolean.getBoolean("org.ogema.apps.createtestresources")) {
            this.createTestReceiverResource(this.receiverConfigs, appMan);
        }
        Header header = new Header(page, "header", "Receiver configurations"){

            public void onGET(OgemaHttpRequest req) {
                this.setText(((MessageSettingsDictionary)this.getPage().getDictionary(req)).headerReceivers(), req);
            }
        };
        header.addDefaultStyle(WidgetData.TEXT_ALIGNMENT_CENTERED);
        page.append((OgemaWidget)header).linebreak();
        Alert info = new Alert(page, "description", "Explanation"){

            public void onGET(OgemaHttpRequest req) {
                this.setHtml(((MessageSettingsDictionary)this.getPage().getDictionary(req)).descriptionReceivers(), req);
                this.allowDismiss(true, req);
                this.autoDismiss(-1L, req);
            }
        };
        page.append((OgemaWidget)info).linebreak();
        info.addDefaultStyle(AlertData.BOOTSTRAP_INFO);
        info.setDefaultVisibility(true);
        final Alert alert = new Alert(page, "myAlert", "");
        alert.setDefaultVisibility(false);
        page.append((OgemaWidget)alert).linebreak();
        ReceiverTemplate receiverTemplate = new ReceiverTemplate(this.receiverConfigs, appMan, this.receiverTable, alert, page);
        this.receiverTable.setRowTemplate((RowTemplate)receiverTemplate);
        this.receiverTable.setDefaultRowIdComparator(null);
        ArrayList<WidgetStyle> styles = new ArrayList<WidgetStyle>();
        styles.add(WidgetData.TEXT_ALIGNMENT_CENTERED);
        this.receiverTable.setDefaultStyles(styles);
        Label nameLabel = new Label(page, "nameLabel");
        Label emailLabel = new Label(page, "emailLabel");
        Label smsLabel = new Label(page, "smsLabel");
        Label xmppLabel = new Label(page, "xmppLabel");
        Label restLabel = new Label(page, "restLabel");
        Label restUserLabel = new Label(page, "restUserLabel");
        Label restPwLabel = new Label(page, "restPwLabel");
        nameLabel.setDefaultText("Name: ");
        emailLabel.setDefaultText("Email-address: ");
        smsLabel.setDefaultText("Sms-number: ");
        xmppLabel.setDefaultText("Xmpp-address: ");
        restLabel.setDefaultText("Remote-message-address: ");
        restUserLabel.setDefaultText("Remote-message-user: ");
        restPwLabel.setDefaultText("Remote-message-password: ");
        final TextField nameInput = new TextField(page, "nameInput");
        final TextField emailInput = new TextField(page, "emailInput");
        final TextField smsInput = new TextField(page, "smsInput");
        final TextField xmppInput = new TextField(page, "xmppInput");
        final TextField restInput = new TextField(page, "restInput");
        final TextField restUserInput = new TextField(page, "restUserInput");
        final TextField restPwInput = new TextField(page, "restPwInput");
        StaticTable newReceiverTable = new StaticTable(7, 2);
        newReceiverTable.setContent(0, 0, (OgemaWidget)nameLabel);
        newReceiverTable.setContent(1, 0, (OgemaWidget)emailLabel);
        newReceiverTable.setContent(2, 0, (OgemaWidget)smsLabel);
        newReceiverTable.setContent(3, 0, (OgemaWidget)xmppLabel);
        newReceiverTable.setContent(4, 0, (OgemaWidget)restLabel);
        newReceiverTable.setContent(5, 0, (OgemaWidget)restUserLabel);
        newReceiverTable.setContent(6, 0, (OgemaWidget)restPwLabel);
        newReceiverTable.setContent(0, 1, (OgemaWidget)nameInput);
        newReceiverTable.setContent(1, 1, (OgemaWidget)emailInput);
        newReceiverTable.setContent(2, 1, (OgemaWidget)smsInput);
        newReceiverTable.setContent(3, 1, (OgemaWidget)xmppInput);
        newReceiverTable.setContent(4, 1, (OgemaWidget)restInput);
        newReceiverTable.setContent(5, 1, (OgemaWidget)restUserInput);
        newReceiverTable.setContent(6, 1, (OgemaWidget)restPwInput);
        Popup newReceiverPopup = new Popup(page, "newReceiverPopup", true);
        newReceiverPopup.setTitle("New receiver", null);
        Button acceptNewReceiverButton = new Button(page, "acceptNewReceiverButton"){

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                String name = nameInput.getValue(req).trim();
                String email = emailInput.getValue(req).trim();
                String sms = smsInput.getValue(req).trim();
                String xmpp = xmppInput.getValue(req).trim();
                String rest = restInput.getValue(req).trim();
                String restUser = restUserInput.getValue(req).trim();
                String restPw = restPwInput.getValue(req);
                try {
                    Logger.getGlobal().info(rest + ", " + restUser + ", " + restPw);
                    ReceiverPageBuilder.this.filter(name, email, sms, xmpp, rest, restUser, restPw, req);
                    ReceiverPageBuilder.addNewReceiver((ResourceList<ReceiverConfiguration>)ReceiverPageBuilder.this.receiverConfigs, name, email, sms, xmpp, rest, restUser, restPw);
                    alert.showAlert("Receiver '" + name + "' successfully created", true, req);
                }
                catch (Exception e) {
                    alert.showAlert("Could not create new user: " + e.getMessage(), false, req);
                }
            }
        };
        acceptNewReceiverButton.triggerAction((OgemaWidget)alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        acceptNewReceiverButton.triggerAction((OgemaWidget)acceptNewReceiverButton, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        acceptNewReceiverButton.triggerAction((OgemaWidget)newReceiverPopup, TriggeringAction.POST_REQUEST, TriggeredAction.HIDE_WIDGET);
        acceptNewReceiverButton.triggerAction(this.receiverTable, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        acceptNewReceiverButton.setDefaultText("Accept");
        acceptNewReceiverButton.addDefaultStyle(ButtonData.BOOTSTRAP_GREEN);
        PageSnippet newReceiverSnippet = new PageSnippet(page, "newReceiverSnippet", true);
        newReceiverSnippet.append((HtmlItem)newReceiverTable, null);
        newReceiverSnippet.append((OgemaWidget)acceptNewReceiverButton, null);
        newReceiverPopup.setBody((OgemaWidgetBase)newReceiverSnippet, null);
        Button createNewReceiverButton = new Button(page, "newReceiverButton");
        createNewReceiverButton.triggerAction((OgemaWidget)newReceiverPopup, TriggeringAction.POST_REQUEST, TriggeredAction.SHOW_WIDGET);
        createNewReceiverButton.setDefaultText("create new receiver");
        createNewReceiverButton.addDefaultStyle(ButtonData.BOOTSTRAP_GREEN);
        PageSnippet receiverSnippet = new PageSnippet(page, "receiverSnippet", true);
        receiverSnippet.append(this.receiverTable, null);
        receiverSnippet.append((OgemaWidget)createNewReceiverButton, null);
        page.append((OgemaWidget)receiverSnippet);
        page.append((OgemaWidget)newReceiverPopup);
    }

    private void createTestReceiverResource(ResourceList<ReceiverConfiguration> receiverConfigs, ApplicationManager appMan) {
        ReceiverConfiguration testConfig = (ReceiverConfiguration)receiverConfigs.add();
        StringResource name = (StringResource)testConfig.userName().create();
        name.setValue("XAll");
        StringResource email = (StringResource)testConfig.email().create();
        email.setValue("testtransmitter@web.de");
        StringResource sms = (StringResource)testConfig.sms().create();
        sms.setValue("49157123456789.testtransmitter@tmsg.de");
        StringResource xmpp = (StringResource)testConfig.xmpp().create();
        xmpp.setValue("testtransmitter2@jabber.de");
        StringResource rest = (StringResource)testConfig.remoteMessageRestUrl().create();
        rest.setValue("https://localhost:8444/rest/resources");
        StringResource restUser = (StringResource)testConfig.remoteMessageRestUrl().create();
        restUser.setValue("rest");
        StringResource restPw = (StringResource)testConfig.remoteMessagePassword().create();
        restPw.setValue("rest");
        testConfig.activate(true);
    }

    public static boolean checkIfReceiverExists(ResourceList<ReceiverConfiguration> receiverConfigs, String userName) {
        for (ReceiverConfiguration receiver : receiverConfigs.getAllElements()) {
            if (!receiver.userName().getValue().equals(userName)) continue;
            return true;
        }
        return false;
    }

    public static void addNewReceiver(ResourceList<ReceiverConfiguration> receiverConfigs, String name, String email, String sms, String xmpp, String rest, String restUser, String restPw) {
        ReceiverConfiguration newReceiver = (ReceiverConfiguration)receiverConfigs.add();
        ((StringResource)newReceiver.userName().create()).setValue(name);
        if (!email.isEmpty()) {
            ((StringResource)newReceiver.email().create()).setValue(email);
        }
        if (!sms.isEmpty()) {
            ((StringResource)newReceiver.sms().create()).setValue(sms);
        }
        if (!xmpp.isEmpty()) {
            ((StringResource)newReceiver.xmpp().create()).setValue(xmpp);
        }
        if (!rest.isEmpty()) {
            ((StringResource)newReceiver.remoteMessageRestUrl().create()).setValue(rest.endsWith("/") ? rest : rest + "/");
        }
        if (!restUser.isEmpty()) {
            ((StringResource)newReceiver.remoteMessageUser().create()).setValue(restUser);
        }
        if (!restPw.isEmpty()) {
            ((StringResource)newReceiver.remoteMessagePassword().create()).setValue(restPw);
        }
        newReceiver.activate(true);
    }

    public void resourceAvailable(ReceiverConfiguration receiver) {
        this.receiverTable.addItem((Object)receiver, null);
    }

    public void resourceUnavailable(ReceiverConfiguration receiver) {
        this.receiverTable.removeItem((Object)receiver, null);
    }

    private void filter(String name, String email, String sms, String xmpp, String rest, String restUser, String restPw, OgemaHttpRequest req) throws IllegalArgumentException {
        ReceiverPageBuilder.atLeastOneAddress(email, sms, xmpp, rest);
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Empty username");
        }
        if (!rest.isEmpty()) {
            if (restUser.isEmpty()) {
                throw new IllegalArgumentException("Empty REST-user");
            }
            if (restPw.isEmpty()) {
                throw new IllegalArgumentException("Empty REST-password");
            }
        } else if (!restUser.isEmpty() || !restPw.isEmpty()) {
            throw new IllegalArgumentException("REST-user/REST-password without REST-server");
        }
        if (ReceiverPageBuilder.checkIfReceiverExists(this.receiverConfigs, name)) {
            throw new IllegalArgumentException("The entered username " + name + " already exists, please choose a different one");
        }
    }

    private static void atLeastOneAddress(String email, String sms, String xmpp, String rest) throws IllegalArgumentException {
        boolean xmppMatchesRegex;
        boolean emailMatchesRegex = !email.isEmpty() && email.matches("[A-Za-z0-9.-]+[@][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$");
        boolean smsMatchesRegex = !sms.isEmpty() && sms.matches(SMS_REGEX);
        boolean bl = xmppMatchesRegex = !xmpp.isEmpty() && xmpp.matches("[A-Za-z0-9.-]+[@][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$");
        if (!emailMatchesRegex && !email.isEmpty()) {
            throw new IllegalArgumentException("Invalid email-address");
        }
        if (!smsMatchesRegex && !sms.isEmpty()) {
            throw new IllegalArgumentException("Invalid sms-address");
        }
        if (!xmppMatchesRegex && !xmpp.isEmpty()) {
            throw new IllegalArgumentException("Invalid xmpp-address");
        }
        if (!rest.isEmpty()) {
            try {
                new URI(rest);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid REST-address");
            }
        } else if (email.isEmpty() && sms.isEmpty() && xmpp.isEmpty() && rest.isEmpty()) {
            throw new IllegalArgumentException("Please enter atleast one address");
        }
    }
}

