/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.messaging.basic.services.config;

import de.iwes.widgets.api.extended.OgemaWidgetBase;
import de.iwes.widgets.api.extended.WidgetData;
import de.iwes.widgets.api.extended.html.bricks.PageSnippet;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.WidgetStyle;
import de.iwes.widgets.api.widgets.dynamics.TriggeredAction;
import de.iwes.widgets.api.widgets.dynamics.TriggeringAction;
import de.iwes.widgets.api.widgets.html.HtmlItem;
import de.iwes.widgets.api.widgets.html.StaticTable;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.accordion.Accordion;
import de.iwes.widgets.html.alert.Alert;
import de.iwes.widgets.html.alert.AlertData;
import de.iwes.widgets.html.complextable.DynamicTable;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.html.form.button.Button;
import de.iwes.widgets.html.form.button.ButtonData;
import de.iwes.widgets.html.form.dropdown.Dropdown;
import de.iwes.widgets.html.form.dropdown.DropdownOption;
import de.iwes.widgets.html.form.label.Header;
import de.iwes.widgets.html.form.label.Label;
import de.iwes.widgets.html.form.textfield.TextField;
import de.iwes.widgets.html.popup.Popup;
import java.util.ArrayList;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.ResourceList;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.simple.StringResource;
import org.ogema.core.resourcemanager.ResourceDemandListener;
import org.ogema.core.resourcemanager.ResourceManagement;
import org.ogema.messaging.basic.services.config.localisation.MessageSettingsDictionary;
import org.ogema.messaging.basic.services.config.model.EmailConfiguration;
import org.ogema.messaging.basic.services.config.model.SenderConfiguration;
import org.ogema.messaging.basic.services.config.model.SmsConfiguration;
import org.ogema.messaging.basic.services.config.model.XmppConfiguration;
import org.ogema.messaging.basic.services.config.template.EmailTemplate;
import org.ogema.messaging.basic.services.config.template.SmsTemplate;
import org.ogema.messaging.basic.services.config.template.XmppTemplate;

public class SenderPageBuilder {
    private static final String EMAIL_REGEX = "[A-Za-z0-9]+[A-Za-z0-9.-]*[@][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$";
    private static final String SMS_REGEX = "[A-Za-z0-9]+[A-Za-z0-9.-]*[@][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$";
    private static final String XMPP_REGEX = "[A-Za-z0-9]+[A-Za-z0-9.-]*[@][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$";
    private static final String HOST_REGEX = "[A-Za-z0-9.-]+[.][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$";
    private static final String PORT_REGEX = "[0-9]{1,5}$";
    private static final int INVALID_PORT = 70000;
    private static final String UNSELECTED = "___unselected___";
    private final ResourceList<EmailConfiguration> emailConfigs;
    private final ResourceList<SmsConfiguration> smsConfigs;
    private final ResourceList<XmppConfiguration> xmppConfigs;
    private final DynamicTable<EmailConfiguration> emailTable;
    private final DynamicTable<SmsConfiguration> smsTable;
    private final DynamicTable<XmppConfiguration> xmppTable;
    private final ResourceDemandListener<EmailConfiguration> emailListener;
    private final ResourceDemandListener<SmsConfiguration> smsListener;
    private final ResourceDemandListener<XmppConfiguration> xmppListener;
    final ResourceManagement resMan;

    public SenderPageBuilder(WidgetPage<MessageSettingsDictionary> page, ApplicationManager appManager) {
        this.resMan = appManager.getResourceManagement();
        this.emailConfigs = (ResourceList)this.resMan.createResource("emailConfigs", ResourceList.class);
        this.emailConfigs.setElementType(EmailConfiguration.class);
        this.emailConfigs.activate(false);
        this.smsConfigs = (ResourceList)this.resMan.createResource("smsConfigs", ResourceList.class);
        this.smsConfigs.setElementType(SmsConfiguration.class);
        this.smsConfigs.activate(false);
        this.xmppConfigs = (ResourceList)this.resMan.createResource("xmppConfigs", ResourceList.class);
        this.xmppConfigs.setElementType(XmppConfiguration.class);
        this.xmppConfigs.activate(false);
        this.emailListener = new ResourceDemandListener<EmailConfiguration>(){

            public void resourceAvailable(EmailConfiguration resource) {
                SenderPageBuilder.this.emailTable.addItem((Object)resource, null);
            }

            public void resourceUnavailable(EmailConfiguration resource) {
                SenderPageBuilder.this.emailTable.removeItem((Object)resource, null);
            }
        };
        this.smsListener = new ResourceDemandListener<SmsConfiguration>(){

            public void resourceAvailable(SmsConfiguration resource) {
                SenderPageBuilder.this.smsTable.addItem((Object)resource, null);
            }

            public void resourceUnavailable(SmsConfiguration resource) {
                SenderPageBuilder.this.smsTable.removeItem((Object)resource, null);
            }
        };
        this.xmppListener = new ResourceDemandListener<XmppConfiguration>(){

            public void resourceAvailable(XmppConfiguration resource) {
                SenderPageBuilder.this.xmppTable.addItem((Object)resource, null);
            }

            public void resourceUnavailable(XmppConfiguration resource) {
                SenderPageBuilder.this.xmppTable.removeItem((Object)resource, null);
            }
        };
        Header header = new Header(page, "header", "Sender configurations"){

            public void onGET(OgemaHttpRequest req) {
                this.setText(((MessageSettingsDictionary)this.getPage().getDictionary(req)).headerSenders(), req);
            }
        };
        header.addDefaultStyle(WidgetData.TEXT_ALIGNMENT_CENTERED);
        page.append((OgemaWidget)header).linebreak();
        Alert info = new Alert(page, "description", "Explanation"){

            public void onGET(OgemaHttpRequest req) {
                this.setHtml(((MessageSettingsDictionary)this.getPage().getDictionary(req)).descriptionSenders(), req);
                this.allowDismiss(true, req);
                this.autoDismiss(-1L, req);
            }
        };
        page.append((OgemaWidget)info);
        info.addDefaultStyle(AlertData.BOOTSTRAP_INFO);
        info.setDefaultVisibility(true);
        final Alert alert = new Alert(page, "myAlert", "");
        alert.setDefaultVisibility(false);
        page.append((OgemaWidget)alert).linebreak();
        if (Boolean.getBoolean("org.ogema.apps.createtestresources")) {
            this.createEmailUser("EmailTester_1", "testtransmitter@web.de", "123456789", "smtp.web.de", 587, true);
            this.createSmsUser("SmsTester_1", "testtransmitter@web.de", "123456789", "smtp.web.de", 587, true);
            this.createXmppUser("XmppTester_1", "testtransmitter@jabber.de", "123456789", 5222, true);
        }
        final SenderDropdown<EmailConfiguration> emailSendersDD = new SenderDropdown<EmailConfiguration>(page, "emailSenderDropDown", this.emailConfigs);
        Label emailSendersLabel = new Label(page, "emailSendersLabel_", true);
        emailSendersLabel.setDefaultText("Selected Email-forwarder");
        StaticTable emailSenders = new StaticTable(1, 2);
        emailSenders.setContent(0, 0, (OgemaWidget)emailSendersLabel);
        emailSenders.setContent(0, 1, emailSendersDD);
        this.emailTable = new DynamicTable(page, "emailTable", true);
        EmailTemplate emailTemplate = new EmailTemplate(this.emailConfigs, appManager, this.emailTable, alert, page);
        this.emailTable.setRowTemplate((RowTemplate)emailTemplate);
        this.emailTable.setDefaultRowIdComparator(null);
        ArrayList<WidgetStyle> styles = new ArrayList<WidgetStyle>();
        styles.add(WidgetData.TEXT_ALIGNMENT_CENTERED);
        this.emailTable.setDefaultStyles(styles);
        Label newEmailNameLabel = new Label(page, "newEmailNameLabel");
        newEmailNameLabel.setDefaultText("Name: ");
        Label newEmailLabel = new Label(page, "newEmailLabel");
        newEmailLabel.setDefaultText("Email-address: ");
        Label newEmailPasswordLabel = new Label(page, "newEmailPasswordLabel");
        newEmailPasswordLabel.setDefaultText("Password: ");
        Label newEmailUrlLabel = new Label(page, "newEmailUrlLabel");
        newEmailUrlLabel.setDefaultText("Host: ");
        Label newEmailPortLabel = new Label(page, "newEmailPortLabel");
        newEmailPortLabel.setDefaultText("Port: ");
        final TextField newEmailNameTextField = new TextField(page, "newEmailNameTextField");
        final TextField newEmailTextField = new TextField(page, "newEmailTextField");
        final TextField newEmailPasswordTextField = new TextField(page, "newEmailPasswordTextField");
        final TextField newEmailUrlTextField = new TextField(page, "newEmailUrlTextField");
        final TextField newEmailPortTextField = new TextField(page, "newEmailPortTextField");
        StaticTable newEmailUserTable = new StaticTable(5, 2);
        newEmailUserTable.setContent(0, 0, (OgemaWidget)newEmailNameLabel);
        newEmailUserTable.setContent(1, 0, (OgemaWidget)newEmailLabel);
        newEmailUserTable.setContent(2, 0, (OgemaWidget)newEmailPasswordLabel);
        newEmailUserTable.setContent(3, 0, (OgemaWidget)newEmailUrlLabel);
        newEmailUserTable.setContent(4, 0, (OgemaWidget)newEmailPortLabel);
        newEmailUserTable.setContent(0, 1, (OgemaWidget)newEmailNameTextField);
        newEmailUserTable.setContent(1, 1, (OgemaWidget)newEmailTextField);
        newEmailUserTable.setContent(2, 1, (OgemaWidget)newEmailPasswordTextField);
        newEmailUserTable.setContent(3, 1, (OgemaWidget)newEmailUrlTextField);
        newEmailUserTable.setContent(4, 1, (OgemaWidget)newEmailPortTextField);
        Popup newEmailUserPopup = new Popup(page, "newUserPopup", true);
        newEmailUserPopup.setTitle("New email-user", null);
        Button acceptNewEmailUserButton = new Button(page, "acceptNewEmailUserButton"){

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                String name = newEmailNameTextField.getValue(req).trim();
                String email = newEmailTextField.getValue(req).trim();
                String pw = newEmailPasswordTextField.getValue(req).trim();
                String host = newEmailUrlTextField.getValue(req).trim();
                String serverPort = newEmailPortTextField.getValue(req).trim();
                int port = 70000;
                if (serverPort.matches(SenderPageBuilder.PORT_REGEX)) {
                    port = Integer.parseInt(serverPort);
                }
                if (email.matches("[A-Za-z0-9]+[A-Za-z0-9.-]*[@][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$") && host.matches(SenderPageBuilder.HOST_REGEX) && !name.isEmpty() && port <= 65535 && !pw.isEmpty()) {
                    Boolean userExists = SenderPageBuilder.this.checkIfUserExists((ResourceList<? extends SenderConfiguration>)SenderPageBuilder.this.emailConfigs, name);
                    if (!userExists.booleanValue()) {
                        String currentUser = emailSendersDD.getSelectedValue(req);
                        boolean active = currentUser.equals(SenderPageBuilder.UNSELECTED);
                        SenderPageBuilder.this.createEmailUser(name, email, pw, host, port, active);
                        alert.showAlert("User '" + name + "' successfully created", true, req);
                    } else {
                        alert.showAlert("User '" + name + "' already exists", false, req);
                    }
                } else {
                    if (!email.matches("[A-Za-z0-9]+[A-Za-z0-9.-]*[@][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$")) {
                        alert.showAlert("Invalid values: Invalid email", false, req);
                    }
                    if (!host.matches(SenderPageBuilder.HOST_REGEX)) {
                        alert.showAlert("Invalid values: Invalid host", false, req);
                    }
                    if (name.isEmpty()) {
                        alert.showAlert("Invalid values: No name entered", false, req);
                    }
                    if (port > 65535) {
                        alert.showAlert("Invalid values: Invalid port", false, req);
                    }
                    if (pw.isEmpty()) {
                        alert.showAlert("Invalid values: No password entered", false, req);
                    }
                }
            }
        };
        acceptNewEmailUserButton.triggerAction((OgemaWidget)alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        acceptNewEmailUserButton.triggerAction((OgemaWidget)acceptNewEmailUserButton, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        acceptNewEmailUserButton.triggerAction((OgemaWidget)newEmailUserPopup, TriggeringAction.POST_REQUEST, TriggeredAction.HIDE_WIDGET);
        acceptNewEmailUserButton.triggerAction(this.emailTable, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        acceptNewEmailUserButton.triggerAction(emailSendersDD, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        acceptNewEmailUserButton.setDefaultText("Accept");
        acceptNewEmailUserButton.addDefaultStyle(ButtonData.BOOTSTRAP_GREEN);
        PageSnippet newEmailUserSnippet = new PageSnippet(page, "newEmailUserSnippet", true);
        newEmailUserSnippet.append((HtmlItem)newEmailUserTable, null);
        newEmailUserSnippet.append((OgemaWidget)acceptNewEmailUserButton, null);
        newEmailUserPopup.setBody((OgemaWidgetBase)newEmailUserSnippet, null);
        Button createNewEmailButton = new Button(page, "newEmailButton");
        createNewEmailButton.triggerAction((OgemaWidget)createNewEmailButton, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        createNewEmailButton.triggerAction((OgemaWidget)newEmailUserPopup, TriggeringAction.POST_REQUEST, TriggeredAction.SHOW_WIDGET);
        createNewEmailButton.setDefaultText("create new sender");
        createNewEmailButton.addDefaultStyle(ButtonData.BOOTSTRAP_GREEN);
        PageSnippet emailSnippet = new PageSnippet(page, "emailSnippet", true);
        emailSnippet.append(this.emailTable, null);
        emailSnippet.append((OgemaWidget)createNewEmailButton, null);
        emailSnippet.append((HtmlItem)emailSenders, null);
        final SenderDropdown<SmsConfiguration> smsSendersDD = new SenderDropdown<SmsConfiguration>(page, "smsSenderDropDown", this.smsConfigs);
        Label smsSendersLabel = new Label(page, "smsSendersLabel_", true);
        smsSendersLabel.setDefaultText("Selected sms-forwarder");
        StaticTable smsSenders = new StaticTable(1, 2);
        smsSenders.setContent(0, 0, (OgemaWidget)smsSendersLabel);
        smsSenders.setContent(0, 1, smsSendersDD);
        this.smsTable = new DynamicTable(page, "smsTable", true);
        SmsTemplate smsTemplate = new SmsTemplate(this.smsConfigs, appManager, this.smsTable, alert, page);
        this.smsTable.setRowTemplate((RowTemplate)smsTemplate);
        this.smsTable.setDefaultRowIdComparator(null);
        this.smsTable.addDefaultStyle(WidgetData.TEXT_ALIGNMENT_CENTERED);
        this.smsTable.setDefaultStyles(styles);
        Label newSmsNameLabel = new Label(page, "newSmsNameLabel");
        newSmsNameLabel.setDefaultText("Name:");
        Label newSmsEmailLabel = new Label(page, "newSmsEmailLabel");
        newSmsEmailLabel.setDefaultText("Email-address:");
        Label newSmsEmailPasswordLabel = new Label(page, "newSmsPasswordLabel");
        newSmsEmailPasswordLabel.setDefaultText("Password:");
        Label newSmsEmailServerLabel = new Label(page, "newSmsEmailServerLabel");
        newSmsEmailServerLabel.setDefaultText("Host:");
        Label newSmsEmailPortLabel = new Label(page, "newSmsEmailPortLabel");
        newSmsEmailPortLabel.setDefaultText("Port:");
        final TextField newSmsNameTextField = new TextField(page, "newSmsNameTextField");
        final TextField newSmsEmailTextField = new TextField(page, "newSmsEmailTextField");
        final TextField newSmsEmailPasswordTextField = new TextField(page, "newSmsEmailPasswordTextField");
        final TextField newSmsEmailServerTextField = new TextField(page, "newSmsEmailServerTextField");
        final TextField newSmsEmailPortTextField = new TextField(page, "newSmsEmailPortTextField");
        StaticTable newSmsUserTable = new StaticTable(5, 2);
        newSmsUserTable.setContent(0, 0, (OgemaWidget)newSmsNameLabel);
        newSmsUserTable.setContent(1, 0, (OgemaWidget)newSmsEmailLabel);
        newSmsUserTable.setContent(2, 0, (OgemaWidget)newSmsEmailPasswordLabel);
        newSmsUserTable.setContent(3, 0, (OgemaWidget)newSmsEmailServerLabel);
        newSmsUserTable.setContent(4, 0, (OgemaWidget)newSmsEmailPortLabel);
        newSmsUserTable.setContent(0, 1, (OgemaWidget)newSmsNameTextField);
        newSmsUserTable.setContent(1, 1, (OgemaWidget)newSmsEmailTextField);
        newSmsUserTable.setContent(2, 1, (OgemaWidget)newSmsEmailPasswordTextField);
        newSmsUserTable.setContent(3, 1, (OgemaWidget)newSmsEmailServerTextField);
        newSmsUserTable.setContent(4, 1, (OgemaWidget)newSmsEmailPortTextField);
        Popup newSmsUserPopup = new Popup(page, "newSmsUserPopup", true);
        newSmsUserPopup.setTitle("New sms-user", null);
        Button acceptNewSmsUserButton = new Button(page, "acceptNewSmsUserButton"){

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                String name = newSmsNameTextField.getValue(req).trim();
                String sms = newSmsEmailTextField.getValue(req).trim();
                String host = newSmsEmailServerTextField.getValue(req).trim();
                String pw = newSmsEmailPasswordTextField.getValue(req);
                String serverPort = newSmsEmailPortTextField.getValue(req).trim();
                int port = 70000;
                if (serverPort.matches(SenderPageBuilder.PORT_REGEX)) {
                    port = Integer.parseInt(serverPort);
                }
                if (!name.isEmpty() && port <= 65535 && sms.matches("[A-Za-z0-9]+[A-Za-z0-9.-]*[@][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$") && host.matches(SenderPageBuilder.HOST_REGEX) && !pw.isEmpty()) {
                    Boolean userExists = SenderPageBuilder.this.checkIfUserExists((ResourceList<? extends SenderConfiguration>)SenderPageBuilder.this.smsConfigs, name);
                    if (!userExists.booleanValue()) {
                        String currentUser = smsSendersDD.getSelectedValue(req);
                        boolean active = currentUser.equals(SenderPageBuilder.UNSELECTED);
                        SenderPageBuilder.this.createSmsUser(name, sms, pw, host, port, active);
                        alert.showAlert("User '" + name + "' successfully created", true, req);
                    } else {
                        alert.showAlert("User '" + name + "' already exists", false, req);
                    }
                } else if (!sms.matches("[A-Za-z0-9]+[A-Za-z0-9.-]*[@][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$")) {
                    alert.showAlert("Invalid sms-email-address", false, req);
                } else if (!host.matches(SenderPageBuilder.HOST_REGEX)) {
                    alert.showAlert("Invalid server-URL", false, req);
                } else if (name.isEmpty()) {
                    alert.showAlert("No name entered", false, req);
                } else if (port > 65535) {
                    alert.showAlert("Invalid port", false, req);
                } else if (pw.isEmpty()) {
                    alert.showAlert("No password entered", false, req);
                }
            }
        };
        acceptNewSmsUserButton.triggerAction((OgemaWidget)alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        acceptNewSmsUserButton.triggerAction((OgemaWidget)acceptNewSmsUserButton, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        acceptNewSmsUserButton.triggerAction((OgemaWidget)newSmsUserPopup, TriggeringAction.POST_REQUEST, TriggeredAction.HIDE_WIDGET);
        acceptNewSmsUserButton.triggerAction(this.smsTable, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        acceptNewSmsUserButton.setDefaultText("Accept");
        acceptNewSmsUserButton.addDefaultStyle(ButtonData.BOOTSTRAP_GREEN);
        PageSnippet newSmsUserSnippet = new PageSnippet(page, "newSmsUserSnippet", true);
        newSmsUserSnippet.append((HtmlItem)newSmsUserTable, null);
        newSmsUserSnippet.append((OgemaWidget)acceptNewSmsUserButton, null);
        newSmsUserPopup.setBody((OgemaWidgetBase)newSmsUserSnippet, null);
        Button createNewSmsButton = new Button(page, "newSmsButton");
        createNewSmsButton.triggerAction((OgemaWidget)createNewSmsButton, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        createNewSmsButton.triggerAction((OgemaWidget)newSmsUserPopup, TriggeringAction.POST_REQUEST, TriggeredAction.SHOW_WIDGET);
        createNewSmsButton.setDefaultText("create new sender");
        createNewSmsButton.addDefaultStyle(ButtonData.BOOTSTRAP_GREEN);
        PageSnippet smsSnippet = new PageSnippet(page, "smsSnippet", true);
        smsSnippet.append(this.smsTable, null);
        smsSnippet.append((OgemaWidget)createNewSmsButton, null);
        smsSnippet.append((HtmlItem)smsSenders, null);
        final SenderDropdown<XmppConfiguration> xmppSendersDD = new SenderDropdown<XmppConfiguration>(page, "xmppSenderDropDown", this.xmppConfigs);
        Label xmppSendersLabel = new Label(page, "xmppSendersLabel_", true);
        xmppSendersLabel.setDefaultText("Select xmpp-forwarder");
        StaticTable xmppSenders = new StaticTable(1, 2);
        xmppSenders.setContent(0, 0, (OgemaWidget)xmppSendersLabel);
        xmppSenders.setContent(0, 1, xmppSendersDD);
        this.xmppTable = new DynamicTable(page, "xmppTable", true);
        XmppTemplate xmppTemplate = new XmppTemplate(this.xmppConfigs, appManager, this.xmppTable, alert, page);
        this.xmppTable.setRowTemplate((RowTemplate)xmppTemplate);
        this.xmppTable.setDefaultRowIdComparator(null);
        this.xmppTable.addDefaultStyle(WidgetData.TEXT_ALIGNMENT_CENTERED);
        this.xmppTable.setDefaultStyles(styles);
        Label newXmppNameLabel = new Label(page, "newXmppNameLabel");
        newXmppNameLabel.setDefaultText("Name: ");
        Label newXmppLabel = new Label(page, "newXmppLabel");
        newXmppLabel.setDefaultText("Xmpp address: ");
        Label newXmppPasswordLabel = new Label(page, "newXmppPasswordLabel");
        newXmppPasswordLabel.setDefaultText("Password: ");
        Label newXmppPortLabel = new Label(page, "newXmppPortLabel");
        newXmppPortLabel.setDefaultText("Port: ");
        final TextField newXmppNameTextField = new TextField(page, "newXmppNameTextField");
        final TextField newXmppTextField = new TextField(page, "newXmppTextField");
        final TextField newXmppPasswordTextField = new TextField(page, "newXmppPasswordTextField");
        final TextField newXmppPortTextField = new TextField(page, "newXmppPortTextField");
        StaticTable newXmppUserTable = new StaticTable(4, 2);
        newXmppUserTable.setContent(0, 0, (OgemaWidget)newXmppNameLabel);
        newXmppUserTable.setContent(1, 0, (OgemaWidget)newXmppLabel);
        newXmppUserTable.setContent(2, 0, (OgemaWidget)newXmppPasswordLabel);
        newXmppUserTable.setContent(3, 0, (OgemaWidget)newXmppPortLabel);
        newXmppUserTable.setContent(0, 1, (OgemaWidget)newXmppNameTextField);
        newXmppUserTable.setContent(1, 1, (OgemaWidget)newXmppTextField);
        newXmppUserTable.setContent(2, 1, (OgemaWidget)newXmppPasswordTextField);
        newXmppUserTable.setContent(3, 1, (OgemaWidget)newXmppPortTextField);
        Popup newXmppUserPopup = new Popup(page, "newXmppUserPopup", true);
        newXmppUserPopup.setTitle("New xmpp-user", null);
        Button acceptNewXmppUserButton = new Button(page, "acceptNewXmppUserButton"){

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                String name = newXmppNameTextField.getValue(req).trim();
                String xmpp = newXmppTextField.getValue(req).trim();
                String pw = newXmppPasswordTextField.getValue(req);
                String serverPort = newXmppPortTextField.getValue(req).trim();
                int port = 70000;
                if (serverPort.matches(SenderPageBuilder.PORT_REGEX)) {
                    port = Integer.parseInt(serverPort);
                }
                if (xmpp.matches("[A-Za-z0-9]+[A-Za-z0-9.-]*[@][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$") && !name.isEmpty() && !pw.isEmpty() && port <= 65535) {
                    Boolean userExists = SenderPageBuilder.this.checkIfUserExists((ResourceList<? extends SenderConfiguration>)SenderPageBuilder.this.xmppConfigs, name);
                    if (!userExists.booleanValue()) {
                        String currentUser = xmppSendersDD.getSelectedValue(req);
                        boolean active = currentUser.equals(SenderPageBuilder.UNSELECTED);
                        SenderPageBuilder.this.createXmppUser(name, xmpp, pw, port, active);
                        alert.showAlert("User '" + name + "' successfully created", true, req);
                    } else {
                        alert.showAlert("User '" + name + "' already exists", false, req);
                    }
                } else if (!xmpp.matches("[A-Za-z0-9]+[A-Za-z0-9.-]*[@][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$")) {
                    alert.showAlert("Invalid xmpp-address", false, req);
                } else if (name.isEmpty()) {
                    alert.showAlert("No name entered", false, req);
                } else if (pw.isEmpty()) {
                    alert.showAlert("No password entered", false, req);
                } else if (port > 65535) {
                    alert.showAlert("Invalid port", false, req);
                }
            }
        };
        acceptNewXmppUserButton.triggerAction((OgemaWidget)alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        acceptNewXmppUserButton.triggerAction((OgemaWidget)acceptNewXmppUserButton, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        acceptNewXmppUserButton.triggerAction((OgemaWidget)newXmppUserPopup, TriggeringAction.POST_REQUEST, TriggeredAction.HIDE_WIDGET);
        acceptNewXmppUserButton.triggerAction(this.xmppTable, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        acceptNewXmppUserButton.setDefaultText("Accept");
        acceptNewXmppUserButton.addDefaultStyle(ButtonData.BOOTSTRAP_GREEN);
        PageSnippet newXmppUserSnippet = new PageSnippet(page, "newXmppUserSnippet", true);
        newXmppUserSnippet.append((HtmlItem)newXmppUserTable, null);
        newXmppUserSnippet.append((OgemaWidget)acceptNewXmppUserButton, null);
        newXmppUserPopup.setBody((OgemaWidgetBase)newXmppUserSnippet, null);
        Button createNewXmppButton = new Button(page, "newXmppButton");
        createNewXmppButton.triggerAction((OgemaWidget)createNewXmppButton, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        createNewXmppButton.triggerAction((OgemaWidget)newXmppUserPopup, TriggeringAction.POST_REQUEST, TriggeredAction.SHOW_WIDGET);
        createNewXmppButton.setDefaultText("create new sender");
        createNewXmppButton.addDefaultStyle(ButtonData.BOOTSTRAP_GREEN);
        PageSnippet xmppSnippet = new PageSnippet(page, "xmppSnippet", true);
        xmppSnippet.append(this.xmppTable, null);
        xmppSnippet.append((OgemaWidget)createNewXmppButton, null);
        xmppSnippet.append((HtmlItem)xmppSenders, null);
        Accordion accordion = new Accordion(page, "allAccordion", true);
        accordion.addItem("Email", (OgemaWidget)emailSnippet, null);
        accordion.addItem("Sms", (OgemaWidget)smsSnippet, null);
        accordion.addItem("Xmpp", (OgemaWidget)xmppSnippet, null);
        page.append((OgemaWidget)accordion);
        page.append((OgemaWidget)newEmailUserPopup);
        page.append((OgemaWidget)newSmsUserPopup);
        page.append((OgemaWidget)newXmppUserPopup);
    }

    private void createEmailUser(String name, String email, String password, String host, int port, boolean createActive) {
        EmailConfiguration newEmailUser = (EmailConfiguration)this.emailConfigs.add();
        ((StringResource)newEmailUser.userName().create()).setValue(name);
        ((StringResource)newEmailUser.email().create()).setValue(email);
        ((StringResource)newEmailUser.password().create()).setValue(password);
        ((StringResource)newEmailUser.serverURL().create()).setValue(host);
        ((IntegerResource)newEmailUser.port().create()).setValue(port);
        ((BooleanResource)newEmailUser.active().create()).setValue(createActive);
        newEmailUser.activate(true);
    }

    private void createSmsUser(String name, String sms, String password, String host, int port, boolean createActive) {
        SmsConfiguration newSmsUser = (SmsConfiguration)this.smsConfigs.add();
        ((StringResource)newSmsUser.userName().create()).setValue(name);
        ((StringResource)newSmsUser.smsEmail().create()).setValue(sms);
        ((StringResource)newSmsUser.smsEmailPassword().create()).setValue(password);
        ((StringResource)newSmsUser.smsEmailServer().create()).setValue(host);
        ((IntegerResource)newSmsUser.smsEmailPort().create()).setValue(port);
        ((BooleanResource)newSmsUser.active().create()).setValue(createActive);
        newSmsUser.activate(true);
    }

    private void createXmppUser(String name, String xmpp, String password, int port, boolean createActive) {
        XmppConfiguration newXmppUser = (XmppConfiguration)this.xmppConfigs.add();
        ((StringResource)newXmppUser.userName().create()).setValue(name);
        ((StringResource)newXmppUser.xmpp().create()).setValue(xmpp);
        ((StringResource)newXmppUser.password().create()).setValue(password);
        ((IntegerResource)newXmppUser.port().create()).setValue(port);
        ((BooleanResource)newXmppUser.active().create()).setValue(createActive);
        newXmppUser.activate(true);
    }

    private boolean checkIfUserExists(ResourceList<? extends SenderConfiguration> configs, String user) {
        for (SenderConfiguration cfg : configs.getAllElements()) {
            if (!cfg.userName().getValue().equals(user)) continue;
            return true;
        }
        return false;
    }

    public ResourceDemandListener<EmailConfiguration> getEmailListener() {
        return this.emailListener;
    }

    public ResourceDemandListener<SmsConfiguration> getSmsListener() {
        return this.smsListener;
    }

    public ResourceDemandListener<XmppConfiguration> getXmppListener() {
        return this.xmppListener;
    }

    private static class SenderDropdown<S extends SenderConfiguration>
    extends Dropdown {
        private static final long serialVersionUID = 1L;
        private final ResourceList<S> entries;

        public SenderDropdown(WidgetPage<?> page, String id, ResourceList<S> entries) {
            super(page, id);
            this.entries = entries;
        }

        public void onGET(OgemaHttpRequest req) {
            String activeUser = SenderPageBuilder.UNSELECTED;
            for (SenderConfiguration emailConfig : this.entries.getAllElements()) {
                String userName = emailConfig.userName().getValue();
                if (emailConfig.active().isActive() && emailConfig.active().getValue()) {
                    activeUser = userName;
                }
                if (this.containsValue(userName, req)) continue;
                this.addOption(userName, userName, false, req);
            }
            for (DropdownOption opt : this.getDropdownOptions(req)) {
                Boolean isAvailable = false;
                String userName = opt.id();
                if (userName.equals(SenderPageBuilder.UNSELECTED) && activeUser.equals(SenderPageBuilder.UNSELECTED)) continue;
                for (SenderConfiguration config : this.entries.getAllElements()) {
                    if (!config.userName().getValue().equals(userName)) continue;
                    isAvailable = true;
                    break;
                }
                if (isAvailable.booleanValue()) continue;
                this.removeOption(userName, req);
            }
            if (activeUser.equals(SenderPageBuilder.UNSELECTED) && !this.containsValue(SenderPageBuilder.UNSELECTED, req)) {
                this.addOption("Select a sender", SenderPageBuilder.UNSELECTED, false, req);
            }
            this.selectSingleOption(activeUser, req);
        }

        public void onPOSTComplete(String data, OgemaHttpRequest req) {
            String name = this.getSelectedValue(req);
            for (SenderConfiguration conf : this.entries.getAllElements()) {
                ((BooleanResource)conf.active().create()).setValue(conf.userName().getValue().equals(name));
                conf.active().activate(false);
            }
        }
    }
}

