/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.messaging.basic.services.config.template;

import de.iwes.widgets.api.extended.OgemaWidgetBase;
import de.iwes.widgets.api.extended.html.bricks.PageSnippet;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.dynamics.TriggeredAction;
import de.iwes.widgets.api.widgets.dynamics.TriggeringAction;
import de.iwes.widgets.api.widgets.html.HtmlItem;
import de.iwes.widgets.api.widgets.html.StaticTable;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.alert.Alert;
import de.iwes.widgets.html.buttonconfirm.ButtonConfirm;
import de.iwes.widgets.html.complextable.DynamicTable;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.html.form.button.Button;
import de.iwes.widgets.html.form.button.ButtonData;
import de.iwes.widgets.html.form.label.Label;
import de.iwes.widgets.html.form.textfield.TextField;
import de.iwes.widgets.html.popup.Popup;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.logging.OgemaLogger;
import org.ogema.core.model.ResourceList;
import org.ogema.core.resourcemanager.ResourceAccess;
import org.ogema.messaging.basic.services.config.model.XmppConfiguration;
import org.ogema.tools.resource.util.ResourceUtils;

public class XmppTemplate
extends RowTemplate<XmppConfiguration> {
    protected final ResourceList<XmppConfiguration> list;
    protected final DynamicTable<XmppConfiguration> table;
    protected final Alert alert;
    protected final WidgetPage<?> page;
    protected final ApplicationManager am;
    protected final OgemaLogger logger;
    protected final ResourceAccess ra;

    public XmppTemplate(ResourceList<XmppConfiguration> list, ApplicationManager am, DynamicTable<XmppConfiguration> table, Alert alert, WidgetPage<?> page) {
        this.list = list;
        this.table = table;
        this.alert = alert;
        this.page = page;
        this.am = am;
        this.logger = am.getLogger();
        this.ra = am.getResourceAccess();
    }

    public Map<String, Object> getHeader() {
        LinkedHashMap<String, Object> xmppHeader = new LinkedHashMap<String, Object>();
        xmppHeader.put("xmppNameColumn", "Name:");
        xmppHeader.put("xmppColumn", "Xmpp-address:");
        xmppHeader.put("xmppPasswordColumn", "Password:");
        xmppHeader.put("xmppPortColumn", "Port:");
        xmppHeader.put("emptyXmppColumn3", "");
        xmppHeader.put("editXmppPopupColumn", "");
        xmppHeader.put("editXmppColumn", "");
        xmppHeader.put("deleteXmppColumn", "");
        return xmppHeader;
    }

    public String getLineId(XmppConfiguration object) {
        return ResourceUtils.getValidResourceName((String)object.userName().getValue());
    }

    public RowTemplate.Row addRow(final XmppConfiguration config, OgemaHttpRequest req) {
        RowTemplate.Row row = new RowTemplate.Row();
        final String id = this.getLineId(config);
        Label xmppNameLabel = new Label(this.page, "xmppNameLabel_" + id, true);
        xmppNameLabel.setDefaultText(config.userName().getValue());
        row.addCell("xmppNameColumn", (Object)xmppNameLabel);
        Label xmppLabel = new Label(this.page, "xmppLabel_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setText(config.xmpp().getValue(), req);
            }
        };
        row.addCell("xmppColumn", (Object)xmppLabel);
        Label xmppPasswordLabel = new Label(this.page, "xmppPasswordLabel_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setText(config.password().getValue(), req);
            }
        };
        row.addCell("xmppPasswordColumn", (Object)xmppPasswordLabel);
        Label xmppPortLabel = new Label(this.page, "xmppPortLabel_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setText(String.valueOf(config.port().getValue()), req);
            }
        };
        row.addCell("xmppPortColumn", (Object)xmppPortLabel);
        Label editXmppNameLabel = new Label(this.page, "editXmppNameLabel_" + id, true);
        editXmppNameLabel.setDefaultText("Name: ");
        Label editXmppLabel = new Label(this.page, "editXmppLabel_" + id, true);
        editXmppLabel.setDefaultText("New xmpp-address: ");
        Label editXmppPasswordLabel = new Label(this.page, "editXmppPasswordLabel_" + id, true);
        editXmppPasswordLabel.setDefaultText("New password: ");
        Label editXmppPortLabel = new Label(this.page, "editXmppPortLabel_" + id, true);
        editXmppPortLabel.setDefaultText("New port: ");
        final TextField editXmppTextField = new TextField(this.page, "xmppTextField_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setValue(config.xmpp().getValue(), req);
            }
        };
        final TextField editXmppPasswordTextField = new TextField(this.page, "xmppPasswordTextField_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setValue(config.password().getValue(), req);
            }
        };
        final TextField editXmppPortTextField = new TextField(this.page, "xmppPortTextField_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setValue(String.valueOf(config.port().getValue()), req);
            }
        };
        row.addCell("emptyXmppColumn1", (Object)"");
        row.addCell("emptyXmppColumn2", (Object)"");
        Popup editXmppUserPopup = new Popup(this.page, "editXmppUserPopup_" + id, true);
        editXmppUserPopup.setTitle("Edit User", null);
        row.addCell("editXmppPopupColumn", (Object)editXmppUserPopup);
        Button editXmppUserButton = new Button(this.page, "editXmppUserButton" + id);
        editXmppUserButton.triggerAction(this.table, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        editXmppUserButton.triggerAction((OgemaWidget)editXmppUserPopup, TriggeringAction.POST_REQUEST, TriggeredAction.SHOW_WIDGET);
        editXmppUserButton.triggerAction((OgemaWidget)editXmppTextField, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        editXmppUserButton.triggerAction((OgemaWidget)editXmppPasswordTextField, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        editXmppUserButton.triggerAction((OgemaWidget)editXmppPortTextField, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        editXmppUserButton.addDefaultStyle(ButtonData.BOOTSTRAP_GREEN);
        editXmppUserButton.setDefaultText("Edit");
        row.addCell("editXmppColumn", (Object)editXmppUserButton);
        ButtonConfirm confirmXmppChangesButton = new ButtonConfirm(this.page, "confirmXmppChangesButton_" + id){

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                String xmppRegex = "[A-Za-z0-9.-]+[@][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$";
                String portRegex = "[0-9]{1,5}$";
                int port = 70000;
                if (editXmppPortTextField.getValue(req).matches(portRegex)) {
                    port = Integer.parseInt(editXmppPortTextField.getValue(req));
                }
                if (editXmppTextField.getValue(req).matches(xmppRegex) && !editXmppPasswordTextField.getValue(req).isEmpty() && port <= 65535) {
                    config.xmpp().setValue(editXmppTextField.getValue(req));
                    config.password().setValue(editXmppPasswordTextField.getValue(req));
                    config.port().setValue(port);
                    XmppTemplate.this.alert.showAlert("Changes on User '" + id + "' confirmed", true, req);
                } else {
                    if (!editXmppTextField.getValue(req).matches(xmppRegex)) {
                        XmppTemplate.this.alert.showAlert("Invalid Xmpp-Address", false, req);
                    }
                    if (editXmppPasswordTextField.getValue(req).isEmpty()) {
                        XmppTemplate.this.alert.showAlert("No Password entered", false, req);
                    }
                    if (port > 65535) {
                        XmppTemplate.this.alert.showAlert("Invalid Port", false, req);
                    }
                }
            }
        };
        confirmXmppChangesButton.triggerAction((OgemaWidget)xmppLabel, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmXmppChangesButton.triggerAction((OgemaWidget)editXmppUserPopup, TriggeringAction.POST_REQUEST, TriggeredAction.HIDE_WIDGET);
        confirmXmppChangesButton.triggerAction((OgemaWidget)xmppLabel, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmXmppChangesButton.triggerAction((OgemaWidget)xmppPasswordLabel, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmXmppChangesButton.triggerAction((OgemaWidget)xmppPortLabel, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmXmppChangesButton.triggerAction((OgemaWidget)this.alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmXmppChangesButton.addDefaultStyle(ButtonData.BOOTSTRAP_GREEN);
        confirmXmppChangesButton.setDefaultText("Save Changes");
        confirmXmppChangesButton.setDefaultConfirmPopupTitle("Edit " + id);
        confirmXmppChangesButton.setDefaultConfirmMsg("Accept changes ?");
        StaticTable editXmppUserTable = new StaticTable(4, 2);
        editXmppUserTable.setContent(0, 0, (OgemaWidget)editXmppNameLabel);
        editXmppUserTable.setContent(0, 1, config.userName().getValue());
        editXmppUserTable.setContent(1, 0, (OgemaWidget)editXmppLabel);
        editXmppUserTable.setContent(1, 1, (OgemaWidget)editXmppTextField);
        editXmppUserTable.setContent(2, 0, (OgemaWidget)editXmppPasswordLabel);
        editXmppUserTable.setContent(2, 1, (OgemaWidget)editXmppPasswordTextField);
        editXmppUserTable.setContent(3, 0, (OgemaWidget)editXmppPortLabel);
        editXmppUserTable.setContent(3, 1, (OgemaWidget)editXmppPortTextField);
        PageSnippet editXmppUserSnippet = new PageSnippet(this.page, "editXmppUserSnippet" + id, true);
        editXmppUserSnippet.append((HtmlItem)editXmppUserTable, null);
        editXmppUserSnippet.append((OgemaWidget)confirmXmppChangesButton, null);
        editXmppUserPopup.setBody((OgemaWidgetBase)editXmppUserSnippet, null);
        ButtonConfirm deleteXmppUserButton = new ButtonConfirm(this.page, "deleteXmppUserButton_" + id){

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                config.delete();
                XmppTemplate.this.table.removeRow(id, req);
                XmppTemplate.this.alert.showAlert("User '" + id + "' successfully deleted", true, req);
            }
        };
        deleteXmppUserButton.addDefaultStyle(ButtonData.BOOTSTRAP_RED);
        deleteXmppUserButton.setDefaultText("Delete");
        deleteXmppUserButton.setDefaultConfirmPopupTitle("Delete xmpp-user: " + id);
        deleteXmppUserButton.setDefaultConfirmMsg("Do you really want to delete '" + id + "' from your list ?");
        deleteXmppUserButton.triggerAction(this.table, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        deleteXmppUserButton.triggerAction((OgemaWidget)this.alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        row.addCell("deleteXmppColumn", (Object)deleteXmppUserButton);
        return row;
    }
}

