/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.messaging.basic.services.config;

import de.iwes.widgets.api.OgemaGuiService;
import de.iwes.widgets.api.widgets.WidgetApp;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.navigation.MenuConfiguration;
import de.iwes.widgets.api.widgets.navigation.NavigationMenu;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.logging.OgemaLogger;
import org.ogema.core.resourcemanager.ResourceAccess;
import org.ogema.core.resourcemanager.ResourceDemandListener;
import org.ogema.messaging.basic.services.config.ReceiverPageBuilder;
import org.ogema.messaging.basic.services.config.SenderPageBuilder;
import org.ogema.messaging.basic.services.config.localisation.MessageSettingsDictionary;
import org.ogema.messaging.basic.services.config.localisation.MessageSettingsDictionary_de;
import org.ogema.messaging.basic.services.config.localisation.MessageSettingsDictionary_en;
import org.ogema.messaging.basic.services.config.model.EmailConfiguration;
import org.ogema.messaging.basic.services.config.model.ReceiverConfiguration;
import org.ogema.messaging.basic.services.config.model.SmsConfiguration;
import org.ogema.messaging.basic.services.config.model.XmppConfiguration;

@Component(specVersion="1.2")
@Service(value={Application.class})
public class MessageSettings
implements Application {
    private OgemaLogger logger;
    private WidgetApp wApp;
    private ResourceAccess resAcc;
    private SenderPageBuilder senderPageBuilder;
    private ReceiverPageBuilder receiverPageBuilder;
    @Reference
    private OgemaGuiService guiService;

    public void start(ApplicationManager appManager) {
        this.resAcc = appManager.getResourceAccess();
        this.logger = appManager.getLogger();
        this.logger.debug("{} started", (Object)this.getClass().getName());
        this.wApp = this.guiService.createWidgetApp("/de/iwes/ogema/apps/messageSettings", appManager);
        WidgetPage senderPage = this.wApp.createWidgetPage("sender.html");
        senderPage.registerLocalisation(MessageSettingsDictionary_de.class).registerLocalisation(MessageSettingsDictionary_en.class);
        this.senderPageBuilder = new SenderPageBuilder((WidgetPage<MessageSettingsDictionary>)senderPage, appManager);
        WidgetPage receiverPage = this.wApp.createStartPage();
        receiverPage.registerLocalisation(MessageSettingsDictionary_de.class).registerLocalisation(MessageSettingsDictionary_en.class);
        this.receiverPageBuilder = new ReceiverPageBuilder((WidgetPage<MessageSettingsDictionary>)receiverPage, appManager);
        this.resAcc.addResourceDemand(EmailConfiguration.class, this.senderPageBuilder.getEmailListener());
        this.resAcc.addResourceDemand(SmsConfiguration.class, this.senderPageBuilder.getSmsListener());
        this.resAcc.addResourceDemand(XmppConfiguration.class, this.senderPageBuilder.getXmppListener());
        this.resAcc.addResourceDemand(ReceiverConfiguration.class, (ResourceDemandListener)this.receiverPageBuilder);
        NavigationMenu nm = new NavigationMenu(" Select page");
        nm.addEntry("Edit senders", senderPage);
        nm.addEntry("Edit receivers", receiverPage);
        MenuConfiguration mc = receiverPage.getMenuConfiguration();
        mc.setCustomNavigation(nm);
        mc = senderPage.getMenuConfiguration();
        mc.setCustomNavigation(nm);
    }

    public void stop(Application.AppStopReason reason) {
        if (this.wApp != null) {
            this.wApp.close();
        }
        if (this.resAcc != null && this.senderPageBuilder != null) {
            this.resAcc.removeResourceDemand(EmailConfiguration.class, this.senderPageBuilder.getEmailListener());
            this.resAcc.removeResourceDemand(SmsConfiguration.class, this.senderPageBuilder.getSmsListener());
            this.resAcc.removeResourceDemand(XmppConfiguration.class, this.senderPageBuilder.getXmppListener());
        }
        if (this.resAcc != null && this.receiverPageBuilder != null) {
            this.resAcc.removeResourceDemand(ReceiverConfiguration.class, (ResourceDemandListener)this.receiverPageBuilder);
        }
        this.logger = null;
        this.wApp = null;
        this.resAcc = null;
        this.receiverPageBuilder = null;
        this.senderPageBuilder = null;
    }

    protected void bindGuiService(OgemaGuiService ogemaGuiService) {
        this.guiService = ogemaGuiService;
    }

    protected void unbindGuiService(OgemaGuiService ogemaGuiService) {
        if (this.guiService == ogemaGuiService) {
            this.guiService = null;
        }
    }
}

