/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.messaging.basic.services.config.template;

import de.iwes.widgets.api.extended.OgemaWidgetBase;
import de.iwes.widgets.api.extended.html.bricks.PageSnippet;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.dynamics.TriggeredAction;
import de.iwes.widgets.api.widgets.dynamics.TriggeringAction;
import de.iwes.widgets.api.widgets.html.HtmlItem;
import de.iwes.widgets.api.widgets.html.StaticTable;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.alert.Alert;
import de.iwes.widgets.html.buttonconfirm.ButtonConfirm;
import de.iwes.widgets.html.complextable.DynamicTable;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.html.form.button.Button;
import de.iwes.widgets.html.form.button.ButtonData;
import de.iwes.widgets.html.form.label.Label;
import de.iwes.widgets.html.form.textfield.TextField;
import de.iwes.widgets.html.popup.Popup;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.logging.OgemaLogger;
import org.ogema.core.model.ResourceList;
import org.ogema.core.resourcemanager.ResourceAccess;
import org.ogema.core.resourcemanager.ResourceManagement;
import org.ogema.messaging.basic.services.config.model.EmailConfiguration;
import org.ogema.tools.resource.util.ResourceUtils;

public class EmailTemplate
extends RowTemplate<EmailConfiguration> {
    protected final ResourceList<EmailConfiguration> list;
    protected final DynamicTable<EmailConfiguration> table;
    protected final Alert alert;
    protected final WidgetPage<?> page;
    protected final ApplicationManager am;
    protected final OgemaLogger logger;
    protected final ResourceAccess ra;
    protected final ResourceManagement resMan;

    public EmailTemplate(ResourceList<EmailConfiguration> list, ApplicationManager am, DynamicTable<EmailConfiguration> table, Alert alert, WidgetPage<?> page) {
        this.list = list;
        this.table = table;
        this.alert = alert;
        this.page = page;
        this.am = am;
        this.logger = am.getLogger();
        this.ra = am.getResourceAccess();
        this.resMan = am.getResourceManagement();
    }

    public Map<String, Object> getHeader() {
        LinkedHashMap<String, Object> emailHeader = new LinkedHashMap<String, Object>();
        emailHeader.put("nameColumn", "Name:");
        emailHeader.put("emailColumn", "Email-address:");
        emailHeader.put("passwordColumn", "Password:");
        emailHeader.put("serverColumn", "Server-URL: ");
        emailHeader.put("portColumn", "Port: ");
        emailHeader.put("editPopupColumn", "");
        emailHeader.put("editColumn", "");
        emailHeader.put("deleteColumn", "");
        return emailHeader;
    }

    public String getLineId(EmailConfiguration object) {
        return ResourceUtils.getValidResourceName((String)object.userName().getValue());
    }

    public RowTemplate.Row addRow(final EmailConfiguration config, OgemaHttpRequest req) {
        RowTemplate.Row row = new RowTemplate.Row();
        final String id = this.getLineId(config);
        Label nameLabel = new Label(this.page, "nameLabel_" + id, true);
        nameLabel.setDefaultText(config.userName().getValue());
        row.addCell("nameColumn", (Object)nameLabel);
        Label emailLabel = new Label(this.page, "emailLabel_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setText(config.email().getValue(), req);
            }
        };
        row.addCell("emailColumn", (Object)emailLabel);
        Label pwLabel = new Label(this.page, "pwLabel_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setText(config.password().getValue(), req);
            }
        };
        row.addCell("passwordColumn", (Object)pwLabel);
        Label serverLabel = new Label(this.page, "serverLabel_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setText(config.serverURL().getValue(), req);
            }
        };
        row.addCell("serverColumn", (Object)serverLabel);
        Label portLabel = new Label(this.page, "portLabel_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setText(String.valueOf(config.port().getValue()), req);
            }
        };
        portLabel.setDefaultText(String.valueOf(config.port().getValue()));
        row.addCell("portColumn", (Object)portLabel);
        config.activate(true);
        Label editNameLabel = new Label(this.page, "editNameLabel_" + id, true);
        editNameLabel.setDefaultText("Name: ");
        Label editEmailLabel = new Label(this.page, "editEmailLabel_" + id, true);
        editEmailLabel.setDefaultText("New email-address: ");
        Label editPwLabel = new Label(this.page, "editPwLabel_" + id, true);
        editPwLabel.setDefaultText("New password: ");
        Label editServerLabel = new Label(this.page, "editServerLabel_" + id, true);
        editServerLabel.setDefaultText("New server-URL: ");
        Label editPortLabel = new Label(this.page, "editPortLabel_" + id, true);
        editPortLabel.setDefaultText("New port: ");
        final TextField editEmailTextField = new TextField(this.page, "editEmailTextField_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setValue(config.email().getValue(), req);
            }
        };
        final TextField editPwTextField = new TextField(this.page, "editPwTextField_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setValue(config.password().getValue(), req);
            }
        };
        final TextField editServerTextField = new TextField(this.page, "editServerTextField_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setValue(config.serverURL().getValue(), req);
            }
        };
        final TextField editPortTextField = new TextField(this.page, "editPortTextField_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setValue(String.valueOf(config.port().getValue()), req);
            }
        };
        Popup editEmailUserPopup = new Popup(this.page, "editEmailUserPopup_" + id, true);
        editEmailUserPopup.setTitle("Edit user ", null);
        row.addCell("editEmailPopupColumn", (Object)editEmailUserPopup);
        Button editEmailUserButton = new Button(this.page, "editEmailUserButton" + id);
        editEmailUserButton.triggerAction((OgemaWidget)editEmailTextField, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        editEmailUserButton.triggerAction((OgemaWidget)editPwTextField, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        editEmailUserButton.triggerAction((OgemaWidget)editServerTextField, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        editEmailUserButton.triggerAction((OgemaWidget)editPortTextField, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        editEmailUserButton.triggerAction(this.table, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        editEmailUserButton.triggerAction((OgemaWidget)editEmailUserPopup, TriggeringAction.POST_REQUEST, TriggeredAction.SHOW_WIDGET);
        editEmailUserButton.addDefaultStyle(ButtonData.BOOTSTRAP_GREEN);
        editEmailUserButton.setDefaultText("Edit");
        row.addCell("editEmailColumn", (Object)editEmailUserButton);
        ButtonConfirm confirmEmailChangesButton = new ButtonConfirm(this.page, "confirmEmailChangesButton_" + id){

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                String emailRegex = "[A-Za-z0-9]+[A-Za-z0-9.-]*[@][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$";
                String serverRegex = "[A-Za-z0-9.-]+[.][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$";
                String portRegex = "[0-9]{1,5}$";
                String email = editEmailTextField.getValue(req);
                String server = editServerTextField.getValue(req);
                String serverPort = editPortTextField.getValue(req);
                String pw = editPwTextField.getValue(req);
                int port = 70000;
                if (serverPort.matches(portRegex)) {
                    port = Integer.parseInt(serverPort);
                }
                if (port <= 65535 && email.matches(emailRegex) && server.matches(serverRegex) && !pw.isEmpty()) {
                    config.email().setValue(email);
                    config.password().setValue(pw);
                    config.serverURL().setValue(server);
                    config.port().setValue(port);
                    EmailTemplate.this.alert.showAlert("Changes on user '" + id + "' confirmed", true, req);
                } else {
                    if (!email.matches(emailRegex)) {
                        EmailTemplate.this.alert.showAlert("Invalid email-address", false, req);
                    }
                    if (!server.matches(serverRegex)) {
                        EmailTemplate.this.alert.showAlert("Invalid server-URL", false, req);
                    }
                    if (port > 65535) {
                        EmailTemplate.this.alert.showAlert("Invalid port", false, req);
                    }
                    if (pw.isEmpty()) {
                        EmailTemplate.this.alert.showAlert("No password entered", false, req);
                    }
                }
            }
        };
        confirmEmailChangesButton.addDefaultStyle(ButtonData.BOOTSTRAP_GREEN);
        confirmEmailChangesButton.setDefaultText("Save changes");
        confirmEmailChangesButton.setDefaultConfirmPopupTitle("Edit " + id);
        confirmEmailChangesButton.setDefaultConfirmMsg("Accept changes ?");
        confirmEmailChangesButton.triggerAction((OgemaWidget)emailLabel, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmEmailChangesButton.triggerAction((OgemaWidget)pwLabel, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmEmailChangesButton.triggerAction((OgemaWidget)portLabel, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmEmailChangesButton.triggerAction((OgemaWidget)serverLabel, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmEmailChangesButton.triggerAction((OgemaWidget)editEmailUserPopup, TriggeringAction.POST_REQUEST, TriggeredAction.HIDE_WIDGET);
        confirmEmailChangesButton.triggerAction((OgemaWidget)this.alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        StaticTable editEmailUserTable = new StaticTable(5, 2);
        editEmailUserTable.setContent(0, 0, (OgemaWidget)editNameLabel);
        editEmailUserTable.setContent(1, 0, (OgemaWidget)editEmailLabel);
        editEmailUserTable.setContent(2, 0, (OgemaWidget)editPwLabel);
        editEmailUserTable.setContent(3, 0, (OgemaWidget)editServerLabel);
        editEmailUserTable.setContent(4, 0, (OgemaWidget)editPortLabel);
        editEmailUserTable.setContent(0, 1, config.userName().getValue());
        editEmailUserTable.setContent(1, 1, (OgemaWidget)editEmailTextField);
        editEmailUserTable.setContent(2, 1, (OgemaWidget)editPwTextField);
        editEmailUserTable.setContent(3, 1, (OgemaWidget)editServerTextField);
        editEmailUserTable.setContent(4, 1, (OgemaWidget)editPortTextField);
        PageSnippet editEmailUserSnippet = new PageSnippet(this.page, "editEmailUserSnippet" + id, true);
        editEmailUserSnippet.append((HtmlItem)editEmailUserTable, null);
        editEmailUserSnippet.append((OgemaWidget)confirmEmailChangesButton, null);
        editEmailUserPopup.setBody((OgemaWidgetBase)editEmailUserSnippet, null);
        ButtonConfirm deleteEmailUserButton = new ButtonConfirm(this.page, "deleteEmailUserButton_" + id){

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                config.delete();
                EmailTemplate.this.table.removeRow(id, req);
                EmailTemplate.this.alert.showAlert("User '" + id + "' successfully deleted", true, req);
            }
        };
        deleteEmailUserButton.addDefaultStyle(ButtonData.BOOTSTRAP_RED);
        deleteEmailUserButton.setDefaultText("Delete");
        deleteEmailUserButton.setDefaultConfirmPopupTitle("Delete email-user: " + id);
        deleteEmailUserButton.setDefaultConfirmMsg("Do you really want to delete '" + id + "' from your list ?");
        deleteEmailUserButton.triggerAction(this.table, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        deleteEmailUserButton.triggerAction((OgemaWidget)this.alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        row.addCell("deleteEmailColumn", (Object)deleteEmailUserButton);
        return row;
    }
}

