/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.apps.messaging.test;

import de.iwes.widgets.api.OgemaGuiService;
import de.iwes.widgets.api.services.MessagingService;
import de.iwes.widgets.api.widgets.WidgetApp;
import de.iwes.widgets.api.widgets.WidgetPage;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.ogema.apps.messaging.test.PageBuilder;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.logging.OgemaLogger;

@Component(specVersion="1.2", immediate=true)
@Service(value={Application.class})
public class MessagingTestApp
implements Application {
    private ApplicationManager am;
    private OgemaLogger logger;
    private WidgetApp wApp;
    private MessagingService ms;
    @Reference
    private OgemaGuiService guiService;

    public void start(ApplicationManager am) {
        this.am = am;
        this.logger = am.getLogger();
        this.ms = this.guiService.getMessagingService();
        this.ms.registerMessagingApp(am.getAppID(), "Messaging test app");
        this.wApp = this.guiService.createWidgetApp("/de/iwes/messaging/test", am);
        WidgetPage page = this.wApp.createStartPage();
        PageBuilder pb = new PageBuilder(page, this.ms, am);
    }

    public void stop(Application.AppStopReason reason) {
        if (this.wApp != null) {
            this.wApp.close();
        }
        this.wApp = null;
        if (this.ms != null) {
            this.ms.unregisterMessagingApp(this.am.getAppID());
        }
        if (this.logger != null) {
            this.logger.info("{} being stopped.", (Object)this.getClass().getName());
        }
        this.logger = null;
        this.am = null;
        this.ms = null;
    }

    protected void bindGuiService(OgemaGuiService ogemaGuiService) {
        this.guiService = ogemaGuiService;
    }

    protected void unbindGuiService(OgemaGuiService ogemaGuiService) {
        if (this.guiService == ogemaGuiService) {
            this.guiService = null;
        }
    }
}

