/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.widgets.pushover.service.impl;

import de.iwes.widgets.api.extended.WidgetData;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.dynamics.TriggeredAction;
import de.iwes.widgets.api.widgets.dynamics.TriggeringAction;
import de.iwes.widgets.api.widgets.html.HtmlItem;
import de.iwes.widgets.api.widgets.html.StaticTable;
import de.iwes.widgets.api.widgets.localisation.OgemaLocale;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.alert.Alert;
import de.iwes.widgets.html.complextable.DynamicTable;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.html.form.button.Button;
import de.iwes.widgets.html.form.dropdown.TemplateDropdown;
import de.iwes.widgets.html.form.label.Header;
import de.iwes.widgets.html.form.textfield.TextField;
import de.iwes.widgets.template.DisplayTemplate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.ogema.core.model.Resource;
import org.ogema.core.model.ResourceList;
import org.ogema.core.model.simple.StringResource;
import org.ogema.tools.resource.util.ResourceUtils;
import org.ogema.widgets.pushover.model.PushoverConfiguration;

public class ConfigPage {
    private final WidgetPage<?> page;
    private final Header header;
    private final Alert alert;
    private final TextField newSenderField;
    private final TextField newReceiverField;
    private final Button newSenderTrigger;
    private final Button newReceiverTrigger;
    private final TemplateDropdown<StringResource> senderSelector;
    private final Header sendersHeader;
    private final Header receiversHeader;
    private final PushoverConfigTable senders;
    private final PushoverConfigTable receivers;

    public ConfigPage(WidgetPage<?> page, final PushoverConfiguration config) {
        this.page = page;
        this.header = new Header(page, "header", true);
        this.header.setDefaultText("Pushover connector configuration");
        this.header.setDefaultColor("blue");
        this.header.addDefaultStyle(WidgetData.TEXT_ALIGNMENT_CENTERED);
        this.alert = new Alert(page, "alert", "");
        this.alert.setDefaultVisibility(false);
        this.newSenderField = new TextField(page, "newsenderField");
        this.newReceiverField = new TextField(page, "newReceiverFiedl");
        this.newSenderTrigger = new Button(page, "newSenderTrigger", "Create"){
            private static final long serialVersionUID = 1L;

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                String sender = ConfigPage.this.newSenderField.getValue(req);
                if (sender == null || sender.trim().length() < 5) {
                    ConfigPage.this.alert.showAlert("Invalid sender id " + sender, false, req);
                    return;
                }
                sender = sender.trim();
                if (ConfigPage.isStringContained((ResourceList<StringResource>)config.userTokens(), sender)) {
                    ConfigPage.this.alert.showAlert("Sender id already exists: " + sender, false, req);
                    return;
                }
                StringResource res = ConfigPage.addEntry((ResourceList<StringResource>)config.userTokens(), sender);
                if (config.userTokens().size() == 1) {
                    res.activate(false);
                }
            }
        };
        this.newReceiverTrigger = new Button(page, "newReceiverTrigger", "Create"){
            private static final long serialVersionUID = 1L;

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                String receiver = ConfigPage.this.newReceiverField.getValue(req);
                if (receiver == null || receiver.trim().length() < 5) {
                    ConfigPage.this.alert.showAlert("Invalid receiver id " + receiver, false, req);
                    return;
                }
                receiver = receiver.trim();
                if (ConfigPage.isStringContained((ResourceList<StringResource>)config.applicationTokens(), receiver)) {
                    ConfigPage.this.alert.showAlert("Receiver id already exists: " + receiver, false, req);
                    return;
                }
                StringResource res = ConfigPage.addEntry((ResourceList<StringResource>)config.applicationTokens(), receiver);
                res.activate(false);
            }
        };
        this.senderSelector = new TemplateDropdown<StringResource>(page, "senderSelector"){
            private static final long serialVersionUID = 1L;

            public void onGET(OgemaHttpRequest req) {
                List senders = config.userTokens().getAllElements();
                this.update(senders, req);
                for (StringResource s : senders) {
                    if (!s.isActive()) continue;
                    this.selectItem(s, req);
                    break;
                }
            }

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                StringResource str = (StringResource)this.getSelectedItem(req);
                str.activate(false);
                for (StringResource s : config.userTokens().getAllElements()) {
                    if (s.equalsLocation((Resource)str)) continue;
                    s.deactivate(false);
                }
            }
        };
        this.senderSelector.setTemplate((DisplayTemplate)new DisplayTemplate<StringResource>(){

            public String getLabel(StringResource object, OgemaLocale locale) {
                return object.getValue();
            }

            public String getId(StringResource object) {
                return object.getValue();
            }
        });
        this.sendersHeader = new Header(page, "sendersHeader", true);
        this.sendersHeader.setDefaultHeaderType(3);
        this.sendersHeader.setDefaultText("Senders");
        this.sendersHeader.setDefaultColor("blue");
        this.sendersHeader.addDefaultStyle(WidgetData.TEXT_ALIGNMENT_CENTERED);
        this.senders = new PushoverConfigTable(page, "sendersTable", config.userTokens());
        this.senders.addDefaultStyle(WidgetData.TEXT_ALIGNMENT_CENTERED);
        this.receiversHeader = new Header(page, "receiversHeader", true);
        this.receiversHeader.setDefaultHeaderType(3);
        this.receiversHeader.setDefaultText("Receivers");
        this.receiversHeader.setDefaultColor("blue");
        this.receiversHeader.addDefaultStyle(WidgetData.TEXT_ALIGNMENT_CENTERED);
        this.receivers = new PushoverConfigTable(page, "receiverTable", config.applicationTokens());
        this.receivers.addDefaultStyle(WidgetData.TEXT_ALIGNMENT_CENTERED);
        this.buildPage();
        this.setDependencies();
    }

    private final void buildPage() {
        this.page.append((OgemaWidget)this.header).linebreak().append((OgemaWidget)this.alert);
        int row = 0;
        StaticTable tab = new StaticTable(3, 3, new int[]{2, 2, 2}).setContent(row, 0, "New receiver (pushover application token)").setContent(row, 1, (OgemaWidget)this.newReceiverField).setContent(row++, 2, (OgemaWidget)this.newReceiverTrigger).setContent(row, 0, "New sender (pushover user token)").setContent(row, 1, (OgemaWidget)this.newSenderField).setContent(row++, 2, (OgemaWidget)this.newSenderTrigger).setContent(row, 0, "Senders").setContent(row++, 1, this.senderSelector);
        this.page.append((HtmlItem)tab).linebreak();
        row = 0;
        StaticTable existingTables = new StaticTable(3, 2, new int[]{6, 6}).setContent(row, 0, (OgemaWidget)this.sendersHeader).setContent(row++, 1, (OgemaWidget)this.receiversHeader).setContent(row, 0, (OgemaWidget)this.senders).setContent(row++, 1, (OgemaWidget)this.receivers);
        this.page.append((HtmlItem)existingTables);
    }

    private final void setDependencies() {
        this.newReceiverTrigger.triggerAction((OgemaWidget)this.newReceiverField, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        this.newReceiverTrigger.triggerAction((OgemaWidget)this.receivers, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        this.newSenderTrigger.triggerAction((OgemaWidget)this.newSenderField, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        this.newReceiverTrigger.triggerAction((OgemaWidget)this.alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        this.newSenderTrigger.triggerAction((OgemaWidget)this.alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        this.newSenderTrigger.triggerAction(this.senderSelector, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        this.newSenderTrigger.triggerAction((OgemaWidget)this.senders, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
    }

    private static final boolean isStringContained(ResourceList<StringResource> list, String string) {
        for (StringResource r : list.getAllElements()) {
            if (!string.equals(r.getValue())) continue;
            return true;
        }
        return false;
    }

    private static final StringResource addEntry(ResourceList<StringResource> list, String string) {
        StringResource newR = (StringResource)list.add();
        newR.setValue(string);
        return newR;
    }

    private static class PushoverConfigTable
    extends DynamicTable<StringResource> {
        private final ResourceList<StringResource> configurations;
        private final Semaphore sema = new Semaphore(1);

        public PushoverConfigTable(WidgetPage<?> page, String id, ResourceList<StringResource> configurations) {
            super(page, id, true);
            this.configurations = configurations;
            this.setRowTemplate(new PushoverConfigRowTemplate(page, this));
        }

        public void onGET(OgemaHttpRequest req) {
            if (!this.sema.tryAcquire()) {
                return;
            }
            try {
                this.updateRows(this.configurations.getAllElements(), req);
            }
            finally {
                this.sema.release();
            }
        }
    }

    private static class PushoverConfigRowTemplate
    extends RowTemplate<StringResource> {
        static final Map<String, Object> header = new LinkedHashMap<String, Object>();
        private final WidgetPage<?> page;
        private final DynamicTable<?> table;

        public PushoverConfigRowTemplate(WidgetPage<?> page, DynamicTable<?> table) {
            this.page = page;
            this.table = table;
        }

        public RowTemplate.Row addRow(StringResource object, OgemaHttpRequest req) {
            RowTemplate.Row row = new RowTemplate.Row();
            row.addCell("id", (Object)object.getValue());
            DeleteButton btn = new DeleteButton(this.page, "deleteBtn_" + ResourceUtils.getValidResourceName((String)object.getValue()), object);
            row.addCell("delete", (Object)btn);
            btn.triggerAction((OgemaWidget)this.table, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
            return row;
        }

        public String getLineId(StringResource object) {
            return object.getValue();
        }

        public Map<String, Object> getHeader() {
            return header;
        }

        static {
            header.put("id", "Id");
            header.put("delete", "Delete");
        }
    }

    private static class DeleteButton
    extends Button {
        private static final long serialVersionUID = 1L;
        final StringResource target;

        public DeleteButton(WidgetPage<?> page, String id, StringResource target) {
            super(page, id, "Delete");
            this.target = target;
        }

        public void onPOSTComplete(String data, OgemaHttpRequest req) {
            this.target.delete();
        }
    }
}

