/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.widgets.pushover.service.impl;

import de.iwes.widgets.api.OgemaGuiService;
import de.iwes.widgets.api.messaging.listener.MessageListener;
import de.iwes.widgets.api.messaging.listener.ReceivedMessage;
import de.iwes.widgets.api.widgets.WidgetApp;
import de.iwes.widgets.api.widgets.localisation.OgemaLocale;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.fluent.Request;
import org.apache.http.message.BasicNameValuePair;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.simple.StringResource;
import org.ogema.widgets.pushover.model.PushoverConfiguration;
import org.ogema.widgets.pushover.service.impl.ConfigPage;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;

@Component(specVersion="1.2")
@Service(value={Application.class})
public class PushoverService
implements Application,
MessageListener {
    private static final String TARGET_URI = "https://api.pushover.net/1/messages.json";
    private volatile BundleContext ctx;
    private volatile ServiceRegistration<MessageListener> sreg;
    private volatile PushoverConfiguration config;
    private volatile Logger logger;
    private WidgetApp wapp;
    @Reference
    private OgemaGuiService widgetService;

    @Activate
    protected void start(BundleContext ctx) {
        this.ctx = ctx;
    }

    @Deactivate
    protected void stop() {
        this.ctx = null;
    }

    public void start(ApplicationManager appManager) {
        this.sreg = this.ctx.registerService(MessageListener.class, (Object)this, null);
        this.config = (PushoverConfiguration)appManager.getResourceManagement().createResource("pushoverConfiguration", PushoverConfiguration.class);
        this.config.userTokens().create();
        this.config.applicationTokens().create();
        this.logger = appManager.getLogger();
        this.wapp = this.widgetService.createWidgetApp("/de/iwes/messaging/pushover/config", appManager);
        new ConfigPage(this.wapp.createStartPage(), this.config);
    }

    public void stop(Application.AppStopReason reason) {
        ServiceRegistration<MessageListener> sreg = this.sreg;
        if (sreg != null) {
            sreg.unregister();
        }
        if (this.wapp != null) {
            this.wapp.close();
        }
        this.wapp = null;
        this.sreg = null;
        this.config = null;
        this.logger = null;
    }

    public String getId() {
        return "Pushover";
    }

    public String getDescription(OgemaLocale locale) {
        return "Forward messages through the Pushover app.";
    }

    public void newMessageAvailable(ReceivedMessage message, List<String> recipients) {
        HttpResponse response;
        URI uri;
        this.logger.trace("New message from {}, to {}", (Object)message.getAppName(), recipients);
        ArrayList<String> receivers = new ArrayList<String>(recipients);
        receivers.retainAll(this.getKnownUsers());
        if (receivers.isEmpty()) {
            this.logger.info("No recipient found; original list: " + recipients);
            return;
        }
        List senders = this.config.userTokens().getAllElements();
        String sender = null;
        for (StringResource s : senders) {
            String str;
            if (!s.isActive() || (str = s.getValue().trim()).isEmpty()) continue;
            sender = str;
            break;
        }
        if (sender == null) {
            this.logger.warn("No sender found, could not forward message");
            return;
        }
        try {
            uri = new URI(TARGET_URI);
        }
        catch (URISyntaxException e) {
            this.logger.error("Unexpected exception:", (Throwable)e);
            return;
        }
        final ArrayList<BasicNameValuePair> bodyEntries = new ArrayList<BasicNameValuePair>();
        bodyEntries.add(new BasicNameValuePair("token", (String)receivers.iterator().next()));
        bodyEntries.add(new BasicNameValuePair("user", sender));
        bodyEntries.add(new BasicNameValuePair("message", message.getOriginalMessage().message(OgemaLocale.ENGLISH)));
        String title = message.getOriginalMessage().title(OgemaLocale.ENGLISH);
        if (title != null && !(title = title.trim()).isEmpty()) {
            bodyEntries.add(new BasicNameValuePair("title", title));
        }
        try {
            response = AccessController.doPrivileged(new PrivilegedExceptionAction<HttpResponse>(){

                @Override
                public HttpResponse run() throws Exception {
                    return Request.Post((URI)uri).body((HttpEntity)new UrlEncodedFormEntity(bodyEntries, "UTF-8")).execute().returnResponse();
                }
            });
        }
        catch (RuntimeException | PrivilegedActionException e) {
            Exception cause = e instanceof RuntimeException ? e : (Exception)e.getCause();
            this.logger.warn("Error sending message", (Throwable)cause);
            return;
        }
        StatusLine status = response.getStatusLine();
        int code = status.getStatusCode();
        if (code >= 400) {
            this.logger.warn("Message sending failed. Response: {}", (Object)status);
        } else {
            this.logger.debug("Message sent successfully. Response: {}", (Object)code);
        }
    }

    public List<String> getKnownUsers() {
        PushoverConfiguration config = this.config;
        if (config == null) {
            return Collections.emptyList();
        }
        ArrayList<String> users = new ArrayList<String>();
        for (StringResource app : config.applicationTokens().getAllElements()) {
            if (!app.isActive()) continue;
            users.add(app.getValue());
        }
        return users;
    }

    protected void bindWidgetService(OgemaGuiService ogemaGuiService) {
        this.widgetService = ogemaGuiService;
    }

    protected void unbindWidgetService(OgemaGuiService ogemaGuiService) {
        if (this.widgetService == ogemaGuiService) {
            this.widgetService = null;
        }
    }
}

