/*
 * Decompiled with CFR 0.152.
 */
package de.iee.sema.remote.user.administration;

import de.iee.sema.remote.user.administration.CreatePageInit;
import de.iwes.widgets.api.extended.OgemaWidgetBase;
import de.iwes.widgets.api.extended.html.bricks.PageSnippet;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.dynamics.TriggeredAction;
import de.iwes.widgets.api.widgets.dynamics.TriggeringAction;
import de.iwes.widgets.api.widgets.html.HtmlItem;
import de.iwes.widgets.api.widgets.html.StaticTable;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.alert.Alert;
import de.iwes.widgets.html.buttonconfirm.ButtonConfirm;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.html.form.button.Button;
import de.iwes.widgets.html.form.checkbox.Checkbox2;
import de.iwes.widgets.html.form.checkbox.DefaultCheckboxEntry;
import de.iwes.widgets.html.form.label.Header;
import de.iwes.widgets.html.form.label.Label;
import de.iwes.widgets.html.form.textfield.TextField;
import de.iwes.widgets.html.form.textfield.TextFieldType;
import de.iwes.widgets.html.html5.Flexbox;
import de.iwes.widgets.html.html5.SimpleGrid;
import de.iwes.widgets.html.html5.TemplateGrid;
import de.iwes.widgets.html.html5.flexbox.AlignContent;
import de.iwes.widgets.html.html5.grid.AlignItems;
import de.iwes.widgets.html.popup.Popup;
import de.iwes.widgets.html.textarea.TextArea;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ogema.accesscontrol.PermissionManager;
import org.ogema.core.application.ApplicationManager;
import org.ogema.tools.resource.util.ResourceUtils;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionUpdate;
import org.osgi.service.permissionadmin.PermissionInfo;

class EditPageInit {
    private final WidgetPage<?> page;
    private final Header header;
    private final Alert alert;
    private final Flexbox filterFlex;
    private final Label filterLabel;
    private final Header userHeader;
    private final TextField userFilter;
    private final TemplateGrid<String> usersTable;
    private final Popup copyPopup;
    private final TextField copyId;
    private final TextField copyPw;
    private final TextArea copyPerms;
    private final Checkbox2 copyNatural;
    private final Button copyUserSubmit;
    private final Popup editPopup;
    private final Label editUserName;
    private final TextArea editPerms;
    private final Button editUserSubmit;
    private final Header furtherPermsHeader;
    private final SimpleGrid furtherPerms;

    EditPageInit(final WidgetPage<?> page, final ApplicationManager appMan, final PermissionManager permMan, final ConditionalPermissionAdmin cpa) {
        this.page = page;
        this.header = new Header(page, "header", "User Permission Administation");
        this.header.setDefaultColor("blue");
        this.alert = new Alert(page, "alert", "");
        this.alert.setDefaultVisibility(false);
        this.userHeader = new Header(page, "userHeader", "User-specific permissions");
        this.userHeader.setDefaultColor("blue");
        this.filterLabel = new Label(page, "filterLabel");
        this.filterLabel.setDefaultText("Filter users:");
        this.userFilter = new TextField(page, "userFilter");
        this.filterFlex = new Flexbox(page, "filterFlxe", true);
        this.filterFlex.addItem((OgemaWidget)this.filterLabel, null).addItem((OgemaWidget)this.userFilter, null);
        this.filterFlex.setDefaultAlignContent(AlignContent.FLEX_LEFT);
        this.userFilter.setDefaultMargin("1em", false, true, false, false);
        RowTemplate<String> usersTemplate = new RowTemplate<String>(){
            private final Map<String, Object> header;
            {
                LinkedHashMap<String, String> headerLocal = new LinkedHashMap<String, String>();
                headerLocal.put("user", "User");
                headerLocal.put("natural", "User type");
                headerLocal.put("perms", "Permissions");
                headerLocal.put("edit", "Edit");
                headerLocal.put("copy", "Copy");
                headerLocal.put("delete", "Delete");
                this.header = Collections.unmodifiableMap(headerLocal);
            }

            public String getLineId(String object) {
                return ResourceUtils.getValidResourceName((String)object);
            }

            public Map<String, Object> getHeader() {
                return this.header;
            }

            public RowTemplate.Row addRow(final String user, OgemaHttpRequest req) {
                RowTemplate.Row row = new RowTemplate.Row();
                String lineId = this.getLineId(user);
                row.addCell("user", (Object)user);
                Label nat = new Label((OgemaWidget)EditPageInit.this.usersTable, "natural_" + lineId, req){

                    public void onGET(OgemaHttpRequest req) {
                        boolean natural = permMan.getAccessManager().isNatural(user);
                        this.setText(natural ? "natural" : "machine", req);
                    }
                };
                row.addCell("natural", (Object)nat);
                final Label lab = new Label((OgemaWidget)EditPageInit.this.usersTable, "perms_" + lineId, req){

                    public void onGET(OgemaHttpRequest req) {
                        this.setHtml(cpa.newConditionalPermissionUpdate().getConditionalPermissionInfos().stream().filter(perm -> EditPageInit.appliesToSpecificUser(user, perm)).flatMap(perm -> Arrays.stream(perm.getPermissionInfos())).map(PermissionInfo::getEncoded).collect(Collectors.joining("<br>")), req);
                    }
                };
                row.addCell("perms", (Object)lab);
                Button editOpen = new Button((OgemaWidget)EditPageInit.this.usersTable, "editOpen_" + lineId, "Open dialog", req){

                    public void onPOSTComplete(String data, OgemaHttpRequest req) {
                        EditPageInit.this.editUserName.setText(user, req);
                        EditPageInit.this.editPerms.setText(Arrays.stream(lab.getText(req).split("<br>")).collect(Collectors.joining("\n")), req);
                    }
                };
                editOpen.triggerAction((OgemaWidget)EditPageInit.this.editPopup, TriggeringAction.POST_REQUEST, TriggeredAction.SHOW_WIDGET, req);
                editOpen.triggerAction((OgemaWidget)EditPageInit.this.editUserName, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST, req);
                editOpen.triggerAction((OgemaWidget)EditPageInit.this.editPerms, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST, req);
                row.addCell("edit", (Object)editOpen);
                Button copyOpen = new Button((OgemaWidget)EditPageInit.this.usersTable, "copyOpen_" + lineId, "Open dialog", req){

                    public void onPOSTComplete(String data, OgemaHttpRequest req) {
                        EditPageInit.this.copyId.setValue(user, req);
                        EditPageInit.this.copyPerms.setText(Arrays.stream(lab.getText(req).split("<br>")).collect(Collectors.joining("\n")), req);
                        EditPageInit.this.copyNatural.setCheckboxList(Collections.singletonList(new DefaultCheckboxEntry("natural", "", permMan.getAccessManager().isNatural(user))), req);
                        EditPageInit.this.copyPw.setValue("", req);
                    }
                };
                copyOpen.triggerAction((OgemaWidget)EditPageInit.this.copyPopup, TriggeringAction.POST_REQUEST, TriggeredAction.SHOW_WIDGET, req);
                copyOpen.triggerAction((OgemaWidget)EditPageInit.this.copyId, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST, req);
                copyOpen.triggerAction((OgemaWidget)EditPageInit.this.copyPerms, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST, req);
                copyOpen.triggerAction((OgemaWidget)EditPageInit.this.copyNatural, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST, req);
                row.addCell("copy", (Object)copyOpen);
                ButtonConfirm deleteButton = new ButtonConfirm(page, "deleteButton" + lineId, "", req){

                    public void onPOSTComplete(String s, OgemaHttpRequest req) {
                        this.uninstallPoliciesForUser(cpa);
                        appMan.getAdministrationManager().removeUserAccount(user);
                    }

                    private void uninstallPoliciesForUser(ConditionalPermissionAdmin cpa) {
                        boolean done = false;
                        while (!done) {
                            ConditionalPermissionUpdate cpu = cpa.newConditionalPermissionUpdate();
                            cpu.getConditionalPermissionInfos().removeIf(cpi -> EditPageInit.appliesToSpecificUser(user, cpi));
                            done = cpu.commit();
                        }
                    }
                };
                deleteButton.setDefaultText("Delete");
                deleteButton.setConfirmPopupTitle("Deleting " + user, req);
                deleteButton.setConfirmMsg("Do you really want to delete this user (" + user + ") with all permissions?", req);
                deleteButton.triggerAction((OgemaWidget)EditPageInit.this.usersTable, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST, req);
                row.addCell("delete", (Object)deleteButton);
                return row;
            }
        };
        this.usersTable = new TemplateGrid<String>(page, "usersTable", false, (RowTemplate)usersTemplate){

            public void onGET(OgemaHttpRequest req) {
                String filter = EditPageInit.this.userFilter.getValue(req).toLowerCase();
                this.update(permMan.getAccessManager().getAllUsers().stream().filter(user -> user.toLowerCase().startsWith(filter)).collect(Collectors.toList()), req);
            }
        };
        this.usersTable.setDefaultAppendFillColumn(true);
        this.usersTable.setDefaultAlignItems(AlignItems.CENTER);
        this.usersTable.setDefaultColumnGap("2em");
        this.usersTable.setDefaultRowGap("1em");
        this.furtherPermsHeader = new Header(page, "furtherPermsHeader", "Further user-related permissions");
        this.furtherPermsHeader.setDefaultHeaderType(2);
        this.furtherPermsHeader.setDefaultColor("blue");
        this.furtherPerms = new SimpleGrid(page, "furtherPerms", false){
            final AtomicInteger cnt;
            {
                super(x0, x1, x2);
                this.cnt = new AtomicInteger(0);
            }

            public void onGET(OgemaHttpRequest req) {
                this.clear(req);
                cpa.newConditionalPermissionUpdate().getConditionalPermissionInfos().stream().filter(x$0 -> EditPageInit.isNonSpecificUserPermission(x$0)).map(ConditionalPermissionInfo::getEncoded).map(str -> new Label((OgemaWidget)EditPageInit.this.furtherPerms, "fplab_" + this.cnt.getAndIncrement(), req, (String)str){
                    final /* synthetic */ String val$str;
                    {
                        this.val$str = string;
                        super(x0, x1, x2);
                    }

                    public void onGET(OgemaHttpRequest req) {
                        this.setHtml(this.val$str, req);
                    }
                }).forEach(w -> EditPageInit.this.furtherPerms.addItem((OgemaWidget)w, true, req));
            }
        };
        this.copyPopup = new Popup(page, "copyPopup", true);
        this.copyId = new TextField(page, "copyId");
        this.copyPw = new TextField(page, "copyPw");
        this.copyPw.setDefaultType(TextFieldType.PASSWORD);
        this.copyPw.setDefaultPlaceholder("Like user id");
        this.copyPerms = new TextArea(page, "copyPerms");
        this.copyPerms.setDefaultWidth("90%");
        this.copyPerms.setDefaultRows(10);
        this.copyPerms.setDefaultSendValueOnChange(true);
        this.copyNatural = new Checkbox2(page, "copyNatural");
        this.copyNatural.setDefaultCheckboxList(Collections.singletonList(new DefaultCheckboxEntry("natural", "", false)));
        this.copyUserSubmit = new Button(page, "copyUserSubmit", "Create user"){

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                String id = EditPageInit.this.copyId.getValue(req);
                if (id == null || id.isEmpty()) {
                    EditPageInit.this.alert.showAlert("Please enter a user id", false, req);
                    return;
                }
                if (permMan.getAccessManager().getRole(id) != null) {
                    EditPageInit.this.alert.showAlert("User " + id + " already exists", false, req);
                    return;
                }
                String pw = EditPageInit.this.copyPw.getValue(req);
                if (pw == null || pw.isEmpty()) {
                    pw = id;
                }
                boolean natural = EditPageInit.this.copyNatural.isChecked("natural", req);
                boolean created = permMan.getAccessManager().createUser(id, pw, natural);
                if (!created) {
                    EditPageInit.this.alert.showAlert("Unknown error", false, req);
                    return;
                }
                try {
                    List<String> policyNames = CreatePageInit.getPolicyNames(cpa);
                    String policyID = EditPageInit.getValidPolicyID(policyNames, id);
                    StringBuilder sb = new StringBuilder();
                    sb.append("allow").append(" { [org.osgi.service.condpermadmin.BundleLocationCondition \"urp:").append(id).append("\"]");
                    try (BufferedReader reader = new BufferedReader(new StringReader(EditPageInit.this.copyPerms.getText(req)));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if (CreatePageInit.isEmptyOrCommentLine(line = line.trim())) continue;
                            sb.append(line);
                        }
                    }
                    sb.append('}').append(' ').append(policyID);
                    CreatePageInit.installPolicies(Stream.of(sb.toString()), cpa);
                    EditPageInit.this.alert.showAlert("New user created: " + id + " (" + (natural ? "natural" : "machine") + " user)", true, req);
                }
                catch (Exception e) {
                    EditPageInit.this.alert.showAlert("An error occured: " + e, false, req);
                }
            }
        };
        int row = 0;
        StaticTable copyTable = new StaticTable(4, 2, new int[]{3, 9});
        copyTable.setContent(row, 0, "User").setContent(row++, 1, (OgemaWidget)this.copyId).setContent(row, 0, "Password").setContent(row++, 1, (OgemaWidget)this.copyPw).setContent(row, 0, "Natural user?").setContent(row++, 1, (OgemaWidget)this.copyNatural).setContent(row, 0, "Permissions").setContent(row++, 1, (OgemaWidget)this.copyPerms);
        PageSnippet bodySnippet = new PageSnippet(page, "copyPopupBody", true);
        bodySnippet.append((HtmlItem)copyTable, null);
        this.copyPopup.setBody((OgemaWidgetBase)bodySnippet, null);
        this.copyPopup.setHeader("Copy user", null);
        this.copyPopup.setFooter((OgemaWidgetBase)this.copyUserSubmit, null);
        this.copyPopup.setWidth("80vw", null);
        this.editPopup = new Popup(page, "editPopup", true);
        this.editUserName = new Label(page, "editUserName");
        this.editPerms = new TextArea(page, "editPerms");
        this.editPerms.setDefaultWidth("90%");
        this.editPerms.setDefaultRows(10);
        this.editUserSubmit = new Button(page, "editUserSubmit", "Save changes"){

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                String user = EditPageInit.this.editUserName.getText(req);
                if (user == null || user.isEmpty()) {
                    return;
                }
                ConditionalPermissionUpdate cpu = cpa.newConditionalPermissionUpdate();
                List infos = cpu.getConditionalPermissionInfos();
                Iterator it = infos.iterator();
                while (it.hasNext()) {
                    if (!EditPageInit.appliesToSpecificUser(user, (ConditionalPermissionInfo)it.next())) continue;
                    it.remove();
                }
                String perms = EditPageInit.this.editPerms.getText(req).trim();
                if (!perms.isEmpty()) {
                    ConditionalPermissionInfo cpi;
                    List<String> policyNames = CreatePageInit.getPolicyNames(cpa);
                    String policyID = EditPageInit.getValidPolicyID(policyNames, user);
                    StringBuilder sb = new StringBuilder();
                    sb.append("allow").append(" { [org.osgi.service.condpermadmin.BundleLocationCondition \"urp:").append(user).append("\"]");
                    try (BufferedReader reader = new BufferedReader(new StringReader(perms));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if (CreatePageInit.isEmptyOrCommentLine(line = line.trim())) continue;
                            sb.append(line);
                        }
                    }
                    catch (IOException e) {
                        EditPageInit.this.alert.showAlert("Error: " + e, false, req);
                        return;
                    }
                    sb.append('}').append(' ').append(policyID);
                    try {
                        cpi = cpa.newConditionalPermissionInfo(sb.toString());
                    }
                    catch (IllegalArgumentException e) {
                        EditPageInit.this.alert.showAlert("Permission format invalid", false, req);
                        return;
                    }
                    infos.add(cpi);
                }
                if (cpu.commit()) {
                    EditPageInit.this.alert.showAlert("Permissions edited", true, req);
                } else {
                    EditPageInit.this.alert.showAlert("Commit failed", false, req);
                }
            }
        };
        row = 0;
        StaticTable editTable = new StaticTable(2, 2, new int[]{3, 9});
        editTable.setContent(row, 0, "User").setContent(row++, 1, (OgemaWidget)this.editUserName).setContent(row, 0, "Permissions").setContent(row++, 1, (OgemaWidget)this.editPerms);
        PageSnippet editBodySnippet = new PageSnippet(page, "editPopupBody", true);
        editBodySnippet.append((HtmlItem)editTable, null);
        this.editPopup.setBody((OgemaWidgetBase)editBodySnippet, null);
        this.editPopup.setHeader("Edit user", null);
        this.editPopup.setFooter((OgemaWidgetBase)this.editUserSubmit, null);
        this.editPopup.setWidth("80vw", null);
        this.buildPage();
        this.setDependencies();
    }

    private final void buildPage() {
        this.page.append((OgemaWidget)this.header).linebreak().append((OgemaWidget)this.alert).append((OgemaWidget)this.userHeader).linebreak().append((OgemaWidget)this.filterFlex).linebreak().append(this.usersTable).linebreak().append((OgemaWidget)this.furtherPermsHeader).linebreak().append((OgemaWidget)this.furtherPerms).linebreak().append((OgemaWidget)this.copyPopup).linebreak().append((OgemaWidget)this.editPopup);
    }

    private final void setDependencies() {
        this.userFilter.triggerAction(this.usersTable, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        this.copyUserSubmit.triggerAction((OgemaWidget)this.copyPopup, TriggeringAction.POST_REQUEST, TriggeredAction.HIDE_WIDGET);
        this.copyUserSubmit.triggerAction((OgemaWidget)this.alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        this.copyUserSubmit.triggerAction(this.usersTable, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        this.editUserSubmit.triggerAction((OgemaWidget)this.editPopup, TriggeringAction.POST_REQUEST, TriggeredAction.HIDE_WIDGET);
        this.editUserSubmit.triggerAction((OgemaWidget)this.alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        this.editUserSubmit.triggerAction(this.usersTable, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
    }

    private static boolean appliesToSpecificUser(String user, ConditionalPermissionInfo cpi) {
        return Arrays.stream(cpi.getConditionInfos()).filter(cond -> cond.getEncoded().contains("org.osgi.service.condpermadmin.BundleLocationCondition")).filter(cond -> cond.getArgs().length > 0).filter(cond -> Arrays.stream(cond.getArgs()).filter(arg -> arg.equals("urp:" + user)).findAny().isPresent()).findAny().isPresent();
    }

    private static boolean isNonSpecificUserPermission(ConditionalPermissionInfo cpi) {
        return Arrays.stream(cpi.getConditionInfos()).filter(cond -> cond.getEncoded().contains("org.osgi.service.condpermadmin.BundleLocationCondition")).filter(cond -> cond.getArgs().length > 0).filter(cond -> Arrays.stream(cond.getArgs()).filter(arg -> arg.contains("urp:") && arg.contains("*")).findAny().isPresent()).findAny().isPresent();
    }

    private static Integer parseCounter(String name) {
        try {
            return Integer.parseInt(name);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String getValidPolicyID(List<String> policyNames, String id) {
        return id + "_" + (policyNames.stream().filter(name -> name.startsWith(id)).filter(name -> name.length() > id.length()).map(name -> name.substring(id.length())).map(EditPageInit::parseCounter).filter(Objects::nonNull).mapToInt(Integer::intValue).max().orElse(-1) + 1);
    }
}

