/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.messaging.telegram.connector;

import de.iwes.widgets.api.messaging.listener.MessageListener;
import de.iwes.widgets.api.messaging.listener.ReceivedMessage;
import de.iwes.widgets.api.widgets.localisation.OgemaLocale;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONArray;
import org.json.JSONObject;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.ResourceList;
import org.ogema.core.model.simple.StringResource;
import org.ogema.core.model.simple.TimeResource;
import org.ogema.messaging.telegram.connector.Constants;
import org.ogema.messaging.telegram.connector.TelegramContact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={MessageListener.class, Application.class})
public class TelegramConnectorApp
implements MessageListener,
Application {
    private static final String SEPARATOR = "___XXX___";
    private static final Logger logger = LoggerFactory.getLogger(TelegramConnectorApp.class);
    private volatile ResourceList<TelegramContact> contactList;
    private volatile long lastUpdate;

    public void start(ApplicationManager appManager) {
        if (Constants.BOT_KEY == null) {
            logger.error("API key not specified, going to sleep.");
            return;
        }
        this.contactList = (ResourceList)appManager.getResourceManagement().createResource("telegramContactList", ResourceList.class);
        this.contactList.setElementType(TelegramContact.class);
        this.contactList.activate(false);
        this.updateStatus();
    }

    public void stop(Application.AppStopReason reason) {
        this.contactList = null;
    }

    public String getId() {
        return "Telegram provider";
    }

    public String getDescription(OgemaLocale locale) {
        return "Telegram messaging";
    }

    public void newMessageAvailable(ReceivedMessage message, List<String> recipients) {
        if (System.currentTimeMillis() - this.lastUpdate > 15000L) {
            this.updateStatus();
        }
        for (String user : recipients) {
            this.sendToUser(message, user);
        }
    }

    private void updateStatus() {
        JSONObject response;
        String url = TelegramConnectorApp.getURL("getUpdates");
        if (url == null) {
            return;
        }
        HttpGet get = new HttpGet(TelegramConnectorApp.getURL("getUpdates"));
        try (CloseableHttpClient client = TelegramConnectorApp.getClient();
             CloseableHttpResponse resp = client.execute((HttpUriRequest)get);){
            StatusLine sl = resp.getStatusLine();
            if (logger.isDebugEnabled()) {
                logger.debug("Telegram message sent, {}: {}", (Object)sl.getStatusCode(), (Object)sl.getReasonPhrase());
            }
            if (sl.getStatusCode() >= 300) {
                logger.warn("Status code not ok, {}: {}", (Object)sl.getStatusCode(), (Object)sl.getReasonPhrase());
                return;
            }
            String text = null;
            try (Scanner scanner = new Scanner(resp.getEntity().getContent(), StandardCharsets.UTF_8.name());){
                text = scanner.useDelimiter("\\A").next();
            }
            logger.trace("Update response: {}", (Object)text);
            response = new JSONObject(text);
        }
        catch (IOException e) {
            logger.error("Telegram provider failed", (Throwable)e);
            return;
        }
        JSONArray arr = response.getJSONArray("result");
        this.parseMessages(arr);
        this.lastUpdate = System.currentTimeMillis();
    }

    private void sendToUser(ReceivedMessage message, String user) {
        String[] u = user.split(SEPARATOR);
        if (u.length != 2) {
            logger.warn("Invlid user name " + user);
            return;
        }
        long chatId = this.getUserChatId(u[0], u[1]);
        if (chatId < 0L) {
            logger.warn("No chat id for user {} {}", (Object)u[0], (Object)u[1]);
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(message.getAppName()).append(": ").append(message.getOriginalMessage().title(OgemaLocale.ENGLISH)).append("\n").append(message.getOriginalMessage().message(OgemaLocale.ENGLISH));
        JSONObject data = new JSONObject();
        data.put("text", (Object)sb.toString());
        data.put("chat_id", chatId);
        StringEntity body = new StringEntity(data.toString(), StandardCharsets.UTF_8);
        String url = TelegramConnectorApp.getURL("sendMessage");
        if (url == null) {
            return;
        }
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)body);
        post.setHeader("Content-Type", "application/json");
        if (logger.isTraceEnabled()) {
            logger.trace("Sending message to  " + post.getURI() + ", content:\n" + data);
        }
        try (CloseableHttpClient client = TelegramConnectorApp.getClient();
             CloseableHttpResponse resp = client.execute((HttpUriRequest)post);){
            StatusLine sl = resp.getStatusLine();
            if (logger.isDebugEnabled()) {
                logger.debug("Telegram message sent, {}: {}", (Object)sl.getStatusCode(), (Object)sl.getReasonPhrase());
            }
            if (sl.getStatusCode() >= 300) {
                logger.warn("Status code not ok, {}: {}", (Object)sl.getStatusCode(), (Object)sl.getReasonPhrase());
                return;
            }
        }
        catch (IOException | SecurityException e) {
            logger.error("Telegram provider failed", (Throwable)e);
            return;
        }
    }

    private void parseMessages(JSONArray array) {
        for (int i = 0; i < array.length(); ++i) {
            JSONObject obj = array.getJSONObject(i).getJSONObject("message").getJSONObject("chat");
            String fn = obj.getString("first_name");
            String ln = obj.getString("last_name");
            long id = obj.getLong("id");
            TelegramContact c = (TelegramContact)this.getUser(fn, ln).create();
            ((StringResource)c.firstName().create()).setValue(fn);
            ((StringResource)c.lastName().create()).setValue(ln);
            ((TimeResource)c.chatId().create()).setValue(id);
            c.activate(true);
        }
    }

    private long getUserChatId(String firstName, String lastName) {
        TelegramContact tc = this.getUser(firstName, lastName);
        if (!tc.isActive() || !tc.chatId().isActive()) {
            return -1L;
        }
        return tc.chatId().getValue();
    }

    private TelegramContact getUser(String firstName, String lastName) {
        TelegramContact c = (TelegramContact)this.contactList.getSubResource(firstName + SEPARATOR + lastName, TelegramContact.class);
        return c;
    }

    public List<String> getKnownUsers() {
        if (System.currentTimeMillis() - this.lastUpdate > 15000L) {
            this.updateStatus();
        }
        ArrayList<String> l = new ArrayList<String>();
        ResourceList<TelegramContact> list = this.contactList;
        if (list == null) {
            return Collections.emptyList();
        }
        for (TelegramContact tc : list.getAllElements()) {
            if (!tc.isActive()) continue;
            l.add(tc.firstName().getValue() + SEPARATOR + tc.lastName().getValue());
        }
        return l;
    }

    private static final String getURL(String command) {
        String botKey = Constants.BOT_KEY;
        if (botKey == null) {
            return null;
        }
        return "https://api.telegram.org/bot" + botKey.trim() + "/" + command;
    }

    static CloseableHttpClient getClient() {
        return HttpClients.createDefault();
    }
}

