/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.messaging.telegram.connector;

import de.iwes.widgets.api.extended.OgemaWidgetBase;
import de.iwes.widgets.api.extended.WidgetData;
import de.iwes.widgets.api.extended.html.bricks.PageSnippet;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.dynamics.TriggeredAction;
import de.iwes.widgets.api.widgets.dynamics.TriggeringAction;
import de.iwes.widgets.api.widgets.html.HtmlItem;
import de.iwes.widgets.api.widgets.html.StaticTable;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.alert.Alert;
import de.iwes.widgets.html.buttonconfirm.ButtonConfirm;
import de.iwes.widgets.html.buttonconfirm.ButtonConfirmData;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.html.form.button.Button;
import de.iwes.widgets.html.form.label.Header;
import de.iwes.widgets.html.form.textfield.TextField;
import de.iwes.widgets.html.form.textfield.ValueInputField;
import de.iwes.widgets.html.html5.TemplateGrid;
import de.iwes.widgets.html.popup.Popup;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ogema.core.model.ResourceList;
import org.ogema.core.model.simple.StringResource;
import org.ogema.core.model.simple.TimeResource;
import org.ogema.messaging.telegram.connector.TelegramContact;
import org.ogema.tools.resource.util.ResourceUtils;

class ContactsPage {
    private final WidgetPage<?> page;
    private final Header header;
    private final Alert alert;
    private final TemplateGrid<TelegramContact> contacts;
    private final Button openCreatePopup;
    private final TextField firstName;
    private final TextField lastName;
    private final ValueInputField<Long> chatId;
    private final Button createSubmit;
    private final Popup createPopup;

    public ContactsPage(WidgetPage<?> page, final ResourceList<TelegramContact> contactList) {
        this.page = page;
        this.header = new Header(page, "header", "Telegram contacts");
        this.header.setDefaultColor("blue");
        this.header.addDefaultStyle(WidgetData.TEXT_ALIGNMENT_LEFT);
        this.alert = new Alert(page, "alert", "");
        this.alert.setDefaultVisibility(false);
        RowTemplate<TelegramContact> contactsTemplate = new RowTemplate<TelegramContact>(){
            final Map<String, Object> header;
            {
                LinkedHashMap<String, String> headerLocal = new LinkedHashMap<String, String>();
                headerLocal.put("name", "User");
                headerLocal.put("chatid", "Chat id");
                headerLocal.put("delete", "Delete");
                this.header = Collections.unmodifiableMap(headerLocal);
            }

            public String getLineId(TelegramContact object) {
                return ResourceUtils.getValidResourceName((String)object.getPath());
            }

            public Map<String, Object> getHeader() {
                return this.header;
            }

            public RowTemplate.Row addRow(final TelegramContact object, OgemaHttpRequest req) {
                RowTemplate.Row row = new RowTemplate.Row();
                String lineId = this.getLineId(object);
                String fullName = object.firstName().getValue() + " " + object.lastName().getValue();
                row.addCell("name", (Object)fullName);
                row.addCell("chatid", (Object)object.chatId().getValue());
                ButtonConfirm delete = new ButtonConfirm((OgemaWidget)ContactsPage.this.contacts, "delete_" + lineId, req){

                    public void onPOSTComplete(String data, OgemaHttpRequest req) {
                        object.delete();
                    }
                };
                delete.triggerAction((OgemaWidget)ContactsPage.this.contacts, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST, req);
                delete.setConfirmBtnMsg("Delete", req);
                delete.setConfirmMsg("Do you really want to delete the user " + fullName, req);
                delete.setConfirmPopupTitle("Delete user", req);
                delete.setCancelBtnMsg("Cancel", req);
                delete.setText("Delete user", req);
                delete.addStyle(ButtonConfirmData.CONFIRM_RED, req);
                delete.addStyle(ButtonConfirmData.CONFIRM_LIGHT_BLUE, req);
                row.addCell("delete", (Object)delete);
                return row;
            }
        };
        this.contacts = new TemplateGrid<TelegramContact>(page, "contacts", false, (RowTemplate)contactsTemplate){

            public void onGET(OgemaHttpRequest req) {
                this.update(contactList.getAllElements(), req);
            }
        };
        this.contacts.setDefaultAppendFillColumn(true);
        this.contacts.setDefaultColumnGap("3em");
        this.contacts.setDefaultRowGap("1em");
        this.openCreatePopup = new Button(page, "openCreatePopup", "Create new receiver");
        this.firstName = new TextField(page, "firstName");
        this.lastName = new TextField(page, "lastName");
        this.chatId = new ValueInputField(page, "chatId", Long.class);
        this.createSubmit = new Button(page, "createSubmit", "Submit"){

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                String first = ContactsPage.this.firstName.getValue(req).trim();
                String last = ContactsPage.this.lastName.getValue(req).trim();
                Long chat = (Long)ContactsPage.this.chatId.getNumericalValue(req);
                if (first.isEmpty() && last.isEmpty()) {
                    ContactsPage.this.alert.showAlert("Please enter a name", false, req);
                    return;
                }
                if (chat == null) {
                    ContactsPage.this.alert.showAlert("Please enter your chat id", false, req);
                    return;
                }
                if (contactList.getAllElements().stream().filter(c -> first.equalsIgnoreCase(c.firstName().getValue()) && last.equalsIgnoreCase(c.lastName().getValue())).findAny().isPresent()) {
                    ContactsPage.this.alert.showAlert("User " + first + " " + last + " already exists", false, req);
                    return;
                }
                if (contactList.getAllElements().stream().filter(c -> chat.longValue() == c.chatId().getValue()).findAny().isPresent()) {
                    ContactsPage.this.alert.showAlert("Contact with chat id " + chat + " already exists", false, req);
                    return;
                }
                TelegramContact contact = (TelegramContact)contactList.add();
                ((StringResource)contact.firstName().create()).setValue(first);
                ((StringResource)contact.lastName().create()).setValue(last);
                ((TimeResource)contact.chatId().create()).setValue(chat.longValue());
                contact.activate(true);
                ContactsPage.this.alert.showAlert("New telegram contact has been created: " + first + " " + last, true, req);
            }
        };
        this.createPopup = new Popup(page, "createPopup", true);
        PageSnippet createBody = new PageSnippet(page, "createBody", true);
        int row = 0;
        StaticTable table = new StaticTable(3, 2).setContent(row, 0, "First name").setContent(row++, 1, (OgemaWidget)this.firstName).setContent(row, 0, "Last name").setContent(row++, 1, (OgemaWidget)this.lastName).setContent(row, 0, "Chat id").setContent(row++, 1, this.chatId);
        createBody.append((HtmlItem)table, null);
        this.createPopup.setBody((OgemaWidgetBase)createBody, null);
        this.createPopup.setFooter((OgemaWidgetBase)this.createSubmit, null);
        this.createPopup.setTitle("Create new Telegram receiver", null);
        this.buildPage();
        this.setDependencies();
    }

    private final void buildPage() {
        this.page.append((OgemaWidget)this.header).linebreak().append((OgemaWidget)this.alert).linebreak().append((OgemaWidget)this.openCreatePopup).linebreak().append(this.contacts).linebreak().append((OgemaWidget)this.createPopup);
    }

    private final void setDependencies() {
        this.openCreatePopup.triggerAction((OgemaWidget)this.createPopup, TriggeringAction.POST_REQUEST, TriggeredAction.SHOW_WIDGET);
        this.createSubmit.triggerAction((OgemaWidget)this.alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        this.createSubmit.triggerAction(this.contacts, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
    }
}

